#!/usr/bin/env php
<?php

/**
 * Test Email Sending
 * 
 * This script tests if emails can be sent with current configuration
 */

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "📧 Testing Email Configuration\n";
echo "==============================\n\n";

// Check mail configuration
echo "Current Mail Configuration:\n";
echo "- MAIL_MAILER: " . config('mail.default') . "\n";
echo "- MAIL_HOST: " . config('mail.mailers.smtp.host') . "\n";
echo "- MAIL_PORT: " . config('mail.mailers.smtp.port') . "\n";
echo "- MAIL_USERNAME: " . config('mail.mailers.smtp.username') . "\n";
echo "- MAIL_ENCRYPTION: " . config('mail.mailers.smtp.encryption') . "\n";
echo "- MAIL_FROM_ADDRESS: " . config('mail.from.address') . "\n";
echo "- MAIL_FROM_NAME: " . config('mail.from.name') . "\n\n";

// Check if mail driver is 'log'
if (config('mail.default') === 'log') {
    echo "⚠️  WARNING: Mail driver is set to 'log'\n";
    echo "   Emails will be logged to storage/logs/laravel.log instead of being sent.\n";
    echo "   To send real emails, set MAIL_MAILER=smtp in .env\n\n";
} else {
    echo "✅ Mail driver is set to: " . config('mail.default') . "\n\n";
}

// Test sending a simple email
echo "Testing email sending...\n";
try {
    \Illuminate\Support\Facades\Mail::raw('This is a test email from Qaya HR', function ($message) {
        $message->to('test@example.com')
            ->subject('Test Email - Qaya HR');
    });
    
    if (config('mail.default') === 'log') {
        echo "✅ Email logged successfully (check storage/logs/laravel.log)\n";
    } else {
        echo "✅ Email sent successfully!\n";
    }
} catch (\Exception $e) {
    echo "❌ Failed to send email\n";
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}

echo "\n";
echo "Next Steps:\n";
echo "1. If mail driver is 'log', change MAIL_MAILER=smtp in .env\n";
echo "2. Run: php artisan config:clear\n";
echo "3. Try creating an organization again\n";
echo "4. Check logs: tail -f storage/logs/laravel.log\n";
