<?php $__env->startSection('title', 'System Audit Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2>System Audit Dashboard</h2>
                <div>
                    <select class="form-select d-inline-block w-auto" id="daysFilter">
                        <option value="7" <?php echo e($days == 7 ? 'selected' : ''); ?>>Last 7 days</option>
                        <option value="30" <?php echo e($days == 30 ? 'selected' : ''); ?>>Last 30 days</option>
                        <option value="90" <?php echo e($days == 90 ? 'selected' : ''); ?>>Last 90 days</option>
                    </select>
                    <a href="<?php echo e(route('system-admin.audit-logs.index')); ?>" class="btn btn-primary ms-2">
                        <i class="bi bi-list"></i> View All Logs
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Overall Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?php echo e(number_format($overallStats['total_activities'])); ?></h4>
                            <p class="mb-0">Total Activities</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-list fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?php echo e($topOrganizations->count()); ?></h4>
                            <p class="mb-0">Active Organizations</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-building fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?php echo e($securityAlerts->count()); ?></h4>
                            <p class="mb-0">Security Alerts</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-shield-alt fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?php echo e($overallStats['by_category']['compliance'] ?? 0); ?></h4>
                            <p class="mb-0">Compliance Events</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-clipboard-check fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Security Alerts -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Recent Security Alerts</h5>
                </div>
                <div class="card-body">
                    <?php $__empty_1 = true; $__currentLoopData = $securityAlerts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="d-flex justify-content-between align-items-center mb-3 p-2 border-start border-danger border-3">
                            <div>
                                <strong><?php echo e($alert->description); ?></strong><br>
                                <small class="text-muted">
                                    <?php echo e($alert->organization ? $alert->organization->name : 'System'); ?> • 
                                    <?php echo e($alert->created_at->diffForHumans()); ?>

                                </small>
                            </div>
                            <span class="badge bg-<?php echo e($alert->severity_color); ?>"><?php echo e(ucfirst($alert->severity)); ?></span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-muted text-center">No security alerts in the selected period.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Top Organizations by Activity -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Most Active Organizations</h5>
                </div>
                <div class="card-body">
                    <?php $__empty_1 = true; $__currentLoopData = $topOrganizations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $org): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div>
                                <strong><?php echo e($org->organization->name); ?></strong><br>
                                <small class="text-muted"><?php echo e($org->organization->users->count()); ?> users</small>
                            </div>
                            <div class="text-end">
                                <span class="badge bg-primary"><?php echo e(number_format($org->activity_count)); ?> activities</span>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-muted text-center">No organization activity data available.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Organization Statistics -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Organization Activity Overview</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Organization</th>
                                    <th>Users</th>
                                    <th>Total Activities</th>
                                    <th>Security Events</th>
                                    <th>Compliance Events</th>
                                    <th>Avg. Activities/User</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $orgStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <strong><?php echo e($stat['organization']->name); ?></strong>
                                        </td>
                                        <td><?php echo e($stat['organization']->users->count()); ?></td>
                                        <td><?php echo e(number_format($stat['stats']['total_activities'])); ?></td>
                                        <td>
                                            <span class="badge bg-danger">
                                                <?php echo e($stat['stats']['by_category']['security'] ?? 0); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <span class="badge bg-info">
                                                <?php echo e($stat['stats']['by_category']['compliance'] ?? 0); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <?php echo e($stat['organization']->users->count() > 0 
                                                ? number_format($stat['stats']['total_activities'] / $stat['organization']->users->count(), 1) 
                                                : '0'); ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6" class="text-center text-muted">No organization data available.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    $('#daysFilter').on('change', function() {
        const days = $(this).val();
        window.location.href = '<?php echo e(route("system-admin.audit-logs.dashboard")); ?>?days=' + days;
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('systemadmin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/systemadmin/audit-logs/dashboard.blade.php ENDPATH**/ ?>