<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Leave Report</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            margin: 0;
            color: #714b67;
        }
        .meta-info {
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #714b67;
            color: white;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .status-approved {
            color: green;
            font-weight: bold;
        }
        .status-pending {
            color: orange;
            font-weight: bold;
        }
        .status-rejected {
            color: red;
            font-weight: bold;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Leave Report</h1>
        <p><?php echo e(config('app.name')); ?></p>
    </div>

    <div class="meta-info">
        <p><strong>Generated:</strong> <?php echo e(now()->format('F d, Y h:i A')); ?></p>
        <?php if(request('start_date') && request('end_date')): ?>
        <p><strong>Period:</strong> <?php echo e(request('start_date')); ?> to <?php echo e(request('end_date')); ?></p>
        <?php endif; ?>
        <?php if(request('department_id')): ?>
        <p><strong>Department:</strong> <?php echo e($departments->find(request('department_id'))->name ?? 'All'); ?></p>
        <?php endif; ?>
    </div>

    <table>
        <thead>
            <tr>
                <th>Employee</th>
                <th>Department</th>
                <th>Leave Type</th>
                <th>Start Date</th>
                <th>End Date</th>
                <th>Days</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $leaves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leave): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($leave->employee->first_name); ?> <?php echo e($leave->employee->last_name); ?></td>
                <td><?php echo e($leave->employee->department?->name); ?></td>
                <td><?php echo e($leave->leaveType->name); ?></td>
                <td><?php echo e($leave->start_date); ?></td>
                <td><?php echo e($leave->end_date); ?></td>
                <td><?php echo e($leave->days); ?></td>
                <td class="status-<?php echo e($leave->status); ?>"><?php echo e(ucfirst($leave->status)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="footer">
        <p>This is a system-generated report. Generated on <?php echo e(now()->format('F d, Y h:i A')); ?></p>
    </div>
</body>
</html>
<?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/exports/leave-pdf.blade.php ENDPATH**/ ?>