<?php $__env->startSection('title', 'Loan Policy Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <?php if (isset($component)) { $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-header','data' => ['title' => 'Loan Policy Settings','description' => 'Configure loan policies and limits']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Loan Policy Settings','description' => 'Configure loan policies and limits']); ?>
                 <?php $__env->slot('actions', null, []); ?> 
                    <a href="<?php echo e(route('loan-settings.edit')); ?>" class="btn btn-primary">
                        <i class="fas fa-edit"></i> Edit Settings
                    </a>
                    <form action="<?php echo e(route('loan-settings.reset')); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-warning" onclick="return confirm('Reset all settings to defaults?')">
                            <i class="fas fa-undo"></i> Reset to Defaults
                        </button>
                    </form>
                 <?php $__env->endSlot(); ?>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $attributes = $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $component = $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>

            <?php if (isset($component)) { $__componentOriginal5194778a3a7b899dcee5619d0610f5cf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5194778a3a7b899dcee5619d0610f5cf = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.alert','data' => ['type' => 'success','message' => session('success')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'success','message' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(session('success'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5194778a3a7b899dcee5619d0610f5cf)): ?>
<?php $attributes = $__attributesOriginal5194778a3a7b899dcee5619d0610f5cf; ?>
<?php unset($__attributesOriginal5194778a3a7b899dcee5619d0610f5cf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5194778a3a7b899dcee5619d0610f5cf)): ?>
<?php $component = $__componentOriginal5194778a3a7b899dcee5619d0610f5cf; ?>
<?php unset($__componentOriginal5194778a3a7b899dcee5619d0610f5cf); ?>
<?php endif; ?>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <!-- Loan Limits -->
                        <div class="col-md-6">
                            <h5 class="text-primary">Loan Limits & Eligibility</h5>
                            <table class="table table-sm">
                                <tr>
                                    <td>Maximum Loan Amount:</td>
                                    <td><strong>KES <?php echo e(number_format($settings->max_loan_amount, 2)); ?></strong></td>
                                </tr>
                                <tr>
                                    <td>Maximum Loan Term:</td>
                                    <td><strong><?php echo e($settings->max_loan_term_months); ?> months</strong></td>
                                </tr>
                                <tr>
                                    <td>Minimum Employment Tenure:</td>
                                    <td><strong><?php echo e($settings->min_employment_tenure_months); ?> months</strong></td>
                                </tr>
                                <tr>
                                    <td>Maximum Outstanding Loans:</td>
                                    <td><strong><?php echo e($settings->max_outstanding_loans); ?></strong></td>
                                </tr>
                                <tr>
                                    <td>Loan-to-Salary Ratio:</td>
                                    <td><strong><?php echo e($settings->loan_to_salary_ratio); ?>x monthly salary</strong></td>
                                </tr>
                            </table>

                            <h6 class="text-secondary mt-3">Interest Rates by Loan Type</h6>
                            <table class="table table-sm table-striped">
                                <thead>
                                    <tr>
                                        <th>Loan Type</th>
                                        <th>Interest Rate</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $settings->default_interest_rates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(ucwords(str_replace('_', ' ', $type))); ?></td>
                                        <td><strong><?php echo e($rate); ?>% per year</strong></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Approval Settings -->
                        <div class="col-md-6">
                            <h5 class="text-success">Approval Settings</h5>
                            <table class="table table-sm">
                                <tr>
                                    <td>Auto-Approve Below:</td>
                                    <td><strong>KES <?php echo e(number_format($settings->auto_approve_below_amount, 2)); ?></strong></td>
                                </tr>
                                <tr>
                                    <td>Require Guarantor Above:</td>
                                    <td><strong>KES <?php echo e(number_format($settings->require_guarantor_above_amount, 2)); ?></strong></td>
                                </tr>
                                <tr>
                                    <td>CEO Approval Threshold:</td>
                                    <td><strong>KES <?php echo e(number_format($settings->ceo_approval_threshold, 2)); ?></strong></td>
                                </tr>
                            </table>

                            <h6 class="text-secondary mt-3">Approval Workflow</h6>
                            <div class="list-group list-group-flush">
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Department Head Approval
                                    <span class="badge bg-<?php echo e($settings->require_department_head_approval ? 'success' : 'secondary'); ?>">
                                        <?php echo e($settings->require_department_head_approval ? 'Required' : 'Optional'); ?>

                                    </span>
                                </div>
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Finance Approval
                                    <span class="badge bg-<?php echo e($settings->require_finance_approval ? 'success' : 'secondary'); ?>">
                                        <?php echo e($settings->require_finance_approval ? 'Required' : 'Optional'); ?>

                                    </span>
                                </div>
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    CEO Approval (Above Threshold)
                                    <span class="badge bg-<?php echo e($settings->require_ceo_approval_above_threshold ? 'success' : 'secondary'); ?>">
                                        <?php echo e($settings->require_ceo_approval_above_threshold ? 'Required' : 'Optional'); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <!-- Loan Policies -->
                        <div class="col-md-6">
                            <h5 class="text-warning">Loan Policies</h5>
                            <div class="list-group list-group-flush">
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Allow Multiple Loans
                                    <span class="badge bg-<?php echo e($settings->allow_multiple_loans ? 'success' : 'danger'); ?>">
                                        <?php echo e($settings->allow_multiple_loans ? 'Yes' : 'No'); ?>

                                    </span>
                                </div>
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Allow Loan with Pending Loan
                                    <span class="badge bg-<?php echo e($settings->allow_loan_with_pending_loan ? 'success' : 'danger'); ?>">
                                        <?php echo e($settings->allow_loan_with_pending_loan ? 'Yes' : 'No'); ?>

                                    </span>
                                </div>
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Allow Early Repayment
                                    <span class="badge bg-<?php echo e($settings->allow_early_repayment ? 'success' : 'danger'); ?>">
                                        <?php echo e($settings->allow_early_repayment ? 'Yes' : 'No'); ?>

                                    </span>
                                </div>
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Allow Payment Holidays
                                    <span class="badge bg-<?php echo e($settings->allow_payment_holidays ? 'success' : 'danger'); ?>">
                                        <?php echo e($settings->allow_payment_holidays ? 'Yes' : 'No'); ?>

                                    </span>
                                </div>
                            </div>
                        </div>

                        <!-- Repayment & Notifications -->
                        <div class="col-md-6">
                            <h5 class="text-info">Repayment & Notifications</h5>
                            <table class="table table-sm">
                                <tr>
                                    <td>Maximum Payment Holidays:</td>
                                    <td><strong><?php echo e($settings->max_payment_holidays); ?></strong></td>
                                </tr>
                                <tr>
                                    <td>Early Repayment Penalty:</td>
                                    <td><strong><?php echo e($settings->early_repayment_penalty_rate); ?>%</strong></td>
                                </tr>
                                <tr>
                                    <td>Notification Days Before Deduction:</td>
                                    <td><strong><?php echo e($settings->notification_days_before); ?> days</strong></td>
                                </tr>
                            </table>

                            <h6 class="text-secondary mt-3">Notifications</h6>
                            <div class="list-group list-group-flush">
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Notify on Approval
                                    <span class="badge bg-<?php echo e($settings->notify_on_approval ? 'success' : 'secondary'); ?>">
                                        <?php echo e($settings->notify_on_approval ? 'Enabled' : 'Disabled'); ?>

                                    </span>
                                </div>
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Notify Before Deduction
                                    <span class="badge bg-<?php echo e($settings->notify_before_deduction ? 'success' : 'secondary'); ?>">
                                        <?php echo e($settings->notify_before_deduction ? 'Enabled' : 'Disabled'); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php if($settings->terms_and_conditions): ?>
                    <div class="row mt-4">
                        <div class="col-12">
                            <h5 class="text-secondary">Terms & Conditions</h5>
                            <div class="card bg-light">
                                <div class="card-body">
                                    <p class="mb-0"><?php echo e($settings->terms_and_conditions); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/loan-settings/index.blade.php ENDPATH**/ ?>