<?php $__env->startSection('title', 'Edit Loan Policy Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Loan Policy Settings</h3>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('loan-settings.update')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <!-- Loan Limits & Eligibility -->
                        <div class="row">
                            <div class="col-12">
                                <h5 class="text-primary mb-3">Loan Limits & Eligibility</h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="max_loan_amount" class="form-label">Maximum Loan Amount (KES)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['max_loan_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="max_loan_amount" name="max_loan_amount" 
                                           value="<?php echo e(old('max_loan_amount', $settings->max_loan_amount)); ?>" 
                                           step="0.01" min="1" required>
                                    <?php $__errorArgs = ['max_loan_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="max_loan_term_months" class="form-label">Maximum Loan Term (Months)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['max_loan_term_months'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="max_loan_term_months" name="max_loan_term_months" 
                                           value="<?php echo e(old('max_loan_term_months', $settings->max_loan_term_months)); ?>" 
                                           min="1" max="120" required>
                                    <?php $__errorArgs = ['max_loan_term_months'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="min_employment_tenure_months" class="form-label">Minimum Employment Tenure (Months)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['min_employment_tenure_months'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="min_employment_tenure_months" name="min_employment_tenure_months" 
                                           value="<?php echo e(old('min_employment_tenure_months', $settings->min_employment_tenure_months)); ?>" 
                                           min="0" max="60" required>
                                    <?php $__errorArgs = ['min_employment_tenure_months'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="max_outstanding_loans" class="form-label">Maximum Outstanding Loans</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['max_outstanding_loans'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="max_outstanding_loans" name="max_outstanding_loans" 
                                           value="<?php echo e(old('max_outstanding_loans', $settings->max_outstanding_loans)); ?>" 
                                           min="1" max="10" required>
                                    <?php $__errorArgs = ['max_outstanding_loans'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="loan_to_salary_ratio" class="form-label">Loan-to-Salary Ratio</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['loan_to_salary_ratio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="loan_to_salary_ratio" name="loan_to_salary_ratio" 
                                           value="<?php echo e(old('loan_to_salary_ratio', $settings->loan_to_salary_ratio)); ?>" 
                                           step="0.1" min="0.1" max="10" required>
                                    <small class="text-muted">Times monthly salary</small>
                                    <?php $__errorArgs = ['loan_to_salary_ratio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Interest Rates by Loan Type -->
                        <div class="row">
                            <div class="col-12">
                                <h5 class="text-primary mb-3">Interest Rates by Loan Type (%)</h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="interest_salary_advance" class="form-label">Salary Advance</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['interest_salary_advance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="interest_salary_advance" name="interest_salary_advance" 
                                           value="<?php echo e(old('interest_salary_advance', $settings->default_interest_rates['salary_advance'] ?? 0)); ?>" 
                                           step="0.01" min="0" max="100" required>
                                    <?php $__errorArgs = ['interest_salary_advance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="interest_emergency" class="form-label">Emergency</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['interest_emergency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="interest_emergency" name="interest_emergency" 
                                           value="<?php echo e(old('interest_emergency', $settings->default_interest_rates['emergency'] ?? 5)); ?>" 
                                           step="0.01" min="0" max="100" required>
                                    <?php $__errorArgs = ['interest_emergency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="interest_personal" class="form-label">Personal</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['interest_personal'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="interest_personal" name="interest_personal" 
                                           value="<?php echo e(old('interest_personal', $settings->default_interest_rates['personal'] ?? 10)); ?>" 
                                           step="0.01" min="0" max="100" required>
                                    <?php $__errorArgs = ['interest_personal'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="interest_education" class="form-label">Education</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['interest_education'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="interest_education" name="interest_education" 
                                           value="<?php echo e(old('interest_education', $settings->default_interest_rates['education'] ?? 8)); ?>" 
                                           step="0.01" min="0" max="100" required>
                                    <?php $__errorArgs = ['interest_education'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="interest_housing" class="form-label">Housing</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['interest_housing'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="interest_housing" name="interest_housing" 
                                           value="<?php echo e(old('interest_housing', $settings->default_interest_rates['housing'] ?? 12)); ?>" 
                                           step="0.01" min="0" max="100" required>
                                    <?php $__errorArgs = ['interest_housing'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="interest_other" class="form-label">Other</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['interest_other'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="interest_other" name="interest_other" 
                                           value="<?php echo e(old('interest_other', $settings->default_interest_rates['other'] ?? 10)); ?>" 
                                           step="0.01" min="0" max="100" required>
                                    <?php $__errorArgs = ['interest_other'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Approval Settings -->
                        <div class="row">
                            <div class="col-12">
                                <h5 class="text-success mb-3">Approval Settings</h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="auto_approve_below_amount" class="form-label">Auto-Approve Below (KES)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['auto_approve_below_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="auto_approve_below_amount" name="auto_approve_below_amount" 
                                           value="<?php echo e(old('auto_approve_below_amount', $settings->auto_approve_below_amount)); ?>" 
                                           step="0.01" min="0" required>
                                    <?php $__errorArgs = ['auto_approve_below_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="require_guarantor_above_amount" class="form-label">Require Guarantor Above (KES)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['require_guarantor_above_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="require_guarantor_above_amount" name="require_guarantor_above_amount" 
                                           value="<?php echo e(old('require_guarantor_above_amount', $settings->require_guarantor_above_amount)); ?>" 
                                           step="0.01" min="0" required>
                                    <?php $__errorArgs = ['require_guarantor_above_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="ceo_approval_threshold" class="form-label">CEO Approval Threshold (KES)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['ceo_approval_threshold'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="ceo_approval_threshold" name="ceo_approval_threshold" 
                                           value="<?php echo e(old('ceo_approval_threshold', $settings->ceo_approval_threshold)); ?>" 
                                           step="0.01" min="0" required>
                                    <?php $__errorArgs = ['ceo_approval_threshold'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="require_department_head_approval" value="0">
                                    <input class="form-check-input" type="checkbox" name="require_department_head_approval" 
                                           id="require_department_head_approval" value="1"
                                           <?php echo e(old('require_department_head_approval', $settings->require_department_head_approval) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="require_department_head_approval">
                                        Require Department Head Approval
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="require_finance_approval" value="0">
                                    <input class="form-check-input" type="checkbox" name="require_finance_approval" 
                                           id="require_finance_approval" value="1"
                                           <?php echo e(old('require_finance_approval', $settings->require_finance_approval) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="require_finance_approval">
                                        Require Finance Approval
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="require_ceo_approval_above_threshold" value="0">
                                    <input class="form-check-input" type="checkbox" name="require_ceo_approval_above_threshold" 
                                           id="require_ceo_approval_above_threshold" value="1"
                                           <?php echo e(old('require_ceo_approval_above_threshold', $settings->require_ceo_approval_above_threshold) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="require_ceo_approval_above_threshold">
                                        Require CEO Approval Above Threshold
                                    </label>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Loan Policies -->
                        <div class="row">
                            <div class="col-12">
                                <h5 class="text-warning mb-3">Loan Policies</h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="allow_multiple_loans" value="0">
                                    <input class="form-check-input" type="checkbox" name="allow_multiple_loans" 
                                           id="allow_multiple_loans" value="1"
                                           <?php echo e(old('allow_multiple_loans', $settings->allow_multiple_loans) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="allow_multiple_loans">
                                        Allow Multiple Loans
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="allow_loan_with_pending_loan" value="0">
                                    <input class="form-check-input" type="checkbox" name="allow_loan_with_pending_loan" 
                                           id="allow_loan_with_pending_loan" value="1"
                                           <?php echo e(old('allow_loan_with_pending_loan', $settings->allow_loan_with_pending_loan) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="allow_loan_with_pending_loan">
                                        Allow Loan with Pending Loan
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="allow_early_repayment" value="0">
                                    <input class="form-check-input" type="checkbox" name="allow_early_repayment" 
                                           id="allow_early_repayment" value="1"
                                           <?php echo e(old('allow_early_repayment', $settings->allow_early_repayment) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="allow_early_repayment">
                                        Allow Early Repayment
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="allow_payment_holidays" value="0">
                                    <input class="form-check-input" type="checkbox" name="allow_payment_holidays" 
                                           id="allow_payment_holidays" value="1"
                                           <?php echo e(old('allow_payment_holidays', $settings->allow_payment_holidays) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="allow_payment_holidays">
                                        Allow Payment Holidays
                                    </label>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Repayment & Notifications -->
                        <div class="row">
                            <div class="col-12">
                                <h5 class="text-info mb-3">Repayment & Notifications</h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="max_payment_holidays" class="form-label">Maximum Payment Holidays</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['max_payment_holidays'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="max_payment_holidays" name="max_payment_holidays" 
                                           value="<?php echo e(old('max_payment_holidays', $settings->max_payment_holidays)); ?>" 
                                           min="0" max="12" required>
                                    <?php $__errorArgs = ['max_payment_holidays'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="early_repayment_penalty_rate" class="form-label">Early Repayment Penalty (%)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['early_repayment_penalty_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="early_repayment_penalty_rate" name="early_repayment_penalty_rate" 
                                           value="<?php echo e(old('early_repayment_penalty_rate', $settings->early_repayment_penalty_rate)); ?>" 
                                           step="0.01" min="0" max="100" required>
                                    <?php $__errorArgs = ['early_repayment_penalty_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="notification_days_before" class="form-label">Notification Days Before Deduction</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['notification_days_before'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="notification_days_before" name="notification_days_before" 
                                           value="<?php echo e(old('notification_days_before', $settings->notification_days_before)); ?>" 
                                           min="1" max="30" required>
                                    <?php $__errorArgs = ['notification_days_before'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="notify_on_approval" value="0">
                                    <input class="form-check-input" type="checkbox" name="notify_on_approval" 
                                           id="notify_on_approval" value="1"
                                           <?php echo e(old('notify_on_approval', $settings->notify_on_approval) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="notify_on_approval">
                                        Notify Employee on Approval
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="notify_before_deduction" value="0">
                                    <input class="form-check-input" type="checkbox" name="notify_before_deduction" 
                                           id="notify_before_deduction" value="1"
                                           <?php echo e(old('notify_before_deduction', $settings->notify_before_deduction) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="notify_before_deduction">
                                        Notify Before Deduction
                                    </label>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Terms & Conditions -->
                        <div class="row">
                            <div class="col-12">
                                <h5 class="text-secondary mb-3">Terms & Conditions</h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="terms_and_conditions" class="form-label">Terms & Conditions (Optional)</label>
                                    <textarea class="form-control <?php $__errorArgs = ['terms_and_conditions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                              id="terms_and_conditions" name="terms_and_conditions" 
                                              rows="4"><?php echo e(old('terms_and_conditions', $settings->terms_and_conditions)); ?></textarea>
                                    <small class="text-muted">These terms will be shown to employees when requesting loans</small>
                                    <?php $__errorArgs = ['terms_and_conditions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Save Settings
                                </button>
                                <a href="<?php echo e(route('loan-settings.index')); ?>" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> Cancel
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/loan-settings/edit.blade.php ENDPATH**/ ?>