<?php $__env->startSection('title', 'Cancel Subscription'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header bg-danger text-white">
                    <h4 class="mb-0"><i class="bi bi-x-circle"></i> Cancel Subscription</h4>
                </div>
                <div class="card-body">
                    <div class="alert alert-warning">
                        <h5><i class="bi bi-exclamation-triangle"></i> Are you sure you want to cancel?</h5>
                        <p class="mb-0">
                            Cancelling your subscription will have the following effects:
                        </p>
                    </div>

                    <div class="mb-4">
                        <h6>Current Subscription Details:</h6>
                        <ul>
                            <li><strong>Plan:</strong> <?php echo e($subscription->plan->name); ?></li>
                            <li><strong>Status:</strong> <?php echo e(ucfirst($subscription->status)); ?></li>
                            <li><strong>Billing Cycle:</strong> <?php echo e(ucfirst($subscription->billing_cycle)); ?></li>
                            <?php if($subscription->current_period_ends_at): ?>
                            <li><strong>Current Period Ends:</strong> <?php echo e($subscription->current_period_ends_at->format('M d, Y')); ?></li>
                            <?php endif; ?>
                        </ul>
                    </div>

                    <div class="mb-4">
                        <h6>What happens when you cancel:</h6>
                        <ul>
                            <li>Your subscription will remain active until <?php echo e($subscription->current_period_ends_at ? $subscription->current_period_ends_at->format('M d, Y') : 'the end of the current period'); ?></li>
                            <li>You'll continue to have access to all features until then</li>
                            <li>No further charges will be made</li>
                            <li>After the period ends, your access will be restricted</li>
                            <li>You can reactivate your subscription anytime before it expires</li>
                        </ul>
                    </div>

                    <div class="alert alert-info">
                        <h6><i class="bi bi-lightbulb"></i> Consider these alternatives:</h6>
                        <ul class="mb-0">
                            <li><a href="<?php echo e(route('subscription.plans')); ?>">Downgrade to a lower plan</a> instead of cancelling</li>
                            <li>Contact support if you're experiencing issues</li>
                            <li>Take a break and reactivate later</li>
                        </ul>
                    </div>

                    <form method="POST" action="<?php echo e(route('subscription.process-cancel')); ?>" id="cancel-form">
                        <?php echo csrf_field(); ?>
                        
                        <div class="mb-3">
                            <label for="cancellation_reason" class="form-label">
                                Why are you cancelling? (Optional)
                            </label>
                            <textarea 
                                class="form-control" 
                                id="cancellation_reason" 
                                name="cancellation_reason" 
                                rows="3"
                                placeholder="Help us improve by telling us why you're cancelling..."></textarea>
                        </div>

                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" id="confirm_cancel" name="confirm_cancel" required>
                            <label class="form-check-label" for="confirm_cancel">
                                I understand that my subscription will be cancelled and I will lose access after <?php echo e($subscription->current_period_ends_at ? $subscription->current_period_ends_at->format('M d, Y') : 'the current period ends'); ?>

                            </label>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-danger" id="cancel-button">
                                <i class="bi bi-x-circle"></i> Yes, Cancel Subscription
                            </button>
                            <a href="<?php echo e(route('subscription.show')); ?>" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-left"></i> Keep Subscription
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.getElementById('cancel-form').addEventListener('submit', function(e) {
    const button = document.getElementById('cancel-button');
    button.disabled = true;
    button.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Cancelling...';
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/organization/subscription/cancel.blade.php ENDPATH**/ ?>