<?php $__env->startSection('title', 'Organization Audit Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2>Audit Dashboard</h2>
                <div>
                    <select class="form-select d-inline-block w-auto" id="daysFilter">
                        <option value="7" <?php echo e($days == 7 ? 'selected' : ''); ?>>Last 7 days</option>
                        <option value="30" <?php echo e($days == 30 ? 'selected' : ''); ?>>Last 30 days</option>
                        <option value="90" <?php echo e($days == 90 ? 'selected' : ''); ?>>Last 90 days</option>
                    </select>
                    <a href="<?php echo e(route('organization.audit-logs.index')); ?>" class="btn btn-primary ms-2">
                        <i class="bi bi-list"></i> View All Logs
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?php echo e(number_format($statistics['total_activities'])); ?></h4>
                            <p class="mb-0">Total Activities</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-list fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?php echo e($topUsers->count()); ?></h4>
                            <p class="mb-0">Active Users</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-users fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?php echo e($criticalActivities->count()); ?></h4>
                            <p class="mb-0">Critical Events</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-exclamation-triangle fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?php echo e($complianceActivities->count()); ?></h4>
                            <p class="mb-0">Compliance Events</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-clipboard-check fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Critical Activities -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Recent Critical Activities</h5>
                </div>
                <div class="card-body">
                    <?php $__empty_1 = true; $__currentLoopData = $criticalActivities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="d-flex justify-content-between align-items-center mb-3 p-2 border-start border-warning border-3">
                            <div>
                                <strong><?php echo e($activity->description); ?></strong><br>
                                <small class="text-muted">
                                    <?php echo e($activity->user ? $activity->user->name : 'System'); ?> • 
                                    <?php echo e($activity->created_at->diffForHumans()); ?>

                                </small>
                            </div>
                            <span class="badge bg-<?php echo e($activity->severity_color); ?>"><?php echo e(ucfirst($activity->severity)); ?></span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-muted text-center">No critical activities in the selected period.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Top Active Users -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Most Active Users</h5>
                </div>
                <div class="card-body">
                    <?php $__empty_1 = true; $__currentLoopData = $topUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userActivity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div>
                                <strong><?php echo e($userActivity->user->name); ?></strong><br>
                                <small class="text-muted"><?php echo e($userActivity->user->email); ?></small>
                            </div>
                            <div class="text-end">
                                <span class="badge bg-primary"><?php echo e(number_format($userActivity->activity_count)); ?> activities</span>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-muted text-center">No user activity data available.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Department Statistics -->
    <?php if(!empty($departmentStats)): ?>
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Department Activity</h5>
                </div>
                <div class="card-body">
                    <?php $__currentLoopData = $departmentStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deptStat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div>
                                <strong><?php echo e($deptStat['department']->name); ?></strong>
                            </div>
                            <div>
                                <span class="badge bg-secondary"><?php echo e(number_format($deptStat['activity_count'])); ?> activities</span>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        <!-- Compliance Activities -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Recent Compliance Activities</h5>
                </div>
                <div class="card-body">
                    <?php $__empty_1 = true; $__currentLoopData = $complianceActivities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compliance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="mb-3 p-2 border-start border-info border-3">
                            <strong><?php echo e($compliance->description); ?></strong><br>
                            <small class="text-muted">
                                <?php echo e($compliance->user ? $compliance->user->name : 'System'); ?> • 
                                <?php echo e($compliance->created_at->diffForHumans()); ?>

                            </small>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-muted text-center">No compliance activities in the selected period.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Activity Categories Chart -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Activity Categories</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php $__currentLoopData = $statistics['by_category']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $count): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-2 col-sm-4 col-6 mb-3">
                                <div class="text-center">
                                    <h4 class="text-primary"><?php echo e($count); ?></h4>
                                    <p class="mb-0 small"><?php echo e(ucfirst(str_replace('_', ' ', $category))); ?></p>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    $('#daysFilter').on('change', function() {
        const days = $(this).val();
        window.location.href = '<?php echo e(route("organization.audit-logs.dashboard")); ?>?days=' + days;
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/organization/audit-logs/dashboard.blade.php ENDPATH**/ ?>