<?php $__env->startSection('title', 'Employee Documents'); ?>
<?php $__env->startSection('page-title', 'Employee Documents'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-4">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_employees')): ?>
                <li class="breadcrumb-item"><a href="<?php echo e(route('employees.index')); ?>">Employees</a></li>
                <?php else: ?>
                <li class="breadcrumb-item">Employees</li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_employee_details')): ?>
                <li class="breadcrumb-item"><a href="<?php echo e(route('employees.show', $employee)); ?>"><?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?></a></li>
                <?php else: ?>
                <li class="breadcrumb-item"><?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?></li>
                <?php endif; ?>
                <li class="breadcrumb-item active">Documents</li>
            </ol>
        </nav>
    </div>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4>Documents - <?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?></h4>
            <p class="text-muted mb-0"><?php echo e($employee->employee_code); ?></p>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create_employees')): ?>
        <a href="<?php echo e(route('employees.documents.create', $employee)); ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Upload Document
        </a>
        <?php endif; ?>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <i class="bi bi-check-circle"></i> <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <i class="bi bi-exclamation-triangle"></i> <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="row">
        <?php $__empty_1 = true; $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-md-4 mb-4">
                <div class="card h-100 shadow-sm">
                    <div class="card-header bg-light d-flex justify-content-between align-items-center">
                        <span class="badge
                            <?php if($document->type == 'contract'): ?> bg-primary
                            <?php elseif($document->type == 'certificate'): ?> bg-success
                            <?php elseif($document->type == 'id_document'): ?> bg-info
                            <?php else: ?> bg-secondary
                            <?php endif; ?>">
                            <?php echo e(ucwords(str_replace('_', ' ', $document->type))); ?>

                        </span>
                        <?php if($document->expiry_date && $document->expiry_date < now()): ?>
                            <span class="badge bg-danger">Expired</span>
                        <?php elseif($document->expiry_date && $document->expiry_date < now()->addDays(30)): ?>
                            <span class="badge bg-warning">Expiring Soon</span>
                        <?php endif; ?>
                    </div>
                    <div class="card-body">
                        <h6 class="card-title">
                            <i class="bi bi-file-earmark-text"></i> <?php echo e($document->title); ?>

                        </h6>
                        <?php if($document->description): ?>
                            <p class="card-text text-muted small"><?php echo e($document->description); ?></p>
                        <?php endif; ?>
                        <div class="small text-muted">
                            <div class="mb-1">
                                <i class="bi bi-file-binary"></i> <?php echo e(strtoupper($document->file_type)); ?>

                                <span class="ms-2"><?php echo e($document->file_size_formatted); ?></span>
                            </div>
                            <?php if($document->issue_date): ?>
                                <div class="mb-1">
                                    <i class="bi bi-calendar-event"></i> Issued: <?php echo e($document->issue_date->format('M d, Y')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if($document->expiry_date): ?>
                                <div class="mb-1">
                                    <i class="bi bi-calendar-x"></i> Expires: <?php echo e($document->expiry_date->format('M d, Y')); ?>

                                </div>
                            <?php endif; ?>
                            <div class="mb-1">
                                <i class="bi bi-person"></i> By: <?php echo e($document->uploadedBy->name ?? 'Unknown'); ?>

                            </div>
                            <div>
                                <i class="bi bi-clock"></i> <?php echo e($document->created_at->diffForHumans()); ?>

                            </div>
                        </div>
                    </div>
                    <div class="card-footer bg-white d-flex gap-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_employees')): ?>
                        <a href="<?php echo e(route('employees.documents.download', [$employee, $document])); ?>"
                           class="btn btn-sm btn-primary flex-fill">
                            <i class="bi bi-download"></i> Download
                        </a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete_employees')): ?>
                        <form action="<?php echo e(route('employees.documents.destroy', [$employee, $document])); ?>"
                              method="POST"
                              onsubmit="return confirm('Are you sure you want to delete this document?')"
                              class="flex-fill">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-danger w-100">
                                <i class="bi bi-trash"></i> Delete
                            </button>
                        </form>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-12">
                <div class="alert alert-info">
                    <i class="bi bi-info-circle"></i> No documents uploaded yet. Click "Upload Document" to add one.
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/employees/documents/index.blade.php ENDPATH**/ ?>