<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'user',
    'size' => 'md',
    'showName' => false,
    'showDetails' => false,
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'user',
    'size' => 'md',
    'showName' => false,
    'showDetails' => false,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    $sizes = [
        'sm' => 32,
        'md' => 40,
        'lg' => 64,
        'xl' => 100,
    ];
    
    $pixelSize = $sizes[$size] ?? 40;
    $fontSize = $pixelSize / 2.5;
    
    // Get initials
    $firstName = $user->first_name ?? $user->name ?? '';
    $lastName = $user->last_name ?? '';
    $initials = strtoupper(substr($firstName, 0, 1) . substr($lastName, 0, 1));
    
    // Get full name
    $fullName = $user->full_name ?? $user->name ?? 'Unknown';
    
    // Get photo
    $photo = $user->photo ?? null;
?>

<div class="d-flex align-items-center <?php echo e($attributes->get('class')); ?>">
    <?php if($photo): ?>
        <img src="<?php echo e(asset('storage/' . $photo)); ?>"
             alt="<?php echo e($fullName); ?>"
             class="rounded-circle <?php echo e($showName || $showDetails ? 'me-2' : ''); ?>"
             style="width: <?php echo e($pixelSize); ?>px; height: <?php echo e($pixelSize); ?>px; object-fit: cover;">
    <?php else: ?>
        <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center <?php echo e($showName || $showDetails ? 'me-2' : ''); ?>"
             style="width: <?php echo e($pixelSize); ?>px; height: <?php echo e($pixelSize); ?>px; font-size: <?php echo e($fontSize); ?>px;">
            <?php echo e($initials); ?>

        </div>
    <?php endif; ?>
    
    <?php if($showName || $showDetails): ?>
        <div>
            <?php if($showName): ?>
                <div class="fw-medium"><?php echo e($fullName); ?></div>
            <?php endif; ?>
            
            <?php if($showDetails): ?>
                <?php if(isset($user->employee_code)): ?>
                    <small class="text-muted"><?php echo e($user->employee_code); ?></small>
                <?php elseif(isset($user->email)): ?>
                    <small class="text-muted"><?php echo e($user->email); ?></small>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>
<?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/components/user-avatar.blade.php ENDPATH**/ ?>