<?php $__env->startSection('title', 'Training Performance Impact'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Training Performance Impact</h1>
                <div class="btn-group">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\TrainingPerformanceImpact::class)): ?>
                        <a href="<?php echo e(route('training.performance.create')); ?>" class="btn btn-primary">
                            <i class="bi bi-plus"></i> Record Impact
                        </a>
                        <button type="button" class="btn btn-outline-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown">
                            <span class="visually-hidden">Toggle Dropdown</span>
                        </button>
                        <ul class="dropdown-menu">
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('training.performance.analytics')); ?>">
                                    <i class="bi bi-graph-up"></i> View Analytics
                                </a>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <button type="button" class="dropdown-item" data-bs-toggle="modal" data-bs-target="#autoTrackModal">
                                    <i class="bi bi-cpu"></i> Auto-Track Performance
                                </button>
                            </li>
                        </ul>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0"><?php echo e($stats['total_impacts']); ?></h4>
                                    <p class="mb-0">Total Impact Records</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-graph-up fs-2"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0"><?php echo e($stats['positive_impacts']); ?></h4>
                                    <p class="mb-0">Positive Impacts</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-arrow-up-circle fs-2"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0"><?php echo e(number_format($stats['avg_improvement'], 2)); ?></h4>
                                    <p class="mb-0">Avg. Improvement</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-speedometer2 fs-2"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0"><?php echo e($stats['best_program']); ?></h4>
                                    <p class="mb-0">Best Performing Program</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-trophy fs-2"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Filters -->
            <div class="card mb-4">
                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('training.performance.index')); ?>">
                        <div class="row">
                            <div class="col-md-2">
                                <select name="training_program" class="form-select">
                                    <option value="">All Programs</option>
                                    <?php $__currentLoopData = $trainingPrograms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $program): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($program->id); ?>" <?php echo e(request('training_program') == $program->id ? 'selected' : ''); ?>>
                                            <?php echo e($program->title); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="employee" class="form-select">
                                    <option value="">All Employees</option>
                                    <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($employee->id); ?>" <?php echo e(request('employee') == $employee->id ? 'selected' : ''); ?>>
                                            <?php echo e($employee->full_name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from')); ?>" placeholder="From Date">
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to')); ?>" placeholder="To Date">
                            </div>
                            <div class="col-md-2">
                                <select name="impact_type" class="form-select">
                                    <option value="">All Impact Types</option>
                                    <option value="positive" <?php echo e(request('impact_type') == 'positive' ? 'selected' : ''); ?>>Positive</option>
                                    <option value="negative" <?php echo e(request('impact_type') == 'negative' ? 'selected' : ''); ?>>Negative</option>
                                    <option value="neutral" <?php echo e(request('impact_type') == 'neutral' ? 'selected' : ''); ?>>Neutral</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-outline-primary">
                                    <i class="bi bi-funnel"></i> Filter
                                </button>
                                <a href="<?php echo e(route('training.performance.index')); ?>" class="btn btn-outline-secondary">
                                    <i class="bi bi-x-circle"></i> Clear
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Impact Records -->
            <div class="card">
                <div class="card-body">
                    <?php if($impacts->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Employee</th>
                                        <th>Training Program</th>
                                        <th>Before Score</th>
                                        <th>After Score</th>
                                        <th>Improvement</th>
                                        <th>Training Date</th>
                                        <th>Measured Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $impacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $impact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <strong><?php echo e($impact->employee->full_name); ?></strong><br>
                                                <small class="text-muted"><?php echo e($impact->employee->position?->title); ?></small>
                                            </td>
                                            <td>
                                                <strong><?php echo e($impact->trainingProgram->title); ?></strong><br>
                                                <small class="text-muted"><?php echo e($impact->trainingProgram->category->name); ?></small>
                                            </td>
                                            <td>
                                                <span class="badge bg-secondary"><?php echo e(number_format($impact->performance_score_before, 2)); ?></span>
                                            </td>
                                            <td>
                                                <span class="badge bg-primary"><?php echo e(number_format($impact->performance_score_after, 2)); ?></span>
                                            </td>
                                            <td>
                                                <?php
                                                    $improvement = $impact->performance_improvement;
                                                    $color = $improvement > 0 ? 'success' : ($improvement < 0 ? 'danger' : 'secondary');
                                                    $icon = $improvement > 0 ? 'arrow-up' : ($improvement < 0 ? 'arrow-down' : 'dash');
                                                ?>
                                                <span class="badge bg-<?php echo e($color); ?>">
                                                    <i class="bi bi-<?php echo e($icon); ?>"></i> <?php echo e(number_format($improvement, 2)); ?>

                                                    <?php if($impact->performance_improvement_percentage): ?>
                                                        (<?php echo e(number_format($impact->performance_improvement_percentage, 1)); ?>%)
                                                    <?php endif; ?>
                                                </span>
                                            </td>
                                            <td><?php echo e($impact->training_completed_date->format('M j, Y')); ?></td>
                                            <td><?php echo e($impact->performance_measured_date->format('M j, Y')); ?></td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $impact)): ?>
                                                        <a href="<?php echo e(route('training.performance.show', $impact)); ?>" class="btn btn-outline-primary">
                                                            <i class="bi bi-eye"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $impact)): ?>
                                                        <a href="<?php echo e(route('training.performance.edit', $impact)); ?>" class="btn btn-outline-secondary">
                                                            <i class="bi bi-pencil"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            <?php echo e($impacts->appends(request()->query())->links()); ?>

                        </div>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="bi bi-graph-up fs-1 text-muted"></i>
                            <h4 class="mt-3">No Performance Impact Records</h4>
                            <p class="text-muted">No training performance impact records found matching your criteria.</p>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\TrainingPerformanceImpact::class)): ?>
                                <a href="<?php echo e(route('training.performance.create')); ?>" class="btn btn-primary">
                                    Record First Impact
                                </a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Auto-Track Modal -->
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\TrainingPerformanceImpact::class)): ?>
    <div class="modal fade" id="autoTrackModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST" action="<?php echo e(route('training.performance.auto-track')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title">Auto-Track Performance Impact</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="days_after_training" class="form-label">Days After Training Completion</label>
                            <input type="number" class="form-control" id="days_after_training" name="days_after_training" 
                                   value="90" min="30" max="365" required>
                            <div class="form-text">
                                System will look for performance reviews this many days after training completion to measure impact.
                            </div>
                        </div>
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle"></i>
                            This will automatically create performance impact records for completed trainings that have before/after performance reviews available.
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Start Auto-Tracking</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/training/performance/index.blade.php ENDPATH**/ ?>