<?php $__env->startSection('title', 'My Learning Paths'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">My Learning Paths</h1>
                <a href="<?php echo e(route('training.learning-paths.index')); ?>" class="btn btn-outline-primary">
                    <i class="bi bi-search"></i> Browse Learning Paths
                </a>
            </div>

            <?php if($enrollments->count() > 0): ?>
                <div class="row">
                    <?php $__currentLoopData = $enrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 col-lg-4 mb-4">
                            <div class="card h-100">
                                <?php if($enrollment->learningPath->image_path): ?>
                                    <img src="<?php echo e(asset('storage/' . $enrollment->learningPath->image_path)); ?>" 
                                         class="card-img-top" alt="<?php echo e($enrollment->learningPath->title); ?>" 
                                         style="height: 200px; object-fit: cover;">
                                <?php else: ?>
                                    <div class="card-img-top bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                                        <i class="bi bi-map fs-1 text-muted"></i>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="card-body d-flex flex-column">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <h5 class="card-title"><?php echo e($enrollment->learningPath->title); ?></h5>
                                        <span class="badge bg-<?php echo e($enrollment->learningPath->difficulty_color); ?>">
                                            <?php echo e(ucfirst($enrollment->learningPath->difficulty_level)); ?>

                                        </span>
                                    </div>
                                    
                                    <p class="card-text text-muted small flex-grow-1">
                                        <?php echo e(Str::limit($enrollment->learningPath->description, 100)); ?>

                                    </p>
                                    
                                    <!-- Progress Bar -->
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between align-items-center mb-1">
                                            <small class="text-muted">Progress</small>
                                            <small class="text-muted"><?php echo e(number_format($enrollment->progress_percentage, 1)); ?>%</small>
                                        </div>
                                        <div class="progress" style="height: 8px;">
                                            <div class="progress-bar bg-<?php echo e($enrollment->status === 'completed' ? 'success' : 'primary'); ?>" 
                                                 style="width: <?php echo e($enrollment->progress_percentage); ?>%"></div>
                                        </div>
                                    </div>

                                    <!-- Status and Stats -->
                                    <div class="mb-3">
                                        <div class="row text-center">
                                            <div class="col-4">
                                                <small class="text-muted">Status</small><br>
                                                <span class="badge bg-<?php echo e($enrollment->status === 'completed' ? 'success' : ($enrollment->status === 'in_progress' ? 'warning' : 'info')); ?>">
                                                    <?php echo e(ucfirst(str_replace('_', ' ', $enrollment->status))); ?>

                                                </span>
                                            </div>
                                            <div class="col-4">
                                                <small class="text-muted">Current Step</small><br>
                                                <strong><?php echo e($enrollment->current_step); ?>/<?php echo e($enrollment->learningPath->total_steps); ?></strong>
                                            </div>
                                            <div class="col-4">
                                                <small class="text-muted">Duration</small><br>
                                                <strong><?php echo e($enrollment->learningPath->estimated_duration_hours); ?>h</strong>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Enrollment Info -->
                                    <div class="mb-3">
                                        <small class="text-muted">
                                            Enrolled: <?php echo e($enrollment->enrolled_at->format('M j, Y')); ?>

                                            <?php if($enrollment->started_at): ?>
                                                <br>Started: <?php echo e($enrollment->started_at->format('M j, Y')); ?>

                                            <?php endif; ?>
                                            <?php if($enrollment->completed_at): ?>
                                                <br>Completed: <?php echo e($enrollment->completed_at->format('M j, Y')); ?>

                                            <?php endif; ?>
                                        </small>
                                    </div>
                                    
                                    <div class="mt-auto">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <a href="<?php echo e(route('training.learning-paths.show', $enrollment->learningPath)); ?>" 
                                               class="btn btn-outline-primary btn-sm">
                                                <i class="bi bi-eye"></i> View Path
                                            </a>
                                            
                                            <?php if($enrollment->status !== 'completed'): ?>
                                                <a href="<?php echo e(route('training.learning-paths.progress', $enrollment)); ?>" 
                                                   class="btn btn-primary btn-sm">
                                                    <i class="bi bi-play"></i> Continue
                                                </a>
                                            <?php else: ?>
                                                <span class="badge bg-success">
                                                    <i class="bi bi-check-circle"></i> Completed
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center">
                    <?php echo e($enrollments->links()); ?>

                </div>
            <?php else: ?>
                <div class="card">
                    <div class="card-body text-center py-5">
                        <i class="bi bi-map fs-1 text-muted"></i>
                        <h4 class="mt-3">No Learning Paths Yet</h4>
                        <p class="text-muted">You haven't enrolled in any learning paths yet. Start your learning journey today!</p>
                        <a href="<?php echo e(route('training.learning-paths.index')); ?>" class="btn btn-primary">
                            <i class="bi bi-search"></i> Browse Learning Paths
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/training/learning-paths/my-paths.blade.php ENDPATH**/ ?>