<?php $__env->startSection('title', 'Performance Goals'); ?>
<?php $__env->startSection('page-title', 'Performance Goals'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-2">
            <div class="stat-card primary">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-bullseye"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Total Goals</h6>
                        <h3 class="mb-0"><?php echo e($stats['total_goals']); ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card success">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-play-circle"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Active</h6>
                        <h3 class="mb-0"><?php echo e($stats['active_goals']); ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card info">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-check-circle"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Completed</h6>
                        <h3 class="mb-0"><?php echo e($stats['completed_goals']); ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card warning">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-clock"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Overdue</h6>
                        <h3 class="mb-0"><?php echo e($stats['overdue_goals']); ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card secondary">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-graph-up"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Average Progress</h6>
                        <h3 class="mb-0"><?php echo e($stats['average_progress'] ?? 0); ?>%</h3>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters & Actions -->
    <div class="table-card mb-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="mb-0">Performance Goals</h5>
            <div class="btn-group">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\PerformanceGoal::class)): ?>
                <a href="<?php echo e(route('performance.goals.create')); ?>" class="btn btn-primary">
                    <i class="bi bi-plus-circle"></i> New Goal
                </a>
                <?php endif; ?>
                <a href="<?php echo e(route('performance.index')); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Back to Reviews
                </a>
            </div>
        </div>

        <!-- Filter Form -->
        <form method="GET" class="row g-3 mb-4">
            <div class="col-md-3">
                <label class="form-label">Employee</label>
                <select name="employee" class="form-select">
                    <option value="">All Employees</option>
                    <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($employee->id); ?>" <?php echo e(request('employee') == $employee->id ? 'selected' : ''); ?>>
                            <?php echo e($employee->full_name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Type</label>
                <select name="type" class="form-select">
                    <option value="">All Types</option>
                    <option value="individual" <?php echo e(request('type') == 'individual' ? 'selected' : ''); ?>>Individual</option>
                    <option value="team" <?php echo e(request('type') == 'team' ? 'selected' : ''); ?>>Team</option>
                    <option value="company" <?php echo e(request('type') == 'company' ? 'selected' : ''); ?>>Company</option>
                    <option value="development" <?php echo e(request('type') == 'development' ? 'selected' : ''); ?>>Development</option>
                    <option value="project" <?php echo e(request('type') == 'project' ? 'selected' : ''); ?>>Project</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="">All Status</option>
                    <option value="draft" <?php echo e(request('status') == 'draft' ? 'selected' : ''); ?>>Draft</option>
                    <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>>Completed</option>
                    <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                    <option value="overdue" <?php echo e(request('status') == 'overdue' ? 'selected' : ''); ?>>Overdue</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Priority</label>
                <select name="priority" class="form-select">
                    <option value="">All Priorities</option>
                    <option value="low" <?php echo e(request('priority') == 'low' ? 'selected' : ''); ?>>Low</option>
                    <option value="medium" <?php echo e(request('priority') == 'medium' ? 'selected' : ''); ?>>Medium</option>
                    <option value="high" <?php echo e(request('priority') == 'high' ? 'selected' : ''); ?>>High</option>
                    <option value="critical" <?php echo e(request('priority') == 'critical' ? 'selected' : ''); ?>>Critical</option>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">&nbsp;</label>
                <button type="submit" class="btn btn-primary w-100">
                    <i class="bi bi-funnel"></i> Filter
                </button>
            </div>
        </form>

        <!-- Goals Table -->
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Goal</th>
                        <th>Employee</th>
                        <th>Type</th>
                        <th>Priority</th>
                        <th>Progress</th>
                        <th>Target Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $goals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <div>
                                    <div class="fw-bold"><?php echo e($goal->title); ?></div>
                                    <small class="text-muted"><?php echo e(Str::limit($goal->description, 50)); ?></small>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <?php if($goal->employee->photo): ?>
                                        <img src="<?php echo e(asset('storage/' . $goal->employee->photo)); ?>"
                                             alt="<?php echo e($goal->employee->full_name); ?>"
                                             class="rounded-circle me-2"
                                             style="width: 32px; height: 32px; object-fit: cover;">
                                    <?php else: ?>
                                        <div class="rounded-circle me-2 bg-secondary text-white d-flex align-items-center justify-content-center"
                                             style="width: 32px; height: 32px; font-size: 14px;">
                                            <?php echo e(substr($goal->employee->first_name, 0, 1)); ?><?php echo e(substr($goal->employee->last_name, 0, 1)); ?>

                                        </div>
                                    <?php endif; ?>
                                    <div>
                                        <div class="fw-bold"><?php echo e($goal->employee->full_name); ?></div>
                                        <small class="text-muted"><?php echo e($goal->employee->employee_code); ?></small>
                                    </div>
                                </div>
                            </td>
                            <td><span class="badge bg-secondary"><?php echo e(ucfirst($goal->type)); ?></span></td>
                            <td><span class="badge bg-<?php echo e($goal->priority_color); ?>"><?php echo e(ucfirst($goal->priority)); ?></span></td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="progress me-2" style="width: 60px; height: 8px;">
                                        <div class="progress-bar" style="width: <?php echo e($goal->progress_percentage); ?>%"></div>
                                    </div>
                                    <small><?php echo e(number_format($goal->progress_percentage, 0)); ?>%</small>
                                </div>
                            </td>
                            <td>
                                <?php echo e($goal->target_date->format('M d, Y')); ?>

                                <?php if($goal->isOverdue()): ?>
                                    <span class="badge bg-danger ms-1">Overdue</span>
                                <?php endif; ?>
                            </td>
                            <td><span class="badge bg-<?php echo e($goal->status_color); ?>"><?php echo e(ucfirst($goal->status)); ?></span></td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $goal)): ?>
                                    <a href="<?php echo e(route('performance.goals.show', $goal)); ?>"
                                       class="btn btn-outline-primary"
                                       title="View">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $goal)): ?>
                                    <a href="<?php echo e(route('performance.goals.edit', $goal)); ?>"
                                       class="btn btn-outline-secondary"
                                       title="Edit">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $goal)): ?>
                                    <form action="<?php echo e(route('performance.goals.destroy', $goal)); ?>"
                                          method="POST"
                                          class="d-inline"
                                          onsubmit="return confirm('Are you sure you want to delete this goal?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit"
                                                class="btn btn-outline-danger"
                                                title="Delete">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center py-4 text-muted">
                                <i class="bi bi-bullseye fs-1 d-block mb-2"></i>
                                No performance goals found.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="mt-3">
            <?php echo e($goals->links()); ?>

        </div>
    </div>
</div>

<?php if(session('success')): ?>
    <div class="toast-container position-fixed bottom-0 end-0 p-3">
        <div class="toast show" role="alert">
            <div class="toast-header bg-success text-white">
                <i class="bi bi-check-circle me-2"></i>
                <strong class="me-auto">Success</strong>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
            </div>
            <div class="toast-body">
                <?php echo e(session('success')); ?>

            </div>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/performance/goals/index.blade.php ENDPATH**/ ?>