<?php $__env->startSection('title', 'Select Plan'); ?>

<?php $__env->startSection('content'); ?>
<div class="step-indicator">
    <div class="step completed">
        <div class="step-circle"><i class="bi bi-check"></i></div>
        <div class="step-label">Welcome</div>
    </div>
    <div class="step active">
        <div class="step-circle">2</div>
        <div class="step-label">Select Plan</div>
    </div>
    <div class="step">
        <div class="step-circle">3</div>
        <div class="step-label">Payment</div>
    </div>
    <div class="step">
        <div class="step-circle">4</div>
        <div class="step-label">Complete</div>
    </div>
</div>

<h4 class="text-center mb-4">Choose Your Plan</h4>

<?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <?php echo e(session('error')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<form method="POST" action="<?php echo e(route('onboarding.store-plan')); ?>" id="plan-form">
    <?php echo csrf_field(); ?>

    <div class="row mb-4">
        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-4 mb-3">
            <div class="card h-100 plan-card <?php echo e($plan->slug === 'professional' ? 'border-primary' : ''); ?>" 
                 onclick="selectPlan(<?php echo e($plan->id); ?>, '<?php echo e($plan->slug); ?>')">
                <?php if($plan->slug === 'professional'): ?>
                <div class="card-header bg-primary text-white text-center">
                    <small>RECOMMENDED</small>
                </div>
                <?php endif; ?>
                <div class="card-body d-flex flex-column">
                    <h5 class="card-title"><?php echo e($plan->name); ?></h5>
                    <h3 class="text-primary mb-3">
                        KES <?php echo e(number_format($plan->price_monthly, 0)); ?>

                        <small class="text-muted fs-6">/month</small>
                    </h3>
                    
                    <ul class="list-unstyled mb-4">
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            <?php echo e($plan->max_employees ?? 'Unlimited'); ?> Employees
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            <?php echo e($plan->max_users ?? 'Unlimited'); ?> Users
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            <?php echo e($plan->storage_limit_gb ?? 'Unlimited'); ?> GB Storage
                        </li>
                        <?php if($plan->features['api_access'] ?? false): ?>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            API Access
                        </li>
                        <?php endif; ?>
                    </ul>

                    <div class="mt-auto">
                        <div class="form-check">
                            <input class="form-check-input plan-radio" 
                                   type="radio" 
                                   name="plan_id" 
                                   id="plan_<?php echo e($plan->id); ?>" 
                                   value="<?php echo e($plan->id); ?>"
                                   required>
                            <label class="form-check-label" for="plan_<?php echo e($plan->id); ?>">
                                Select this plan
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <h6>Billing Cycle</h6>
            <div class="row">
                <div class="col-md-6">
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="billing_cycle" id="monthly" value="monthly" checked>
                        <label class="form-check-label" for="monthly">
                            <strong>Monthly</strong> - Pay monthly
                        </label>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="billing_cycle" id="annual" value="annual">
                        <label class="form-check-label" for="annual">
                            <strong>Annual</strong> - Save 2 months
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card mb-4 border-success">
        <div class="card-body">
            <div class="form-check">
                <input class="form-check-input" type="checkbox" name="start_with_trial" id="start_with_trial" value="1" checked>
                <label class="form-check-label" for="start_with_trial">
                    <strong><i class="bi bi-gift"></i> Start with 14-day FREE trial</strong>
                    <p class="text-muted mb-0 small">
                        Try all features risk-free. No credit card required. Cancel anytime.
                    </p>
                </label>
            </div>
        </div>
    </div>

    <div class="d-flex gap-2">
        <a href="<?php echo e(route('onboarding.welcome')); ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Back
        </a>
        <button type="submit" class="btn btn-primary flex-grow-1" id="continue-btn">
            <i class="bi bi-arrow-right"></i> Continue
        </button>
    </div>
</form>

<?php $__env->startPush('styles'); ?>
<style>
.plan-card {
    cursor: pointer;
    transition: all 0.3s;
}
.plan-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
}
.plan-card.selected {
    border-color: #714b67 !important;
    border-width: 2px;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function selectPlan(planId, slug) {
    document.getElementById('plan_' + planId).checked = true;
    
    // Remove selected class from all cards
    document.querySelectorAll('.plan-card').forEach(card => {
        card.classList.remove('selected');
    });
    
    // Add selected class to clicked card
    event.currentTarget.classList.add('selected');
}

// Update button text based on trial checkbox
document.getElementById('start_with_trial').addEventListener('change', function() {
    const btn = document.getElementById('continue-btn');
    if (this.checked) {
        btn.innerHTML = '<i class="bi bi-arrow-right"></i> Start Free Trial';
    } else {
        btn.innerHTML = '<i class="bi bi-arrow-right"></i> Continue to Payment';
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('onboarding.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/onboarding/select-plan.blade.php ENDPATH**/ ?>