<?php $__env->startSection('title', 'Trial Expired'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card border-warning">
                <div class="card-header bg-warning text-dark">
                    <h4 class="mb-0"><i class="bi bi-clock-history"></i> Your Trial Has Expired</h4>
                </div>
                <div class="card-body text-center py-5">
                    <i class="bi bi-hourglass-bottom text-warning" style="font-size: 4rem;"></i>
                    <h3 class="mt-3">Your 14-Day Trial Has Ended</h3>
                    <p class="lead text-muted">
                        Thank you for trying Qaya HRM! To continue using all features, please choose a subscription plan below.
                    </p>
                </div>
            </div>

            <!-- Subscription Plans -->
            <div class="row mt-4">
                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-4 mb-4">
                    <div class="card h-100 <?php echo e($plan->slug === 'professional' ? 'border-primary' : ''); ?>">
                        <?php if($plan->slug === 'professional'): ?>
                        <div class="card-header bg-primary text-white text-center">
                            <span class="badge bg-light text-primary">MOST POPULAR</span>
                        </div>
                        <?php endif; ?>
                        <div class="card-body d-flex flex-column">
                            <h4 class="card-title"><?php echo e($plan->name); ?></h4>
                            <p class="text-muted"><?php echo e($plan->description); ?></p>
                            
                            <div class="mb-3">
                                <h2 class="text-primary">
                                    KES <?php echo e(number_format($plan->price_monthly, 0)); ?>

                                    <small class="text-muted fs-6">/month</small>
                                </h2>
                                <p class="text-muted mb-0">
                                    <small>or KES <?php echo e(number_format($plan->price_annual, 0)); ?>/year</small>
                                </p>
                            </div>

                            <ul class="list-unstyled mb-4">
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success"></i>
                                    <?php echo e($plan->max_employees ?? 'Unlimited'); ?> Employees
                                </li>
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success"></i>
                                    <?php echo e($plan->max_users ?? 'Unlimited'); ?> Users
                                </li>
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success"></i>
                                    <?php echo e($plan->storage_limit_gb ?? 'Unlimited'); ?> GB Storage
                                </li>
                                <?php if($plan->features['api_access'] ?? false): ?>
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success"></i>
                                    API Access
                                </li>
                                <?php endif; ?>
                                <?php if($plan->features['white_label'] ?? false): ?>
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success"></i>
                                    White Label
                                </li>
                                <?php endif; ?>
                            </ul>

                            <div class="mt-auto">
                                <a href="<?php echo e(route('subscription.upgrade', $plan)); ?>" 
                                   class="btn <?php echo e($plan->slug === 'professional' ? 'btn-primary' : 'btn-outline-primary'); ?> w-100">
                                    <i class="bi bi-star"></i> Subscribe Now
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="text-center mt-4">
                <p class="text-muted">
                    Need help choosing? <a href="mailto:support@qayahrm.com">Contact our sales team</a>
                </p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/organization/subscription/trial-expired.blade.php ENDPATH**/ ?>