<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0">Choose a Base Theme</h5>
        <p class="text-muted mb-0 small">Select a preset theme as your starting point</p>
    </div>
    <div class="card-body">
        <input type="hidden" name="base_theme" value="<?php echo e($currentTheme); ?>">
        
        <div class="row">
            <?php $__currentLoopData = $presetThemes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $themeKey => $theme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($themeKey !== 'system_admin'): ?> 
            <div class="col-md-4 col-lg-3 mb-3">
                <div class="theme-card <?php echo e($currentTheme === $themeKey ? 'active' : ''); ?>" 
                     data-theme="<?php echo e($themeKey); ?>">
                    <div class="theme-preview" style="background: <?php echo e($theme['colors']['primary']); ?>">
                        <div class="theme-preview-sidebar" 
                             style="background: <?php echo e(is_array($theme['sidebar']) ? $theme['sidebar']['background'] : $theme['sidebar']); ?>">
                        </div>
                        <div class="theme-preview-content">
                            <div class="theme-preview-header"></div>
                            <div class="theme-preview-cards"></div>
                        </div>
                    </div>
                    <div class="theme-card-body">
                        <h6><?php echo e($theme['name']); ?></h6>
                        <button type="button" class="btn btn-sm <?php echo e($currentTheme === $themeKey ? 'btn-primary' : 'btn-outline-primary'); ?>">
                            <?php if($currentTheme === $themeKey): ?>
                                <i class="bi bi-check-circle"></i> Selected
                            <?php else: ?>
                                Select Theme
                            <?php endif; ?>
                        </button>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/settings/theme/partials/preset-themes.blade.php ENDPATH**/ ?>