<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Qaya HRM'); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    
    <!-- Theme CSS: Use static file if available, fallback to inline -->
    <?php if(auth()->check() && auth()->user()->organization_id && file_exists(public_path('storage/themes/org_' . auth()->user()->organization_id . '.css'))): ?>
        <!-- Static Theme CSS (Cached) -->
        <link rel="stylesheet" href="<?php echo e(asset('storage/themes/org_' . auth()->user()->organization_id . '.css')); ?>?v=<?php echo e(filemtime(public_path('storage/themes/org_' . auth()->user()->organization_id . '.css'))); ?>">
    <?php else: ?>
        <!-- Dynamic Theme Injection (Fallback) -->
        <style>
            :root {
                <?php if(isset($themeConfig['colors'])): ?>
                <?php $__currentLoopData = $themeConfig['colors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                --color-<?php echo e($key); ?>: <?php echo e($value); ?>;
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                
                <?php if(isset($themeConfig['sidebar'])): ?>
                --sidebar-bg: <?php echo e($themeConfig['sidebar']['background']); ?>;
                --sidebar-text: <?php echo e($themeConfig['sidebar']['text']); ?>;
                --sidebar-hover: <?php echo e($themeConfig['sidebar']['hover']); ?>;
                --sidebar-active: <?php echo e($themeConfig['sidebar']['active']); ?>;
                <?php endif; ?>
                
                <?php if(isset($themeConfig['fonts'])): ?>
                <?php if($themeConfig['fonts']['primary'] ?? false): ?>
                --font-primary: <?php echo e($themeConfig['fonts']['primary']); ?>;
                <?php endif; ?>
                <?php if($themeConfig['fonts']['heading'] ?? false): ?>
                --font-heading: <?php echo e($themeConfig['fonts']['heading']); ?>;
                <?php endif; ?>
                <?php endif; ?>
            }
            
            <?php if(isset($themeConfig['fonts']['primary']) && $themeConfig['fonts']['primary']): ?>
            body {
                font-family: <?php echo e($themeConfig['fonts']['primary']); ?>, sans-serif;
            }
            <?php endif; ?>
            
            <?php if(isset($themeConfig['fonts']['heading']) && $themeConfig['fonts']['heading']): ?>
            h1, h2, h3, h4, h5, h6 {
                font-family: <?php echo e($themeConfig['fonts']['heading']); ?>, sans-serif;
            }
            <?php endif; ?>
        </style>
        
        <?php if(isset($themeConfig['custom_css']) && $themeConfig['custom_css']): ?>
        <!-- Organization Custom CSS -->
        <style>
            <?php echo $themeConfig['custom_css']; ?>

        </style>
        <?php endif; ?>
    <?php endif; ?>
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <?php echo $__env->make('layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Navbar -->
        <div class="top-navbar">
            <div class="d-flex align-items-center">
                <!-- Mobile Menu Toggle -->
                <button class="btn btn-link d-lg-none me-3 p-0" id="menuToggle">
                    <i class="bi bi-list fs-4 text-dark"></i>
                </button>
                <!-- Hide page title on small screens to save space -->
                <h4 class="mb-0 d-none d-md-block"><?php echo $__env->yieldContent('page-title', 'Dashboard'); ?></h4>
                <!-- Show abbreviated title on mobile -->
                <h5 class="mb-0 d-md-none"><?php echo $__env->yieldContent('mobile-title', 'Dashboard'); ?></h5>
            </div>
            <div class="d-flex align-items-center">
                <!-- Hide welcome text on small screens -->
                <div class="me-3 d-none d-sm-block">
                    <span class="text-muted">
                        Welcome, <strong><?php echo e(auth()->user()->name); ?></strong>
                        <?php if(auth()->user()->roles->isNotEmpty()): ?>
                            <span class="badge bg-primary ms-1"><?php echo e(ucfirst(auth()->user()->roles->first()->name)); ?></span>
                        <?php endif; ?>
                    </span>
                </div>
                <!-- Show only role badge on mobile -->
                <div class="me-2 d-sm-none">
                    <?php if(auth()->user()->roles->isNotEmpty()): ?>
                        <span class="badge bg-primary"><?php echo e(ucfirst(auth()->user()->roles->first()->name)); ?></span>
                    <?php endif; ?>
                </div>
                <div class="dropdown">
                    <button class="btn btn-link text-dark dropdown-toggle" type="button" id="userDropdown" data-bs-toggle="dropdown">
                        <i class="bi bi-person-circle fs-4"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="<?php echo e(route('profile.show')); ?>"><i class="bi bi-person"></i> My Profile</a></li>
                        <?php if(auth()->user()->can('view_settings') || 
                            auth()->user()->can('edit_settings') || 
                            auth()->user()->can('view_organization_settings') || 
                            auth()->user()->can('manage_roles') || 
                            auth()->user()->can('view_users')): ?>
                        <li><a class="dropdown-item" href="<?php echo e(route('settings.index')); ?>"><i class="bi bi-gear"></i> Settings</a></li>
                        <?php endif; ?>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="dropdown-item">
                                    <i class="bi bi-box-arrow-right"></i> Logout
                                </button>
                            </form>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Content Area -->
        <div class="content-area">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/layouts/app.blade.php ENDPATH**/ ?>