<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Application Submitted - <?php echo e($jobPosting->organization->name); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body text-center py-5">
                        <div class="text-success mb-4">
                            <i class="bi bi-check-circle-fill" style="font-size: 4rem;"></i>
                        </div>
                        
                        <?php if(session('updated')): ?>
                            <h2 class="text-success mb-3">Application Updated Successfully!</h2>
                            
                            <p class="text-muted mb-4">
                                Your application for the <strong><?php echo e($jobPosting->title); ?></strong> position has been updated successfully.
                            </p>
                        <?php else: ?>
                            <h2 class="text-success mb-3">Application Submitted Successfully!</h2>
                            
                            <p class="text-muted mb-4">
                                Thank you for applying for the <strong><?php echo e($jobPosting->title); ?></strong> position at <?php echo e($jobPosting->organization->name); ?>.
                            </p>
                        <?php endif; ?>

                        <div class="bg-light p-3 rounded mb-4">
                            <h6 class="mb-2">Application Details:</h6>
                            <div class="row text-start">
                                <div class="col-sm-6">
                                    <small class="text-muted">Applicant:</small><br>
                                    <strong><?php echo e($application->full_name); ?></strong>
                                </div>
                                <div class="col-sm-6">
                                    <small class="text-muted">Position:</small><br>
                                    <strong><?php echo e($jobPosting->title); ?></strong>
                                </div>
                                <div class="col-sm-6 mt-2">
                                    <small class="text-muted">Application ID:</small><br>
                                    <code><?php echo e($application->tracking_token); ?></code>
                                </div>
                                <div class="col-sm-6 mt-2">
                                    <small class="text-muted">Submitted:</small><br>
                                    <strong><?php echo e($application->applied_at->format('M d, Y H:i')); ?></strong>
                                </div>
                            </div>
                        </div>

                        <div class="alert alert-info">
                            <i class="bi bi-info-circle"></i>
                            <strong>What's Next?</strong><br>
                            Our HR team will review your application and contact you if you're selected for the next stage. 
                            Please keep your application ID for future reference.
                        </div>

                        <div class="alert alert-warning">
                            <i class="bi bi-envelope"></i>
                            A confirmation email has been sent to <strong><?php echo e($application->email); ?></strong> with your application details.
                        </div>

                        <div class="alert alert-success">
                            <i class="bi bi-eye"></i>
                            <strong>Track Your Application</strong><br>
                            You can check your application status anytime using the link below:
                            <div class="mt-2">
                                <a href="<?php echo e(route('candidate.track', $application->tracking_token)); ?>" class="btn btn-success btn-sm">
                                    <i class="bi bi-graph-up"></i> View Application Dashboard
                                </a>
                            </div>
                        </div>

                        <div class="mt-4">
                            <?php
                                $websiteUrl = $jobPosting->organization->company_website ?? config('app.url');
                            ?>
                            
                            <a href="<?php echo e($websiteUrl); ?>" class="btn btn-outline-primary me-2">
                                <i class="bi bi-globe"></i> Visit Our Website
                            </a>
                            <button onclick="window.print()" class="btn btn-outline-secondary">
                                <i class="bi bi-printer"></i> Print Confirmation
                            </button>
                        </div>
                    </div>
                </div>

                <div class="text-center mt-4">
                    <p class="text-muted small">
                        <i class="bi bi-shield-check"></i>
                        Your information is secure and will only be used for recruitment purposes.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/recruitment/public/success.blade.php ENDPATH**/ ?>