<?php $__env->startSection('title', 'Leave Requests'); ?>
<?php $__env->startSection('page-title', 'Leave Management'); ?>

<?php $__env->startSection('content'); ?>
    <?php if (isset($component)) { $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-header','data' => ['title' => 'Leave Requests','description' => 'Manage employee leave requests and balances']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Leave Requests','description' => 'Manage employee leave requests and balances']); ?>
         <?php $__env->slot('actions', null, []); ?> 
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', App\Models\LeaveRequest::class)): ?>
            <a href="<?php echo e(route('leaves.calendar')); ?>" class="btn btn-info">
                <i class="bi bi-calendar3"></i> Calendar View
            </a>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\LeaveRequest::class)): ?>
            <a href="<?php echo e(route('leaves.create')); ?>" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> New Leave Request
            </a>
            <?php endif; ?>
         <?php $__env->endSlot(); ?>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $attributes = $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $component = $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>

    <?php if (isset($component)) { $__componentOriginal5194778a3a7b899dcee5619d0610f5cf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5194778a3a7b899dcee5619d0610f5cf = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.alert','data' => ['type' => 'success','message' => session('success')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'success','message' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(session('success'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5194778a3a7b899dcee5619d0610f5cf)): ?>
<?php $attributes = $__attributesOriginal5194778a3a7b899dcee5619d0610f5cf; ?>
<?php unset($__attributesOriginal5194778a3a7b899dcee5619d0610f5cf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5194778a3a7b899dcee5619d0610f5cf)): ?>
<?php $component = $__componentOriginal5194778a3a7b899dcee5619d0610f5cf; ?>
<?php unset($__componentOriginal5194778a3a7b899dcee5619d0610f5cf); ?>
<?php endif; ?>

    <?php if (isset($component)) { $__componentOriginal14f00bb611be156238920ca6c4a4adca = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal14f00bb611be156238920ca6c4a4adca = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.stats-grid','data' => ['stats' => [
        ['value' => $stats['pending'], 'label' => 'Pending Approval', 'icon' => 'clock-history', 'type' => 'warning'],
        ['value' => $stats['approved'], 'label' => 'Approved', 'icon' => 'check-circle', 'type' => 'success'],
        ['value' => $stats['rejected'], 'label' => 'Rejected', 'icon' => 'x-circle', 'type' => 'danger'],
        ['value' => $stats['total_days'], 'label' => 'Total Days This Month', 'icon' => 'calendar-check', 'type' => 'info'],
    ]]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('stats-grid'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['stats' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([
        ['value' => $stats['pending'], 'label' => 'Pending Approval', 'icon' => 'clock-history', 'type' => 'warning'],
        ['value' => $stats['approved'], 'label' => 'Approved', 'icon' => 'check-circle', 'type' => 'success'],
        ['value' => $stats['rejected'], 'label' => 'Rejected', 'icon' => 'x-circle', 'type' => 'danger'],
        ['value' => $stats['total_days'], 'label' => 'Total Days This Month', 'icon' => 'calendar-check', 'type' => 'info'],
    ])]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal14f00bb611be156238920ca6c4a4adca)): ?>
<?php $attributes = $__attributesOriginal14f00bb611be156238920ca6c4a4adca; ?>
<?php unset($__attributesOriginal14f00bb611be156238920ca6c4a4adca); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal14f00bb611be156238920ca6c4a4adca)): ?>
<?php $component = $__componentOriginal14f00bb611be156238920ca6c4a4adca; ?>
<?php unset($__componentOriginal14f00bb611be156238920ca6c4a4adca); ?>
<?php endif; ?>

    <div class="row">
        <div class="col-md-12">
            <div class="table-card">
                <form method="GET" action="<?php echo e(route('leaves.index')); ?>" class="row g-3 mb-4">
                    <div class="col-md-3">
                        <label class="form-label">Employee</label>
                        <select class="form-select" name="employee">
                            <option value="">All Employees</option>
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $emp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($emp->id); ?>" <?php echo e(request('employee') == $emp->id ? 'selected' : ''); ?>>
                                    <?php echo e($emp->full_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Leave Type</label>
                        <select class="form-select" name="leave_type">
                            <option value="">All Types</option>
                            <?php $__currentLoopData = $leaveTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($type->id); ?>" <?php echo e(request('leave_type') == $type->id ? 'selected' : ''); ?>>
                                    <?php echo e($type->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Status</label>
                        <select class="form-select" name="status">
                            <option value="">All Status</option>
                            <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                            <option value="approved" <?php echo e(request('status') == 'approved' ? 'selected' : ''); ?>>Approved</option>
                            <option value="rejected" <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                            <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">From Date</label>
                        <input type="date" class="form-control" name="from_date" value="<?php echo e(request('from_date')); ?>">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">To Date</label>
                        <input type="date" class="form-control" name="to_date" value="<?php echo e(request('to_date')); ?>">
                    </div>
                    <div class="col-md-1 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="bi bi-search"></i>
                        </button>
                    </div>
                </form>

                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Employee</th>
                                <th>Leave Type</th>
                                <th>Duration</th>
                                <th>Days</th>
                                <th>Applied Date</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $leaveRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leave): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <?php if($leave->employee->photo): ?>
                                                <img src="<?php echo e(asset('storage/' . $leave->employee->photo)); ?>"
                                                     alt="<?php echo e($leave->employee->full_name); ?>"
                                                     class="rounded-circle me-2"
                                                     style="width: 32px; height: 32px; object-fit: cover;">
                                            <?php else: ?>
                                                <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center me-2"
                                                     style="width: 32px; height: 32px; font-size: 12px;">
                                                    <?php echo e(substr($leave->employee->first_name, 0, 1)); ?><?php echo e(substr($leave->employee->last_name, 0, 1)); ?>

                                                </div>
                                            <?php endif; ?>
                                            <div>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_employees')): ?>
                                                <a href="<?php echo e(route('employees.show', $leave->employee)); ?>">
                                                    <?php echo e($leave->employee->full_name); ?>

                                                </a>
                                                <?php else: ?>
                                                <?php echo e($leave->employee->full_name); ?>

                                                <?php endif; ?>
                                                <br>
                                                <small class="text-muted"><?php echo e($leave->employee->department->name ?? 'N/A'); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge" style="background-color: <?php echo e($leave->leaveType->color ?? '#6c757d'); ?>">
                                            <?php echo e($leave->leaveType->name); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <?php echo e($leave->start_date->format('M d, Y')); ?>

                                        <i class="bi bi-arrow-right"></i>
                                        <?php echo e($leave->end_date->format('M d, Y')); ?>

                                    </td>
                                    <td>
                                        <strong><?php echo e($leave->number_of_days); ?></strong> days
                                    </td>
                                    <td><?php echo e($leave->created_at->format('M d, Y')); ?></td>
                                    <td>
                                        <span class="badge badge-status-<?php echo e($leave->status); ?>">
                                            <?php echo e(ucfirst($leave->status)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $leave)): ?>
                                            <a href="<?php echo e(route('leaves.show', $leave)); ?>" class="btn btn-outline-primary" title="View">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <?php endif; ?>
                                            <?php if($leave->status == 'pending'): ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $leave)): ?>
                                                <a href="<?php echo e(route('leaves.edit', $leave)); ?>" class="btn btn-outline-secondary" title="Edit">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if($leave->status == 'pending'): ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('approve_leaves')): ?>
                                                <form action="<?php echo e(route('leaves.approve', $leave)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-outline-success" title="Approve">
                                                        <i class="bi bi-check-lg"></i>
                                                    </button>
                                                </form>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('approve_leaves')): ?>
                                                <form action="<?php echo e(route('leaves.reject', $leave)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-outline-danger" title="Reject">
                                                        <i class="bi bi-x-lg"></i>
                                                    </button>
                                                </form>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if($leave->status == 'pending' || $leave->status == 'approved'): ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cancel_leaves')): ?>
                                                <form action="<?php echo e(route('leaves.cancel', $leave)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-outline-warning"
                                                            onclick="return confirm('Cancel this leave request?')" title="Cancel">
                                                        <i class="bi bi-slash-circle"></i>
                                                    </button>
                                                </form>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center py-4">
                                        <i class="bi bi-calendar-x" style="font-size: 48px; color: #ccc;"></i>
                                        <p class="text-muted mt-3 mb-0">No leave requests found</p>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <?php if($leaveRequests->hasPages()): ?>
                    <div class="d-flex justify-content-center mt-4">
                        <?php echo e($leaveRequests->links()); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/leaves/index.blade.php ENDPATH**/ ?>