<?php $__env->startSection('title', 'Payment'); ?>

<?php $__env->startSection('content'); ?>
<div class="step-indicator">
    <div class="step completed">
        <div class="step-circle"><i class="bi bi-check"></i></div>
        <div class="step-label">Welcome</div>
    </div>
    <div class="step completed">
        <div class="step-circle"><i class="bi bi-check"></i></div>
        <div class="step-label">Select Plan</div>
    </div>
    <div class="step active">
        <div class="step-circle">3</div>
        <div class="step-label">Payment</div>
    </div>
    <div class="step">
        <div class="step-circle">4</div>
        <div class="step-label">Complete</div>
    </div>
</div>

<h4 class="text-center mb-4">Complete Your Payment</h4>

<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="mb-0">Selected Plan</h6>
            </div>
            <div class="card-body">
                <h5><?php echo e($subscription->plan->name); ?></h5>
                <p class="text-muted"><?php echo e($subscription->plan->description); ?></p>
                <h3 class="text-primary">
                    KES <?php echo e(number_format($subscription->billing_cycle === 'monthly' ? $subscription->plan->price_monthly : $subscription->plan->price_annual, 0)); ?>

                    <small class="text-muted fs-6">/<?php echo e($subscription->billing_cycle); ?></small>
                </h3>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="mb-0">Invoice Details</h6>
            </div>
            <div class="card-body">
                <p><strong>Invoice:</strong> <?php echo e($invoice->invoice_number); ?></p>
                <p><strong>Due Date:</strong> <?php echo e($invoice->due_date->format('M d, Y')); ?></p>
                <h4 class="text-success">
                    Total: KES <?php echo e(number_format($invoice->total, 2)); ?>

                </h4>
            </div>
        </div>
    </div>
</div>

<div class="card mb-4">
    <div class="card-header bg-success text-white">
        <h6 class="mb-0"><i class="bi bi-phone"></i> Pay with M-Pesa</h6>
    </div>
    <div class="card-body">
        <form method="POST" action="<?php echo e(route('organization.payments.initiate', $invoice)); ?>" id="payment-form">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="onboarding" value="1">
            
            <div class="mb-3">
                <label for="phone_number" class="form-label">M-Pesa Phone Number</label>
                <input type="tel" 
                       class="form-control <?php $__errorArgs = ['phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                       id="phone_number" 
                       name="phone_number" 
                       placeholder="254712345678" 
                       value="<?php echo e(old('phone_number')); ?>"
                       required>
                <div class="form-text">Enter your M-Pesa registered phone number</div>
                <?php $__errorArgs = ['phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            
            <div class="d-grid">
                <button type="submit" class="btn btn-success btn-lg" id="pay-button">
                    <i class="bi bi-phone"></i> Pay KES <?php echo e(number_format($invoice->total, 2)); ?> with M-Pesa
                </button>
            </div>
        </form>
    </div>
</div>

<div class="alert alert-info">
    <h6><i class="bi bi-info-circle"></i> How it works:</h6>
    <ol class="mb-0">
        <li>Click the "Pay with M-Pesa" button</li>
        <li>You'll receive an STK Push on your phone</li>
        <li>Enter your M-Pesa PIN to complete payment</li>
        <li>Your subscription will be activated immediately</li>
    </ol>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.getElementById('payment-form').addEventListener('submit', function(e) {
    const button = document.getElementById('pay-button');
    button.disabled = true;
    button.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Processing...';
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('onboarding.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/onboarding/payment.blade.php ENDPATH**/ ?>