<?php $__env->startSection('title', 'Leave Types'); ?>
<?php $__env->startSection('page-title', 'Leave Types Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-10 mx-auto">
            <div class="table-card">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="mb-0">Leave Types</h5>
                    <div>
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addLeaveTypeModal">
                            <i class="bi bi-plus-circle"></i> Add Leave Type
                        </button>
                        <a href="<?php echo e(route('settings.index')); ?>" class="btn btn-outline-secondary">
                            <i class="bi bi-arrow-left"></i> Back
                        </a>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Days Allowed</th>
                                <th>Requires Approval</th>
                                <th>Type</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $leaveTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <strong><?php echo e($type->name); ?></strong>
                                        <?php if($type->color): ?>
                                            <span class="badge" style="background-color: <?php echo e($type->color); ?>;">&nbsp;&nbsp;&nbsp;</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($type->days_allowed); ?> days</td>
                                    <td>
                                        <?php if($type->requires_approval): ?>
                                            <span class="badge bg-warning">Yes</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">No</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($type->is_paid): ?>
                                            <span class="badge bg-success">Paid</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Unpaid</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($type->active): ?>
                                            <span class="badge bg-success">Active</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Inactive</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" onclick="editLeaveType(<?php echo e(json_encode($type)); ?>)">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <form action="<?php echo e(route('settings.deleteLeaveType', $type)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger"
                                                    onclick="return confirm('Delete this leave type?')">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center py-4 text-muted">No leave types found. Add one to get started.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addLeaveTypeModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo e(route('settings.storeLeaveType')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Add Leave Type</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Name *</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Days Allowed *</label>
                        <input type="number" name="days_allowed" class="form-control" required min="0">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Color</label>
                        <input type="color" name="color" class="form-control" value="#3498db">
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input type="checkbox" name="requires_approval" class="form-check-input" id="requiresApprovalCheck" value="1" checked>
                            <label class="form-check-label" for="requiresApprovalCheck">Requires Approval</label>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Type *</label>
                        <select name="is_paid" class="form-select" required>
                            <option value="1">Paid</option>
                            <option value="0">Unpaid</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input type="checkbox" name="active" class="form-check-input" id="activeCheck" value="1" checked>
                            <label class="form-check-label" for="activeCheck">Active</label>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea name="description" class="form-control" rows="2"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editLeaveTypeModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="editLeaveTypeForm" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Edit Leave Type</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Name *</label>
                        <input type="text" name="name" id="edit_name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Days Allowed *</label>
                        <input type="number" name="days_allowed" id="edit_days_allowed" class="form-control" required min="0">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Color</label>
                        <input type="color" name="color" id="edit_color" class="form-control">
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input type="checkbox" name="requires_approval" id="edit_requires_approval" class="form-check-input" value="1">
                            <label class="form-check-label" for="edit_requires_approval">Requires Approval</label>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Type *</label>
                        <select name="is_paid" id="edit_is_paid" class="form-select" required>
                            <option value="1">Paid</option>
                            <option value="0">Unpaid</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input type="checkbox" name="active" id="edit_active" class="form-check-input" value="1">
                            <label class="form-check-label" for="edit_active">Active</label>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea name="description" id="edit_description" class="form-control" rows="2"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php if(session('success')): ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        alert('<?php echo e(session('success')); ?>');
    });
</script>
<?php endif; ?>

<script>
function editLeaveType(leaveType) {
    // Set form action URL
    document.getElementById('editLeaveTypeForm').action = '/settings/leave-types/' + leaveType.id;

    // Populate form fields
    document.getElementById('edit_name').value = leaveType.name;
    document.getElementById('edit_days_allowed').value = leaveType.days_allowed;
    document.getElementById('edit_color').value = leaveType.color || '#3498db';
    document.getElementById('edit_requires_approval').checked = leaveType.requires_approval ? true : false;
    document.getElementById('edit_is_paid').value = leaveType.is_paid ? '1' : '0';
    document.getElementById('edit_active').checked = leaveType.active ? true : false;
    document.getElementById('edit_description').value = leaveType.description || '';

    // Show modal
    var modal = new bootstrap.Modal(document.getElementById('editLeaveTypeModal'));
    modal.show();
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/settings/leave-types.blade.php ENDPATH**/ ?>