<?php $__env->startSection('title', 'Training Analytics'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Training Analytics</h1>
                <a href="<?php echo e(route('training.performance.index')); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Back to Performance Impact
                </a>
            </div>

            <!-- Program Effectiveness -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-trophy"></i> Training Program Effectiveness</h5>
                </div>
                <div class="card-body">
                    <?php if($programEffectiveness->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Training Program</th>
                                        <th>Impact Records</th>
                                        <th>Avg. Improvement</th>
                                        <th>Positive Impacts</th>
                                        <th>Success Rate</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $programEffectiveness; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $program): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><strong><?php echo e($program->title); ?></strong></td>
                                            <td><?php echo e($program->impact_count); ?></td>
                                            <td>
                                                <?php
                                                    $improvement = $program->avg_improvement;
                                                    $color = $improvement > 0 ? 'success' : ($improvement < 0 ? 'danger' : 'secondary');
                                                    $icon = $improvement > 0 ? 'arrow-up' : ($improvement < 0 ? 'arrow-down' : 'dash');
                                                ?>
                                                <span class="badge bg-<?php echo e($color); ?>">
                                                    <i class="bi bi-<?php echo e($icon); ?>"></i> <?php echo e(number_format($improvement, 2)); ?>

                                                </span>
                                            </td>
                                            <td><?php echo e($program->positive_impacts); ?></td>
                                            <td>
                                                <?php
                                                    $successRate = $program->impact_count > 0 ? ($program->positive_impacts / $program->impact_count) * 100 : 0;
                                                ?>
                                                <div class="progress" style="height: 20px;">
                                                    <div class="progress-bar bg-<?php echo e($successRate >= 70 ? 'success' : ($successRate >= 50 ? 'warning' : 'danger')); ?>" 
                                                         style="width: <?php echo e($successRate); ?>%">
                                                        <?php echo e(number_format($successRate, 1)); ?>%
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="bi bi-graph-up fs-1 text-muted"></i>
                            <h5 class="mt-3">No Program Effectiveness Data</h5>
                            <p class="text-muted">Start recording training performance impacts to see program effectiveness.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Monthly Trends -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-graph-up"></i> Monthly Impact Trends</h5>
                </div>
                <div class="card-body">
                    <?php if($monthlyTrends->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Month</th>
                                        <th>Total Impacts</th>
                                        <th>Avg. Improvement</th>
                                        <th>Positive Impacts</th>
                                        <th>Success Rate</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $monthlyTrends; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trend): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><strong><?php echo e(\Carbon\Carbon::createFromFormat('Y-m', $trend->month)->format('M Y')); ?></strong></td>
                                            <td><?php echo e($trend->total_impacts); ?></td>
                                            <td>
                                                <?php
                                                    $improvement = $trend->avg_improvement;
                                                    $color = $improvement > 0 ? 'success' : ($improvement < 0 ? 'danger' : 'secondary');
                                                    $icon = $improvement > 0 ? 'arrow-up' : ($improvement < 0 ? 'arrow-down' : 'dash');
                                                ?>
                                                <span class="badge bg-<?php echo e($color); ?>">
                                                    <i class="bi bi-<?php echo e($icon); ?>"></i> <?php echo e(number_format($improvement, 2)); ?>

                                                </span>
                                            </td>
                                            <td><?php echo e($trend->positive_impacts); ?></td>
                                            <td>
                                                <?php
                                                    $successRate = $trend->total_impacts > 0 ? ($trend->positive_impacts / $trend->total_impacts) * 100 : 0;
                                                ?>
                                                <span class="badge bg-<?php echo e($successRate >= 70 ? 'success' : ($successRate >= 50 ? 'warning' : 'danger')); ?>">
                                                    <?php echo e(number_format($successRate, 1)); ?>%
                                                </span>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="bi bi-calendar3 fs-1 text-muted"></i>
                            <h5 class="mt-3">No Monthly Trend Data</h5>
                            <p class="text-muted">Training impact data will appear here as you record more impacts over time.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="row">
                <!-- Top Improved Employees -->
                <div class="col-md-6">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-person-check"></i> Top Improved Employees</h5>
                        </div>
                        <div class="card-body">
                            <?php if($topImprovedEmployees->count() > 0): ?>
                                <div class="list-group list-group-flush">
                                    <?php $__currentLoopData = $topImprovedEmployees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="list-group-item d-flex justify-content-between align-items-center">
                                            <div>
                                                <strong><?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?></strong><br>
                                                <small class="text-muted"><?php echo e($employee->training_count); ?> trainings completed</small>
                                            </div>
                                            <div class="text-end">
                                                <span class="badge bg-success">
                                                    +<?php echo e(number_format($employee->avg_improvement, 2)); ?> avg
                                                </span><br>
                                                <small class="text-muted"><?php echo e(number_format($employee->total_improvement, 2)); ?> total</small>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-4">
                                    <i class="bi bi-people fs-1 text-muted"></i>
                                    <h6 class="mt-3">No Employee Data</h6>
                                    <p class="text-muted small">Employee improvement data will appear here.</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Skills Development Impact -->
                <div class="col-md-6">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-gear"></i> Skills Development Impact</h5>
                        </div>
                        <div class="card-body">
                            <?php if($skillsImpact->count() > 0): ?>
                                <div class="list-group list-group-flush">
                                    <?php $__currentLoopData = $skillsImpact; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="list-group-item d-flex justify-content-between align-items-center">
                                            <div>
                                                <strong><?php echo e($skill['skill_name']); ?></strong><br>
                                                <small class="text-muted"><?php echo e($skill['employees_impacted']); ?> employees impacted</small>
                                            </div>
                                            <div class="text-end">
                                                <span class="badge bg-primary">
                                                    +<?php echo e(number_format($skill['avg_improvement'], 2)); ?> avg
                                                </span><br>
                                                <small class="text-muted"><?php echo e($skill['total_improvements']); ?> improvements</small>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-4">
                                    <i class="bi bi-tools fs-1 text-muted"></i>
                                    <h6 class="mt-3">No Skills Data</h6>
                                    <p class="text-muted small">Skills improvement data will appear here.</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Summary Cards -->
            <div class="row">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body text-center">
                            <i class="bi bi-graph-up fs-1"></i>
                            <h4 class="mt-2"><?php echo e($programEffectiveness->count()); ?></h4>
                            <p class="mb-0">Programs Analyzed</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body text-center">
                            <i class="bi bi-calendar3 fs-1"></i>
                            <h4 class="mt-2"><?php echo e($monthlyTrends->count()); ?></h4>
                            <p class="mb-0">Months of Data</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body text-center">
                            <i class="bi bi-people fs-1"></i>
                            <h4 class="mt-2"><?php echo e($topImprovedEmployees->count()); ?></h4>
                            <p class="mb-0">Top Performers</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body text-center">
                            <i class="bi bi-tools fs-1"></i>
                            <h4 class="mt-2"><?php echo e($skillsImpact->count()); ?></h4>
                            <p class="mb-0">Skills Improved</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/training/performance/analytics.blade.php ENDPATH**/ ?>