<?php $__env->startSection('title', 'Edit Learning Path'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Edit Learning Path</h1>
                <a href="<?php echo e(route('training.learning-paths.show', $learningPath)); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Back to Learning Path
                </a>
            </div>

            <div class="card">
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('training.learning-paths.update', $learningPath)); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        
                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-3">
                                    <label for="title" class="form-label">Learning Path Title <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="title" name="title" value="<?php echo e(old('title', $learningPath->title)); ?>" required>
                                    <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="difficulty_level" class="form-label">Difficulty Level <span class="text-danger">*</span></label>
                                    <select class="form-select <?php $__errorArgs = ['difficulty_level'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="difficulty_level" name="difficulty_level" required>
                                        <option value="">Select Difficulty</option>
                                        <option value="beginner" <?php echo e(old('difficulty_level', $learningPath->difficulty_level) == 'beginner' ? 'selected' : ''); ?>>Beginner</option>
                                        <option value="intermediate" <?php echo e(old('difficulty_level', $learningPath->difficulty_level) == 'intermediate' ? 'selected' : ''); ?>>Intermediate</option>
                                        <option value="advanced" <?php echo e(old('difficulty_level', $learningPath->difficulty_level) == 'advanced' ? 'selected' : ''); ?>>Advanced</option>
                                    </select>
                                    <?php $__errorArgs = ['difficulty_level'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">Description <span class="text-danger">*</span></label>
                            <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="description" name="description" rows="4" required 
                                      placeholder="Describe what this learning path covers and its objectives..."><?php echo e(old('description', $learningPath->description)); ?></textarea>
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="estimated_duration_hours" class="form-label">Estimated Duration (Hours) <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['estimated_duration_hours'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="estimated_duration_hours" name="estimated_duration_hours" min="1" 
                                           value="<?php echo e(old('estimated_duration_hours', $learningPath->estimated_duration_hours)); ?>" required>
                                    <?php $__errorArgs = ['estimated_duration_hours'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="image" class="form-label">Learning Path Image</label>
                                    <input type="file" class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="image" name="image" accept="image/*">
                                    <div class="form-text">Upload a new image to replace the current one (optional)</div>
                                    <?php if($learningPath->image_path): ?>
                                        <div class="mt-2">
                                            <small class="text-muted">Current image:</small><br>
                                            <img src="<?php echo e(asset('storage/' . $learningPath->image_path)); ?>" 
                                                 alt="Current image" class="img-thumbnail" style="max-height: 100px;">
                                        </div>
                                    <?php endif; ?>
                                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="target_roles" class="form-label">Target Roles</label>
                                    <select class="form-select" id="target_roles" name="target_roles[]" multiple>
                                        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <optgroup label="<?php echo e($department->name); ?>">
                                                <?php $__currentLoopData = $department->positions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $position): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($position->id); ?>" 
                                                        <?php echo e(in_array($position->id, old('target_roles', $learningPath->target_roles ?? [])) ? 'selected' : ''); ?>>
                                                        <?php echo e($position->title); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </optgroup>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="form-text">Select positions that would benefit from this learning path</div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1"
                                               <?php echo e(old('is_active', $learningPath->is_active) ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="is_active">
                                            Active Learning Path
                                        </label>
                                    </div>
                                    <div class="form-text">Inactive learning paths are not available for enrollment</div>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Learning Outcomes</label>
                            <div id="learning-outcomes">
                                <?php if(old('learning_outcomes') || $learningPath->learning_outcomes): ?>
                                    <?php
                                        $outcomes = old('learning_outcomes') ?? $learningPath->learning_outcomes ?? [];
                                    ?>
                                    <?php $__currentLoopData = $outcomes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $outcome): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="input-group mb-2">
                                            <input type="text" class="form-control" name="learning_outcomes[]" 
                                                   value="<?php echo e($outcome); ?>" placeholder="What will learners achieve?">
                                            <button type="button" class="btn btn-outline-danger remove-outcome">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <div class="input-group mb-2">
                                        <input type="text" class="form-control" name="learning_outcomes[]" 
                                               placeholder="What will learners achieve?">
                                        <button type="button" class="btn btn-outline-danger remove-outcome">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <button type="button" class="btn btn-outline-primary btn-sm" id="add-outcome">
                                <i class="bi bi-plus"></i> Add Learning Outcome
                            </button>
                        </div>

                        <div class="mb-4">
                            <label class="form-label">Learning Path Steps <span class="text-danger">*</span></label>
                            <div id="learning-steps">
                                <?php if(old('steps') || $learningPath->steps->count() > 0): ?>
                                    <?php
                                        $steps = old('steps') ?? $learningPath->steps->map(function($step) {
                                            return [
                                                'training_program_id' => $step->training_program_id,
                                                'is_required' => $step->is_required
                                            ];
                                        })->toArray();
                                    ?>
                                    <?php $__currentLoopData = $steps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="card mb-3 step-card">
                                            <div class="card-body">
                                                <div class="d-flex justify-content-between align-items-center mb-3">
                                                    <h6 class="mb-0">Step <?php echo e($index + 1); ?></h6>
                                                    <button type="button" class="btn btn-outline-danger btn-sm remove-step">
                                                        <i class="bi bi-trash"></i> Remove
                                                    </button>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-8">
                                                        <select class="form-select" name="steps[<?php echo e($index); ?>][training_program_id]" required>
                                                            <option value="">Select Training Program</option>
                                                            <?php $__currentLoopData = $trainingPrograms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $program): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($program->id); ?>" 
                                                                    <?php echo e($step['training_program_id'] == $program->id ? 'selected' : ''); ?>>
                                                                    <?php echo e($program->title); ?> (<?php echo e($program->category->name); ?>)
                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="checkbox" 
                                                                   name="steps[<?php echo e($index); ?>][is_required]" value="1"
                                                                   <?php echo e(($step['is_required'] ?? true) ? 'checked' : ''); ?>>
                                                            <label class="form-check-label">Required Step</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <div class="card mb-3 step-card">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-center mb-3">
                                                <h6 class="mb-0">Step 1</h6>
                                                <button type="button" class="btn btn-outline-danger btn-sm remove-step">
                                                    <i class="bi bi-trash"></i> Remove
                                                </button>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-8">
                                                    <select class="form-select" name="steps[0][training_program_id]" required>
                                                        <option value="">Select Training Program</option>
                                                        <?php $__currentLoopData = $trainingPrograms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $program): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($program->id); ?>">
                                                                <?php echo e($program->title); ?> (<?php echo e($program->category->name); ?>)
                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" 
                                                               name="steps[0][is_required]" value="1" checked>
                                                        <label class="form-check-label">Required Step</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <button type="button" class="btn btn-outline-primary" id="add-step">
                                <i class="bi bi-plus"></i> Add Step
                            </button>
                        </div>

                        <div class="d-flex justify-content-end gap-2">
                            <a href="<?php echo e(route('training.learning-paths.show', $learningPath)); ?>" class="btn btn-secondary">Cancel</a>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check"></i> Update Learning Path
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    let stepIndex = <?php echo e(old('steps') ? count(old('steps')) : ($learningPath->steps->count() ?: 1)); ?>;
    
    // Add learning outcome
    document.getElementById('add-outcome').addEventListener('click', function() {
        const container = document.getElementById('learning-outcomes');
        const div = document.createElement('div');
        div.className = 'input-group mb-2';
        div.innerHTML = `
            <input type="text" class="form-control" name="learning_outcomes[]" 
                   placeholder="What will learners achieve?">
            <button type="button" class="btn btn-outline-danger remove-outcome">
                <i class="bi bi-trash"></i>
            </button>
        `;
        container.appendChild(div);
    });
    
    // Remove learning outcome
    document.addEventListener('click', function(e) {
        if (e.target.closest('.remove-outcome')) {
            const outcomes = document.querySelectorAll('#learning-outcomes .input-group');
            if (outcomes.length > 1) {
                e.target.closest('.input-group').remove();
            }
        }
    });
    
    // Add learning step
    document.getElementById('add-step').addEventListener('click', function() {
        const container = document.getElementById('learning-steps');
        const div = document.createElement('div');
        div.className = 'card mb-3 step-card';
        div.innerHTML = `
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="mb-0">Step ${stepIndex + 1}</h6>
                    <button type="button" class="btn btn-outline-danger btn-sm remove-step">
                        <i class="bi bi-trash"></i> Remove
                    </button>
                </div>
                <div class="row">
                    <div class="col-md-8">
                        <select class="form-select" name="steps[${stepIndex}][training_program_id]" required>
                            <option value="">Select Training Program</option>
                            <?php $__currentLoopData = $trainingPrograms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $program): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($program->id); ?>">
                                    <?php echo e($program->title); ?> (<?php echo e($program->category->name); ?>)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" 
                                   name="steps[${stepIndex}][is_required]" value="1" checked>
                            <label class="form-check-label">Required Step</label>
                        </div>
                    </div>
                </div>
            </div>
        `;
        container.appendChild(div);
        stepIndex++;
        updateStepNumbers();
    });
    
    // Remove learning step
    document.addEventListener('click', function(e) {
        if (e.target.closest('.remove-step')) {
            const steps = document.querySelectorAll('.step-card');
            if (steps.length > 1) {
                e.target.closest('.step-card').remove();
                updateStepNumbers();
            }
        }
    });
    
    function updateStepNumbers() {
        const steps = document.querySelectorAll('.step-card');
        steps.forEach((step, index) => {
            step.querySelector('h6').textContent = `Step ${index + 1}`;
        });
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/training/learning-paths/edit.blade.php ENDPATH**/ ?>