<?php $__env->startSection('title', 'Request Loan'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title mb-0">Request a Loan</h3>
                </div>
                <div class="card-body">
                    <!-- Eligibility Info -->
                    <div class="alert alert-info">
                        <h6><i class="bi bi-info-circle"></i> Loan Eligibility</h6>
                        <ul class="mb-0">
                            <li>Maximum loan amount: <strong>KES <?php echo e(number_format($loanSettings->max_loan_amount, 2)); ?></strong></li>
                            <li>Maximum term: <strong><?php echo e($loanSettings->max_loan_term_months); ?> months</strong></li>
                            <li>Your maximum eligible amount: <strong>KES <?php echo e(number_format($employee->basic_salary * $loanSettings->loan_to_salary_ratio, 2)); ?></strong> (<?php echo e($loanSettings->loan_to_salary_ratio); ?>x your salary)</li>
                        </ul>
                    </div>

                    <?php if($errors->has('eligibility')): ?>
                        <div class="alert alert-danger">
                            <h6><i class="bi bi-exclamation-triangle"></i> Eligibility Issues:</h6>
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->get('eligibility'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $__currentLoopData = $error; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($message); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <form action="<?php echo e(route('loans.submit-request')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="loan_type" class="form-label">Loan Type <span class="text-danger">*</span></label>
                                <select name="loan_type" id="loan_type" class="form-select <?php $__errorArgs = ['loan_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                    <option value="">Select Type</option>
                                    <option value="salary_advance" <?php echo e(old('loan_type') == 'salary_advance' ? 'selected' : ''); ?>>
                                        Salary Advance (<?php echo e($loanSettings->getInterestRateForType('salary_advance')); ?>% interest)
                                    </option>
                                    <option value="emergency" <?php echo e(old('loan_type') == 'emergency' ? 'selected' : ''); ?>>
                                        Emergency (<?php echo e($loanSettings->getInterestRateForType('emergency')); ?>% interest)
                                    </option>
                                    <option value="personal" <?php echo e(old('loan_type') == 'personal' ? 'selected' : ''); ?>>
                                        Personal (<?php echo e($loanSettings->getInterestRateForType('personal')); ?>% interest)
                                    </option>
                                    <option value="education" <?php echo e(old('loan_type') == 'education' ? 'selected' : ''); ?>>
                                        Education (<?php echo e($loanSettings->getInterestRateForType('education')); ?>% interest)
                                    </option>
                                    <option value="housing" <?php echo e(old('loan_type') == 'housing' ? 'selected' : ''); ?>>
                                        Housing (<?php echo e($loanSettings->getInterestRateForType('housing')); ?>% interest)
                                    </option>
                                    <option value="other" <?php echo e(old('loan_type') == 'other' ? 'selected' : ''); ?>>
                                        Other (<?php echo e($loanSettings->getInterestRateForType('other')); ?>% interest)
                                    </option>
                                </select>
                                <?php $__errorArgs = ['loan_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="principal_amount" class="form-label">Loan Amount (KES) <span class="text-danger">*</span></label>
                                <input type="number" class="form-control <?php $__errorArgs = ['principal_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="principal_amount" name="principal_amount" 
                                       value="<?php echo e(old('principal_amount')); ?>" 
                                       step="0.01" min="1" max="<?php echo e($loanSettings->max_loan_amount); ?>" required>
                                <?php $__errorArgs = ['principal_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <small class="text-muted">Maximum: KES <?php echo e(number_format($loanSettings->max_loan_amount, 2)); ?></small>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="repayment_period_months" class="form-label">Repayment Period (Months) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control <?php $__errorArgs = ['repayment_period_months'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="repayment_period_months" name="repayment_period_months" 
                                   value="<?php echo e(old('repayment_period_months', 12)); ?>" 
                                   min="1" max="<?php echo e($loanSettings->max_loan_term_months); ?>" required>
                            <?php $__errorArgs = ['repayment_period_months'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <small class="text-muted">Maximum: <?php echo e($loanSettings->max_loan_term_months); ?> months</small>
                        </div>

                        <div class="mb-3">
                            <label for="purpose" class="form-label">Purpose/Reason <span class="text-danger">*</span></label>
                            <textarea class="form-control <?php $__errorArgs = ['purpose'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="purpose" name="purpose" rows="4" required 
                                      placeholder="Please explain why you need this loan..."><?php echo e(old('purpose')); ?></textarea>
                            <?php $__errorArgs = ['purpose'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Loan Calculator Preview -->
                        <div class="card bg-light mb-3">
                            <div class="card-body">
                                <h6>Estimated Loan Details:</h6>
                                <div id="loan-preview">
                                    <p class="text-muted">Enter loan amount and period to see estimates</p>
                                </div>
                            </div>
                        </div>

                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" id="agree_terms" required>
                            <label class="form-check-label" for="agree_terms">
                                I agree to the loan terms and conditions, and authorize automatic deductions from my salary
                            </label>
                        </div>

                        <div class="d-flex justify-content-end">
                            <a href="<?php echo e(route('loans.my-loans')); ?>" class="btn btn-secondary me-2">Cancel</a>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-send"></i> Submit Request
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const amountInput = document.getElementById('principal_amount');
    const periodInput = document.getElementById('repayment_period_months');
    const typeSelect = document.getElementById('loan_type');
    const previewDiv = document.getElementById('loan-preview');

    const interestRates = {
        'salary_advance': <?php echo e($loanSettings->getInterestRateForType('salary_advance')); ?>,
        'emergency': <?php echo e($loanSettings->getInterestRateForType('emergency')); ?>,
        'personal': <?php echo e($loanSettings->getInterestRateForType('personal')); ?>,
        'education': <?php echo e($loanSettings->getInterestRateForType('education')); ?>,
        'housing': <?php echo e($loanSettings->getInterestRateForType('housing')); ?>,
        'other': <?php echo e($loanSettings->getInterestRateForType('other')); ?>

    };

    function calculateLoan() {
        const principal = parseFloat(amountInput.value) || 0;
        const months = parseInt(periodInput.value) || 0;
        const loanType = typeSelect.value;

        if (principal > 0 && months > 0 && loanType) {
            const annualRate = interestRates[loanType] / 100;
            const monthlyRate = annualRate / 12;
            
            let totalAmount, monthlyPayment;
            
            if (monthlyRate === 0) {
                totalAmount = principal;
                monthlyPayment = principal / months;
            } else {
                monthlyPayment = principal * (monthlyRate * Math.pow(1 + monthlyRate, months)) / 
                                (Math.pow(1 + monthlyRate, months) - 1);
                totalAmount = monthlyPayment * months;
            }

            const totalInterest = totalAmount - principal;

            previewDiv.innerHTML = `
                <table class="table table-sm mb-0">
                    <tr>
                        <td>Principal Amount:</td>
                        <td class="text-end"><strong>KES ${principal.toLocaleString('en-US', {minimumFractionDigits: 2})}</strong></td>
                    </tr>
                    <tr>
                        <td>Interest Rate:</td>
                        <td class="text-end"><strong>${interestRates[loanType]}% per year</strong></td>
                    </tr>
                    <tr>
                        <td>Total Interest:</td>
                        <td class="text-end"><strong>KES ${totalInterest.toLocaleString('en-US', {minimumFractionDigits: 2})}</strong></td>
                    </tr>
                    <tr>
                        <td>Total Amount to Repay:</td>
                        <td class="text-end"><strong>KES ${totalAmount.toLocaleString('en-US', {minimumFractionDigits: 2})}</strong></td>
                    </tr>
                    <tr class="table-primary">
                        <td><strong>Monthly Deduction:</strong></td>
                        <td class="text-end"><strong>KES ${monthlyPayment.toLocaleString('en-US', {minimumFractionDigits: 2})}</strong></td>
                    </tr>
                </table>
            `;
        }
    }

    amountInput.addEventListener('input', calculateLoan);
    periodInput.addEventListener('input', calculateLoan);
    typeSelect.addEventListener('change', calculateLoan);
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/loans/request.blade.php ENDPATH**/ ?>