<?php $__env->startSection('title', 'My Trainings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">My Trainings</h1>
                <a href="<?php echo e(route('training.index')); ?>" class="btn btn-primary">
                    <i class="bi bi-search"></i> Browse Training Programs
                </a>
            </div>

            <?php if($upcomingSessions->count() > 0): ?>
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-calendar-alt"></i> Upcoming Sessions</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <?php $__currentLoopData = $upcomingSessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-6 col-lg-4 mb-3">
                                    <div class="card border-primary">
                                        <div class="card-body">
                                            <h6 class="card-title"><?php echo e($enrollment->session->program->title); ?></h6>
                                            <p class="card-text">
                                                <small class="text-muted">
                                                    <i class="bi bi-calendar"></i> <?php echo e($enrollment->session->start_datetime->format('M j, Y')); ?><br>
                                                    <i class="bi bi-clock"></i> <?php echo e($enrollment->session->start_datetime->format('g:i A')); ?> - <?php echo e($enrollment->session->end_datetime->format('g:i A')); ?><br>
                                                    <?php if($enrollment->session->location): ?>
                                                        <i class="bi bi-map-marker-alt"></i> <?php echo e($enrollment->session->location); ?><br>
                                                    <?php endif; ?>
                                                    <?php if($enrollment->session->instructor): ?>
                                                        <i class="bi bi-user"></i> <?php echo e($enrollment->session->instructor->name); ?>

                                                    <?php endif; ?>
                                                </small>
                                            </p>
                                            <span class="badge badge-<?php echo e($enrollment->status == 'enrolled' ? 'primary' : 'success'); ?>">
                                                <?php echo e(ucfirst($enrollment->status)); ?>

                                            </span>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($completedTrainings->count() > 0): ?>
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-trophy"></i> Recently Completed</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <?php $__currentLoopData = $completedTrainings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-6 col-lg-4 mb-3">
                                    <div class="card border-success">
                                        <div class="card-body">
                                            <h6 class="card-title"><?php echo e($enrollment->session->program->title); ?></h6>
                                            <p class="card-text">
                                                <small class="text-muted">
                                                    <i class="bi bi-calendar-check"></i> Completed: <?php echo e($enrollment->completed_at->format('M j, Y')); ?><br>
                                                    <i class="bi bi-tag"></i> <?php echo e($enrollment->session->program->category->name); ?>

                                                    <?php if($enrollment->completion_score): ?>
                                                        <br><i class="bi bi-star"></i> Score: <?php echo e($enrollment->completion_score); ?>%
                                                    <?php endif; ?>
                                                </small>
                                            </p>
                                            <span class="badge badge-success">Completed</span>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-list"></i> All Training History</h5>
                </div>
                <div class="card-body">
                    <?php if($enrollments->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Program</th>
                                        <th>Category</th>
                                        <th>Session</th>
                                        <th>Status</th>
                                        <th>Enrolled Date</th>
                                        <th>Completion</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $enrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <strong><?php echo e($enrollment->session->program->title); ?></strong><br>
                                                <small class="text-muted"><?php echo e(Str::limit($enrollment->session->program->description, 50)); ?></small>
                                            </td>
                                            <td>
                                                <span class="badge" style="background-color: <?php echo e($enrollment->session->program->category->color); ?>">
                                                    <?php echo e($enrollment->session->program->category->name); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <strong><?php echo e($enrollment->session->session_code); ?></strong><br>
                                                <small class="text-muted">
                                                    <?php echo e($enrollment->session->start_datetime->format('M j, Y g:i A')); ?>

                                                </small>
                                            </td>
                                            <td>
                                                <span class="badge badge-<?php echo e($enrollment->status_color); ?>">
                                                    <?php echo e(ucfirst(str_replace('_', ' ', $enrollment->status))); ?>

                                                </span>
                                            </td>
                                            <td><?php echo e($enrollment->enrolled_at->format('M j, Y')); ?></td>
                                            <td>
                                                <?php if($enrollment->completion_score): ?>
                                                    <span class="badge badge-success"><?php echo e($enrollment->completion_score); ?>%</span>
                                                <?php elseif($enrollment->completed_at): ?>
                                                    <span class="badge badge-success">Completed</span>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('training.programs.show', $enrollment->session->program)); ?>" class="btn btn-sm btn-outline-primary">
                                                    <i class="bi bi-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="d-flex justify-content-center">
                            <?php echo e($enrollments->links()); ?>

                        </div>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="bi bi-graduation-cap fa-3x text-muted mb-3"></i>
                            <h4>No Training History</h4>
                            <p class="text-muted">You haven't enrolled in any training programs yet.</p>
                            <a href="<?php echo e(route('training.index')); ?>" class="btn btn-primary">
                                <i class="bi bi-search"></i> Browse Training Programs
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/training/my-trainings.blade.php ENDPATH**/ ?>