<?php $__env->startSection('title', 'Dashboard - Qaya HRM'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Employee Check-in/Check-out Section (Only for employees) -->
    <?php if(auth()->user()->employee): ?>
        <div class="row mb-4">
            <div class="col-12">
                <div class="card shadow-sm border-0">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-md-4">
                                <h5 class="mb-2"><i class="bi bi-clock"></i> Today's Attendance</h5>
                                <p class="text-muted mb-0"><?php echo e(now()->format('l, F d, Y')); ?></p>
                            </div>
                            <div class="col-md-4 text-center">
                                <?php
                                    $todayAttendanceRecord = \App\Models\Attendance::where('employee_id', auth()->user()->employee->id)
                                        ->where('date', today())
                                        ->first();
                                ?>

                                <?php if($todayAttendanceRecord): ?>
                                    <div class="attendance-time">
                                        <div class="mb-2">
                                            <strong>Check-in:</strong> <span class="text-success"><?php echo e($todayAttendanceRecord->check_in ?? 'N/A'); ?></span>
                                        </div>
                                        <div>
                                            <strong>Check-out:</strong>
                                            <span class="text-<?php echo e($todayAttendanceRecord->check_out ? 'danger' : 'muted'); ?>">
                                                <?php echo e($todayAttendanceRecord->check_out ?? 'Not checked out'); ?>

                                            </span>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="text-muted">
                                        <i class="bi bi-clock-history fs-2"></i>
                                        <p class="mb-0">No attendance recorded today</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-4 text-end">
                                <?php if(!$todayAttendanceRecord || !$todayAttendanceRecord->check_in): ?>
                                    <form action="<?php echo e(route('attendance.employee.checkIn')); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-success btn-lg">
                                            <i class="bi bi-box-arrow-in-right"></i> Check In
                                        </button>
                                    </form>
                                <?php elseif(!$todayAttendanceRecord->check_out): ?>
                                    <form action="<?php echo e(route('attendance.employee.checkOut')); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-danger btn-lg">
                                            <i class="bi bi-box-arrow-right"></i> Check Out
                                        </button>
                                    </form>
                                <?php else: ?>
                                    <div class="alert alert-success mb-0">
                                        <i class="bi bi-check-circle"></i> Attendance completed for today
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Enhanced Statistics Cards -->
    <div class="row">
        <!-- Core Metrics -->
        <div class="col-md-3">
            <div class="stat-card primary">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-people"></i>
                    </div>
                    <div class="ms-3">
                        <h3 class="mb-0"><?php echo e($totalEmployees); ?></h3>
                        <p class="text-muted mb-0">Total Employees</p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Attendance Metrics -->
        <div class="col-md-3">
            <div class="stat-card success">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-calendar-check"></i>
                    </div>
                    <div class="ms-3">
                        <h3 class="mb-0"><?php echo e($attendanceMetrics['today_present']); ?></h3>
                        <p class="text-muted mb-0">Present Today</p>
                        <small class="text-success"><?php echo e($attendanceMetrics['attendance_rate']); ?>% attendance rate</small>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Leave Metrics -->
        <div class="col-md-3">
            <div class="stat-card warning">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-calendar-x"></i>
                    </div>
                    <div class="ms-3">
                        <h3 class="mb-0"><?php echo e($leaveMetrics['pending_requests']); ?></h3>
                        <p class="text-muted mb-0">Pending Leaves</p>
                        <small class="text-info"><?php echo e($leaveMetrics['employees_on_leave_today']); ?> on leave today</small>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Payroll Metrics -->
        <div class="col-md-3">
            <div class="stat-card info">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-cash-stack"></i>
                    </div>
                    <div class="ms-3">
                        <h3 class="mb-0"><?php echo e(number_format($payrollMetrics['avg_salary'])); ?></h3>
                        <p class="text-muted mb-0">Avg Salary</p>
                        <small class="text-success"><?php echo e($payrollMetrics['paid_employees']); ?>/<?php echo e($payrollMetrics['current_month_employees']); ?> paid</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Secondary Metrics Row -->
    <div class="row mt-3">
        <div class="col-md-3">
            <div class="stat-card secondary">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-clock-history"></i>
                    </div>
                    <div class="ms-3">
                        <h3 class="mb-0"><?php echo e($attendanceMetrics['today_late']); ?></h3>
                        <p class="text-muted mb-0">Late Today</p>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="stat-card danger">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-person-x"></i>
                    </div>
                    <div class="ms-3">
                        <h3 class="mb-0"><?php echo e($attendanceMetrics['today_absent']); ?></h3>
                        <p class="text-muted mb-0">Absent Today</p>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="stat-card success">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-star"></i>
                    </div>
                    <div class="ms-3">
                        <h3 class="mb-0"><?php echo e($performanceMetrics['average_rating']); ?></h3>
                        <p class="text-muted mb-0">Avg Performance</p>
                        <small class="text-info"><?php echo e($performanceMetrics['completion_rate']); ?>% completion rate</small>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="stat-card primary">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-diagram-3"></i>
                    </div>
                    <div class="ms-3">
                        <h3 class="mb-0"><?php echo e($totalDepartments); ?></h3>
                        <p class="text-muted mb-0">Departments</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row mt-4">
        <!-- Attendance Trends -->
        <div class="col-md-6">
            <div class="table-card">
                <h5 class="mb-3"><i class="bi bi-graph-up"></i> Attendance Trends (6 Months)</h5>
                <canvas id="attendanceChart" height="200"></canvas>
            </div>
        </div>
        
        <!-- Department Distribution -->
        <div class="col-md-6">
            <div class="table-card">
                <h5 class="mb-3"><i class="bi bi-pie-chart"></i> Department Distribution</h5>
                <canvas id="departmentChart" height="200"></canvas>
            </div>
        </div>
    </div>

    <!-- Additional Charts Row -->
    <div class="row mt-4">
        <!-- Leave Trends -->
        <div class="col-md-6">
            <div class="table-card">
                <h5 class="mb-3"><i class="bi bi-calendar-event"></i> Leave Trends (6 Months)</h5>
                <canvas id="leaveChart" height="200"></canvas>
            </div>
        </div>
        
        <!-- Payroll Trends -->
        <div class="col-md-6">
            <div class="table-card">
                <h5 class="mb-3"><i class="bi bi-cash"></i> Payroll Trends (6 Months)</h5>
                <canvas id="payrollChart" height="200"></canvas>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <!-- Recent Employees -->
        <div class="col-md-6">
            <div class="table-card">
                <h5 class="mb-3">Recent Employees</h5>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Department</th>
                                <th>Position</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $recentEmployees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_employee_details')): ?>
                                        <a href="<?php echo e(route('employees.show', $employee)); ?>">
                                            <?php echo e($employee->full_name); ?>

                                        </a>
                                        <?php else: ?>
                                        <?php echo e($employee->full_name); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($employee->department->name ?? 'N/A'); ?></td>
                                    <td><?php echo e($employee->position->name ?? 'N/A'); ?></td>
                                    <td>
                                        <span class="badge badge-status-<?php echo e($employee->status); ?>">
                                            <?php echo e(ucfirst($employee->status)); ?>

                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="text-center">No employees found</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Upcoming Birthdays -->
        <div class="col-md-6">
            <div class="table-card">
                <h5 class="mb-3">Upcoming Birthdays</h5>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Department</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $upcomingBirthdays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($employee->full_name); ?></td>
                                    <td><?php echo e($employee->department->name ?? 'N/A'); ?></td>
                                    <td>
                                        <i class="bi bi-gift"></i>
                                        <?php echo e($employee->date_of_birth->format('M d')); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center">No upcoming birthdays</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Announcements -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="table-card">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h5 class="mb-0">
                        <i class="bi bi-megaphone me-2"></i>Announcements
                    </h5>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_announcements')): ?>
                    <a href="<?php echo e(route('announcements.index')); ?>" class="btn btn-sm btn-outline-primary">
                        <i class="bi bi-eye"></i> View All
                    </a>
                    <?php endif; ?>
                </div>
                <div class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $announcements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $announcement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="list-group-item px-0 py-3">
                            <div class="d-flex w-100 justify-content-between align-items-start">
                                <div class="grow">
                                    <div class="d-flex align-items-center mb-1">
                                        <?php if($announcement->is_pinned): ?>
                                            <i class="bi bi-pin-fill text-danger me-2" title="Pinned"></i>
                                        <?php endif; ?>
                                        <h6 class="mb-0">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $announcement)): ?>
                                            <a href="<?php echo e(route('announcements.show', $announcement)); ?>" class="text-decoration-none">
                                                <?php echo e($announcement->title); ?>

                                            </a>
                                            <?php else: ?>
                                            <?php echo e($announcement->title); ?>

                                            <?php endif; ?>
                                        </h6>
                                    </div>
                                    <p class="mb-2 text-muted"><?php echo e(Str::limit($announcement->excerpt ?: $announcement->content, 80)); ?></p>
                                    <div class="d-flex gap-2">
                                        <span class="badge bg-<?php echo e($announcement->priority === 'urgent' ? 'danger' : ($announcement->priority === 'high' ? 'warning' : ($announcement->priority === 'medium' ? 'info' : 'secondary'))); ?>">
                                            <?php echo e(ucfirst($announcement->priority)); ?>

                                        </span>
                                        <small class="text-muted"><?php echo e($announcement->created_at->diffForHumans()); ?></small>
                                    </div>
                                </div>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $announcement)): ?>
                                <div class="ms-3">
                                    <a href="<?php echo e(route('announcements.show', $announcement)); ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-arrow-right"></i>
                                    </a>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="list-group-item text-center py-4">
                            <i class="bi bi-megaphone text-muted" style="font-size: 2rem;"></i>
                            <p class="text-muted mt-2 mb-0">No announcements available</p>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create_announcements')): ?>
                            <a href="<?php echo e(route('announcements.create')); ?>" class="btn btn-sm btn-primary mt-2">
                                <i class="bi bi-plus-circle"></i> Create First Announcement
                            </a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Color palette for charts
    const colors = {
        primary: '#714b67',
        success: '#28a745',
        warning: '#ffc107',
        danger: '#dc3545',
        info: '#17a2b8',
        secondary: '#6c757d'
    };

    // Attendance Trends Chart
    const attendanceCtx = document.getElementById('attendanceChart').getContext('2d');
    new Chart(attendanceCtx, {
        type: 'line',
        data: {
            labels: <?php echo json_encode(array_column($attendanceTrends, 'month')); ?>,
            datasets: [
                {
                    label: 'Present',
                    data: <?php echo json_encode(array_column($attendanceTrends, 'present')); ?>,
                    borderColor: colors.success,
                    backgroundColor: colors.success + '20',
                    tension: 0.4,
                    fill: false
                },
                {
                    label: 'Late',
                    data: <?php echo json_encode(array_column($attendanceTrends, 'late')); ?>,
                    borderColor: colors.warning,
                    backgroundColor: colors.warning + '20',
                    tension: 0.4,
                    fill: false
                },
                {
                    label: 'Absent',
                    data: <?php echo json_encode(array_column($attendanceTrends, 'absent')); ?>,
                    borderColor: colors.danger,
                    backgroundColor: colors.danger + '20',
                    tension: 0.4,
                    fill: false
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'top'
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Department Distribution Chart
    const departmentCtx = document.getElementById('departmentChart').getContext('2d');
    const departmentData = <?php echo json_encode($departmentAnalytics); ?>;
    new Chart(departmentCtx, {
        type: 'doughnut',
        data: {
            labels: departmentData.map(d => d.name),
            datasets: [{
                data: departmentData.map(d => d.employee_count),
                backgroundColor: departmentData.map(d => d.color),
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });

    // Leave Trends Chart
    const leaveCtx = document.getElementById('leaveChart').getContext('2d');
    new Chart(leaveCtx, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode(array_column($leaveTrends, 'month')); ?>,
            datasets: [
                {
                    label: 'Leave Requests',
                    data: <?php echo json_encode(array_column($leaveTrends, 'total_requests')); ?>,
                    backgroundColor: colors.info + '80',
                    borderColor: colors.info,
                    borderWidth: 1
                },
                {
                    label: 'Approved Days',
                    data: <?php echo json_encode(array_column($leaveTrends, 'approved_days')); ?>,
                    backgroundColor: colors.success + '80',
                    borderColor: colors.success,
                    borderWidth: 1
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'top'
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Payroll Trends Chart
    const payrollCtx = document.getElementById('payrollChart').getContext('2d');
    new Chart(payrollCtx, {
        type: 'line',
        data: {
            labels: <?php echo json_encode(array_column($payrollTrends, 'month')); ?>,
            datasets: [
                {
                    label: 'Employee Count',
                    data: <?php echo json_encode(array_column($payrollTrends, 'employee_count')); ?>,
                    borderColor: colors.primary,
                    backgroundColor: colors.primary + '20',
                    tension: 0.4,
                    yAxisID: 'y'
                },
                {
                    label: 'Avg Salary (KES)',
                    data: <?php echo json_encode(array_column($payrollTrends, 'avg_net')); ?>,
                    borderColor: colors.success,
                    backgroundColor: colors.success + '20',
                    tension: 0.4,
                    yAxisID: 'y1'
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'top'
                }
            },
            scales: {
                y: {
                    type: 'linear',
                    display: true,
                    position: 'left',
                    beginAtZero: true
                },
                y1: {
                    type: 'linear',
                    display: true,
                    position: 'right',
                    beginAtZero: true,
                    grid: {
                        drawOnChartArea: false,
                    },
                }
            }
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/dashboard.blade.php ENDPATH**/ ?>