<?php $__env->startSection('title', 'Payroll Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Payroll Settings</h3>
                    <div>
                        <a href="<?php echo e(route('payroll.settings.edit')); ?>" class="btn btn-primary">
                            <i class="bi bi-edit"></i> Edit Settings
                        </a>
                        <button type="button" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#calculatorModal">
                            <i class="bi bi-calculator"></i> Test Calculator
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <!-- PAYE Settings -->
                        <div class="col-md-6">
                            <h5 class="text-primary">PAYE Tax Settings</h5>
                            <table class="table table-sm">
                                <tr>
                                    <td>Personal Relief:</td>
                                    <td>KES <?php echo e(number_format($settings->personal_relief, 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Insurance Relief Rate:</td>
                                    <td><?php echo e(($settings->insurance_relief_rate * 100)); ?>%</td>
                                </tr>
                                <tr>
                                    <td>Insurance Relief Max:</td>
                                    <td>KES <?php echo e(number_format($settings->insurance_relief_max, 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Pension Relief Rate:</td>
                                    <td><?php echo e(($settings->pension_relief_rate * 100)); ?>%</td>
                                </tr>
                                <tr>
                                    <td>Pension Relief Max:</td>
                                    <td>KES <?php echo e(number_format($settings->pension_relief_max, 2)); ?></td>
                                </tr>
                            </table>

                            <h6 class="text-secondary mt-3">PAYE Tax Bands</h6>
                            <table class="table table-sm table-striped">
                                <thead>
                                    <tr>
                                        <th>Income Range</th>
                                        <th>Rate</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $settings->paye_bands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $band): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            KES <?php echo e(number_format($band['min'])); ?> - 
                                            <?php if($band['max']): ?>
                                                KES <?php echo e(number_format($band['max'])); ?>

                                            <?php else: ?>
                                                Above
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e(($band['rate'] * 100)); ?>%</td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Statutory Deductions -->
                        <div class="col-md-6">
                            <h5 class="text-success">Statutory Deductions</h5>
                            
                            <h6 class="text-secondary">SHIF (Social Health Insurance Fund)</h6>
                            <table class="table table-sm">
                                <tr>
                                    <td>SHIF Rate:</td>
                                    <td><?php echo e(($settings->shif_rate * 100)); ?>%</td>
                                </tr>
                                <tr>
                                    <td>Minimum Contribution:</td>
                                    <td>KES <?php echo e(number_format($settings->shif_min_contribution, 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Tax Deductible:</td>
                                    <td><?php echo e($settings->shif_tax_deductible ? 'Yes' : 'No'); ?></td>
                                </tr>
                            </table>

                            <h6 class="text-secondary mt-3">NSSF (National Social Security Fund)</h6>
                            <table class="table table-sm">
                                <tr>
                                    <td>Employee Rate:</td>
                                    <td><?php echo e(($settings->nssf_employee_rate * 100)); ?>%</td>
                                </tr>
                                <tr>
                                    <td>Employer Rate:</td>
                                    <td><?php echo e(($settings->nssf_employer_rate * 100)); ?>%</td>
                                </tr>
                                <tr>
                                    <td>Lower Limit:</td>
                                    <td>KES <?php echo e(number_format($settings->nssf_lower_limit, 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Upper Limit:</td>
                                    <td>KES <?php echo e(number_format($settings->nssf_upper_limit, 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Max Employee Contribution:</td>
                                    <td>KES <?php echo e(number_format($settings->nssf_max_employee_contribution, 2)); ?></td>
                                </tr>
                            </table>

                            <h6 class="text-secondary mt-3">Housing Levy</h6>
                            <table class="table table-sm">
                                <tr>
                                    <td>Employee Rate:</td>
                                    <td><?php echo e(($settings->housing_levy_employee_rate * 100)); ?>%</td>
                                </tr>
                                <tr>
                                    <td>Employer Rate:</td>
                                    <td><?php echo e(($settings->housing_levy_employer_rate * 100)); ?>%</td>
                                </tr>
                                <tr>
                                    <td>Tax Deductible:</td>
                                    <td><?php echo e($settings->housing_levy_tax_deductible ? 'Yes' : 'No'); ?></td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <!-- Default Allowances -->
                        <div class="col-md-6">
                            <h5 class="text-warning">Default Allowances</h5>
                            <table class="table table-sm">
                                <tr>
                                    <td>House Allowance Rate:</td>
                                    <td><?php echo e(($settings->default_house_allowance_rate * 100)); ?>%</td>
                                </tr>
                                <tr>
                                    <td>Transport Allowance Rate:</td>
                                    <td><?php echo e(($settings->default_transport_allowance_rate * 100)); ?>%</td>
                                </tr>
                                <tr>
                                    <td>Max Transport Allowance:</td>
                                    <td>KES <?php echo e(number_format($settings->max_transport_allowance, 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Default Medical Allowance:</td>
                                    <td>KES <?php echo e(number_format($settings->default_medical_allowance, 2)); ?></td>
                                </tr>
                            </table>
                        </div>

                        <!-- Working Days & Compliance -->
                        <div class="col-md-6">
                            <h5 class="text-info">Working Days & Compliance</h5>
                            <table class="table table-sm">
                                <tr>
                                    <td>Monthly Working Days:</td>
                                    <td><?php echo e($settings->default_monthly_working_days); ?> days</td>
                                </tr>
                                <tr>
                                    <td>Weekly Working Days:</td>
                                    <td><?php echo e($settings->default_weekly_working_days); ?> days</td>
                                </tr>
                                <tr>
                                    <td>Hours Per Day:</td>
                                    <td><?php echo e($settings->default_hours_per_day); ?> hours</td>
                                </tr>
                            </table>

                            <h6 class="text-secondary mt-3">Submission Deadlines</h6>
                            <table class="table table-sm">
                                <tr>
                                    <td>KRA (PAYE):</td>
                                    <td><?php echo e($settings->kra_submission_deadline); ?>th of each month</td>
                                </tr>
                                <tr>
                                    <td>SHIF:</td>
                                    <td><?php echo e($settings->shif_submission_deadline); ?>th of each month</td>
                                </tr>
                                <tr>
                                    <td>NSSF:</td>
                                    <td><?php echo e($settings->nssf_submission_deadline); ?>th of each month</td>
                                </tr>
                                <tr>
                                    <td>Housing Levy:</td>
                                    <td><?php echo e($settings->housing_levy_submission_deadline); ?>th of each month</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="alert alert-info">
                                <strong>Configuration Version:</strong> <?php echo e($settings->config_version); ?><br>
                                <strong>Last Regulatory Update:</strong> <?php echo e($settings->last_regulatory_update->format('F j, Y')); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Calculator Modal -->
<div class="modal fade" id="calculatorModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Payroll Calculator Test</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="calculatorForm">
                    <div class="mb-3">
                        <label for="gross_salary" class="form-label">Gross Salary (KES)</label>
                        <input type="number" class="form-control" id="gross_salary" name="gross_salary" value="50000" step="0.01">
                    </div>
                    <button type="submit" class="btn btn-primary">Calculate</button>
                </form>
                
                <div id="calculationResults" class="mt-4" style="display: none;">
                    <h6>Calculation Results:</h6>
                    <table class="table table-sm">
                        <tr>
                            <td>Gross Salary:</td>
                            <td id="result-gross"></td>
                        </tr>
                        <tr>
                            <td>PAYE Tax:</td>
                            <td id="result-paye"></td>
                        </tr>
                        <tr>
                            <td>SHIF Contribution:</td>
                            <td id="result-shif"></td>
                        </tr>
                        <tr>
                            <td>NSSF Employee:</td>
                            <td id="result-nssf-employee"></td>
                        </tr>
                        <tr>
                            <td>Housing Levy Employee:</td>
                            <td id="result-housing-employee"></td>
                        </tr>
                        <tr class="table-warning">
                            <td><strong>Total Deductions:</strong></td>
                            <td id="result-total-deductions"></td>
                        </tr>
                        <tr class="table-success">
                            <td><strong>Net Salary:</strong></td>
                            <td id="result-net"></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.getElementById('calculatorForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    fetch('<?php echo e(route("payroll.settings.test")); ?>', {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        document.getElementById('result-gross').textContent = 'KES ' + parseFloat(data.gross_salary).toLocaleString();
        document.getElementById('result-paye').textContent = 'KES ' + parseFloat(data.paye_tax).toLocaleString();
        document.getElementById('result-shif').textContent = 'KES ' + parseFloat(data.shif_contribution).toLocaleString();
        document.getElementById('result-nssf-employee').textContent = 'KES ' + parseFloat(data.nssf_employee).toLocaleString();
        document.getElementById('result-housing-employee').textContent = 'KES ' + parseFloat(data.housing_levy_employee).toLocaleString();
        document.getElementById('result-total-deductions').textContent = 'KES ' + parseFloat(data.total_deductions).toLocaleString();
        document.getElementById('result-net').textContent = 'KES ' + parseFloat(data.net_salary).toLocaleString();
        
        document.getElementById('calculationResults').style.display = 'block';
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error calculating payroll. Please try again.');
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/payroll/settings/index.blade.php ENDPATH**/ ?>