<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Organization Admin Account Created</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .email-wrapper {
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
        }
        .header {
            background-color: #4F46E5;
            color: #ffffff;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .content {
            padding: 30px 20px;
        }
        .info-box {
            background-color: #F3F4F6;
            border-left: 4px solid #4F46E5;
            padding: 15px;
            margin: 20px 0;
        }
        .credentials-box {
            background-color: #FEF3C7;
            border: 2px solid #F59E0B;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .credential-item {
            margin: 10px 0;
        }
        .credential-label {
            font-weight: bold;
            color: #4F46E5;
        }
        .warning {
            background-color: #FEE2E2;
            border-left: 4px solid #DC2626;
            padding: 15px;
            margin: 20px 0;
        }
        .button {
            display: inline-block;
            background-color: #4F46E5;
            color: #ffffff;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 4px;
            margin: 20px 0;
        }
        .footer {
            background-color: #F9FAFB;
            padding: 20px;
            text-align: center;
            color: #6B7280;
            font-size: 14px;
        }
        ul {
            margin: 10px 0;
            padding-left: 20px;
        }
        li {
            margin: 8px 0;
        }
    </style>
</head>
<body>
    <div class="email-wrapper">
        <div class="header">
            <h1>🎉 Welcome to <?php echo e(config('app.name')); ?>!</h1>
            <p style="margin: 10px 0 0 0;">Your Organization is Ready</p>
        </div>

        <div class="content">
            <h2>Hello <?php echo e($adminUser->name); ?>,</h2>
            
            <p>Congratulations! Your organization has been successfully set up on <?php echo e(config('app.name')); ?>, and you have been designated as the Organization Administrator.</p>

            <div class="info-box">
                <h3 style="margin-top: 0;">Organization Details</h3>
                <p>
                    <strong>Organization Name:</strong> <?php echo e($organization->name); ?><br>
                    <strong>Organization ID:</strong> <?php echo e($organization->slug); ?><br>
                    <strong>Status:</strong> <?php echo e(ucfirst($organization->status)); ?><br>
                    <strong>Created:</strong> <?php echo e($organization->created_at->format('F d, Y')); ?>

                </p>
            </div>

            <div class="credentials-box">
                <h3 style="margin-top: 0;">Your Admin Login Credentials</h3>
                
                <div class="credential-item">
                    <div class="credential-label">Email / Username:</div>
                    <div><?php echo e($adminUser->email); ?></div>
                </div>
                
                <div class="credential-item">
                    <div class="credential-label">Temporary Password:</div>
                    <div><?php echo e($password); ?></div>
                </div>

                <div class="credential-item">
                    <div class="credential-label">Role:</div>
                    <div>Organization Administrator</div>
                </div>
            </div>

            <div class="warning">
                <strong>🔒 Important Security Notice:</strong><br>
                For security reasons, please change your password immediately after your first login.
            </div>

            <div style="text-align: center;">
                <a href="<?php echo e(config('app.url')); ?>/login" class="button">Access Admin Dashboard</a>
            </div>

            <h3>As Organization Administrator, You Can:</h3>
            <ul>
                <li>Manage employees and user accounts</li>
                <li>Configure departments and positions</li>
                <li>Set up payroll and compensation structures</li>
                <li>Manage leave policies and attendance</li>
                <li>Configure performance review processes</li>
                <li>Generate reports and analytics</li>
            </ul>

            <h3>Getting Started - Quick Setup:</h3>
            <ol>
                <li>Click the button above and use your credentials</li>
                <li>Change your password for security</li>
                <li>Complete your profile information</li>
                <li>Configure essential settings (see below)</li>
            </ol>

            <div class="warning">
                <h4 style="margin-top: 0;">⚙️ Configure These Settings First:</h4>
                
                <strong>1. Email Settings (Priority: HIGH)</strong>
                <p>Configure SMTP settings so employees receive emails from your domain.</p>
                
                <strong>2. Organization Structure</strong>
                <p>Set up departments and positions before adding employees.</p>
                
                <strong>3. Leave Policies</strong>
                <p>Define leave types (annual, sick, maternity, etc.).</p>
                
                <strong>4. Attendance Settings</strong>
                <p>Configure working hours and attendance rules.</p>
                
                <strong>5. Payroll Settings (if applicable)</strong>
                <p>Configure tax rates, deductions, and allowances.</p>
            </div>

            <div class="info-box">
                <strong>✅ Recommended Setup Order:</strong><br>
                1. Email Settings → 2. Departments & Positions → 3. Leave Policies → 4. Attendance Settings → 5. Start adding employees!
            </div>

            <h3>Need Assistance?</h3>
            <p>
                Our support team is here to help you get started.<br>
                <strong>Support Email:</strong> support{{ parse_url(config('app.url'), PHP_URL_HOST) }}
            </p>
        </div>

        <div class="footer">
            <p>This is an automated message from <?php echo e(config('app.name')); ?>.<br>
            Please do not reply to this email.</p>
            <p>&copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.</p>
        </div>
    </div>
</body>
</html><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/emails/organization-admin-created.blade.php ENDPATH**/ ?>