<?php $__env->startSection('title', 'Payroll Calculator'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Payroll Calculator</h1>
                <a href="<?php echo e(route('payroll.index')); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Back to Payroll
                </a>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <!-- Input Form -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Salary Information</h5>
                        </div>
                        <div class="card-body">
                            <form id="calculatorForm">
                                <div class="mb-3">
                                    <label for="employment_type" class="form-label">Employment Type</label>
                                    <select class="form-select" id="employment_type" name="employment_type" required>
                                        <option value="">Select Employment Type</option>
                                        <?php $__currentLoopData = $employmentTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($value); ?>"><?php echo e($label); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label for="basic_salary" class="form-label">Basic Salary (KES)</label>
                                    <input type="number" class="form-control" id="basic_salary" name="basic_salary" 
                                           min="0" step="0.01" placeholder="Enter basic salary" required>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="house_allowance" class="form-label">House Allowance (KES)</label>
                                            <input type="number" class="form-control" id="house_allowance" name="house_allowance" 
                                                   min="0" step="0.01" placeholder="0.00">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="transport_allowance" class="form-label">Transport Allowance (KES)</label>
                                            <input type="number" class="form-control" id="transport_allowance" name="transport_allowance" 
                                                   min="0" step="0.01" placeholder="0.00">
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="medical_allowance" class="form-label">Medical Allowance (KES)</label>
                                            <input type="number" class="form-control" id="medical_allowance" name="medical_allowance" 
                                                   min="0" step="0.01" placeholder="0.00">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="other_allowances" class="form-label">Other Allowances (KES)</label>
                                            <input type="number" class="form-control" id="other_allowances" name="other_allowances" 
                                                   min="0" step="0.01" placeholder="0.00">
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="bonuses" class="form-label">Bonuses (KES)</label>
                                            <input type="number" class="form-control" id="bonuses" name="bonuses" 
                                                   min="0" step="0.01" placeholder="0.00">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="overtime_pay" class="form-label">Overtime Pay (KES)</label>
                                            <input type="number" class="form-control" id="overtime_pay" name="overtime_pay" 
                                                   min="0" step="0.01" placeholder="0.00">
                                        </div>
                                    </div>
                                </div>

                                <div class="d-grid">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-calculator"></i> Calculate Payroll
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <!-- Results -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Calculation Results</h5>
                        </div>
                        <div class="card-body">
                            <div id="calculationResults" class="d-none">
                                <!-- Employment Type Info -->
                                <div class="alert alert-info mb-3">
                                    <h6 class="mb-2">Employment Type: <span id="resultEmploymentType"></span></h6>
                                    <div id="taxRulesInfo"></div>
                                </div>

                                <!-- Salary Breakdown -->
                                <div class="row mb-3">
                                    <div class="col-6">
                                        <div class="card bg-light">
                                            <div class="card-body text-center">
                                                <h4 class="text-primary mb-0" id="grossSalary">KES 0.00</h4>
                                                <small class="text-muted">Gross Salary</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="card bg-light">
                                            <div class="card-body text-center">
                                                <h4 class="text-success mb-0" id="netSalary">KES 0.00</h4>
                                                <small class="text-muted">Net Salary</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Deductions Breakdown -->
                                <div class="table-responsive">
                                    <table class="table table-sm">
                                        <thead class="table-dark">
                                            <tr>
                                                <th>Deduction</th>
                                                <th class="text-end">Amount (KES)</th>
                                            </tr>
                                        </thead>
                                        <tbody id="deductionsTable">
                                            <!-- Populated by JavaScript -->
                                        </tbody>
                                        <tfoot class="table-secondary">
                                            <tr>
                                                <th>Total Deductions</th>
                                                <th class="text-end" id="totalDeductions">KES 0.00</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>

                                <!-- Allowances Breakdown -->
                                <div class="mt-3">
                                    <h6>Allowances Breakdown</h6>
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                            <tbody id="allowancesTable">
                                                <!-- Populated by JavaScript -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <div id="noResults" class="text-center py-5">
                                <i class="bi bi-calculator fa-3x text-muted mb-3"></i>
                                <h5 class="text-muted">Enter salary details to calculate</h5>
                                <p class="text-muted">Fill in the form on the left to see payroll calculations.</p>
                            </div>

                            <div id="loadingResults" class="text-center py-5 d-none">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Calculating...</span>
                                </div>
                                <p class="mt-2 text-muted">Calculating payroll...</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('calculatorForm');
    const resultsDiv = document.getElementById('calculationResults');
    const noResultsDiv = document.getElementById('noResults');
    const loadingDiv = document.getElementById('loadingResults');

    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        // Show loading
        resultsDiv.classList.add('d-none');
        noResultsDiv.classList.add('d-none');
        loadingDiv.classList.remove('d-none');

        // Collect form data
        const formData = new FormData(form);
        const data = Object.fromEntries(formData.entries());
        
        // Convert empty values to 0 for numeric fields
        const numericFields = ['basic_salary', 'house_allowance', 'transport_allowance', 'medical_allowance', 'other_allowances', 'bonuses', 'overtime_pay'];
        numericFields.forEach(field => {
            if (!data[field] || data[field] === '') {
                data[field] = '0';
            }
        });

        // Make AJAX request
        fetch('<?php echo e(route("payroll.calculatePreview")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify(data)
        })
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            if (data.error) {
                throw new Error(data.message || data.error);
            }
            displayResults(data);
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while calculating payroll: ' + error.message);
        })
        .finally(() => {
            loadingDiv.classList.add('d-none');
        });
    });

    function displayResults(data) {
        const calculations = data.calculations;
        const taxRules = data.tax_rules;

        // Update employment type
        document.getElementById('resultEmploymentType').textContent = 
            data.employment_type.charAt(0).toUpperCase() + data.employment_type.slice(1);

        // Update tax rules info
        const taxRulesHtml = `
            <small>
                PAYE: ${taxRules.paye_applicable ? 'Yes' : 'No'} | 
                NHIF: ${taxRules.nhif_applicable ? 'Yes' : 'No'} | 
                NSSF: ${taxRules.nssf_applicable ? 'Yes' : 'No'} | 
                Housing Levy: ${taxRules.housing_levy_applicable ? 'Yes' : 'No'}
                ${taxRules.withholding_tax_applicable ? ` | Withholding Tax: ${(taxRules.withholding_tax_rate * 100)}%` : ''}
            </small>
        `;
        document.getElementById('taxRulesInfo').innerHTML = taxRulesHtml;

        // Update salary amounts
        document.getElementById('grossSalary').textContent = 'KES ' + numberFormat(calculations.gross_salary);
        document.getElementById('netSalary').textContent = 'KES ' + numberFormat(calculations.net_salary);
        document.getElementById('totalDeductions').textContent = 'KES ' + numberFormat(calculations.total_deductions);

        // Update deductions table
        const deductionsTable = document.getElementById('deductionsTable');
        deductionsTable.innerHTML = '';

        const deductions = [
            { name: 'PAYE Tax', amount: calculations.paye_tax },
            { name: 'NHIF', amount: calculations.nhif_deduction },
            { name: 'NSSF', amount: calculations.nssf_employee },
            { name: 'Housing Levy', amount: calculations.housing_levy }
        ];

        if (calculations.withholding_tax) {
            deductions.push({ name: 'Withholding Tax', amount: calculations.withholding_tax });
        }

        deductions.forEach(deduction => {
            if (deduction.amount > 0) {
                const row = `
                    <tr>
                        <td>${deduction.name}</td>
                        <td class="text-end">KES ${numberFormat(deduction.amount)}</td>
                    </tr>
                `;
                deductionsTable.innerHTML += row;
            }
        });

        // Update allowances table
        const allowancesTable = document.getElementById('allowancesTable');
        allowancesTable.innerHTML = '';

        const allowances = [
            { name: 'Basic Salary', amount: calculations.basic_salary },
            { name: 'House Allowance', amount: calculations.house_allowance },
            { name: 'Transport Allowance', amount: calculations.transport_allowance },
            { name: 'Medical Allowance', amount: calculations.medical_allowance },
            { name: 'Other Allowances', amount: calculations.other_allowances },
            { name: 'Bonuses', amount: calculations.bonuses },
            { name: 'Overtime Pay', amount: calculations.overtime_pay }
        ];

        allowances.forEach(allowance => {
            if (allowance.amount > 0) {
                const row = `
                    <tr>
                        <td>${allowance.name}</td>
                        <td class="text-end">KES ${numberFormat(allowance.amount)}</td>
                    </tr>
                `;
                allowancesTable.innerHTML += row;
            }
        });

        // Show results
        resultsDiv.classList.remove('d-none');
        noResultsDiv.classList.add('d-none');
    }

    function numberFormat(number) {
        return new Intl.NumberFormat('en-KE', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        }).format(number);
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/payroll/calculator.blade.php ENDPATH**/ ?>