<?php $__env->startSection('title', 'Manage Training Programs'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Manage Training Programs</h1>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\TrainingProgram::class)): ?>
                    <a href="<?php echo e(route('training.programs.create')); ?>" class="btn btn-primary">
                        <i class="bi bi-plus"></i> Create Program
                    </a>
                <?php endif; ?>
            </div>

            <!-- Filters -->
            <div class="card mb-4">
                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('training.programs.index')); ?>">
                        <div class="row">
                            <div class="col-md-3">
                                <select name="category" class="form-select">
                                    <option value="">All Categories</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>" <?php echo e(request('category') == $category->id ? 'selected' : ''); ?>>
                                            <?php echo e($category->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="type" class="form-select">
                                    <option value="">All Types</option>
                                    <option value="internal" <?php echo e(request('type') == 'internal' ? 'selected' : ''); ?>>Internal</option>
                                    <option value="external" <?php echo e(request('type') == 'external' ? 'selected' : ''); ?>>External</option>
                                    <option value="online" <?php echo e(request('type') == 'online' ? 'selected' : ''); ?>>Online</option>
                                    <option value="workshop" <?php echo e(request('type') == 'workshop' ? 'selected' : ''); ?>>Workshop</option>
                                    <option value="seminar" <?php echo e(request('type') == 'seminar' ? 'selected' : ''); ?>>Seminar</option>
                                    <option value="certification" <?php echo e(request('type') == 'certification' ? 'selected' : ''); ?>>Certification</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="status" class="form-select">
                                    <option value="">All Status</option>
                                    <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                                    <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                                </select>
                            </div>
                            <div class="col-md-5">
                                <div class="input-group">
                                    <input type="text" name="search" class="form-control" placeholder="Search programs..." value="<?php echo e(request('search')); ?>">
                                    <button class="btn btn-outline-secondary" type="submit">
                                        <i class="bi bi-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Programs Table -->
            <div class="card">
                <div class="card-body">
                    <?php if($programs->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Program</th>
                                        <th>Category</th>
                                        <th>Type</th>
                                        <th>Duration</th>
                                        <th>Status</th>
                                        <th>Created</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $programs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $program): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <div>
                                                    <strong><?php echo e($program->title); ?></strong>
                                                    <?php if($program->is_mandatory): ?>
                                                        <span class="badge badge-warning ms-1">Mandatory</span>
                                                    <?php endif; ?>
                                                    <br>
                                                    <small class="text-muted"><?php echo e(Str::limit($program->description, 60)); ?></small>
                                                </div>
                                            </td>
                                            <td>
                                                <span class="badge" style="background-color: <?php echo e($program->category->color); ?>">
                                                    <?php echo e($program->category->name); ?>

                                                </span>
                                            </td>
                                            <td><?php echo e(ucfirst($program->type)); ?></td>
                                            <td><?php echo e($program->formatted_duration); ?></td>
                                            <td>
                                                <span class="badge badge-<?php echo e($program->is_active ? 'success' : 'secondary'); ?>">
                                                    <?php echo e($program->is_active ? 'Active' : 'Inactive'); ?>

                                                </span>
                                            </td>
                                            <td><?php echo e($program->created_at->format('M j, Y')); ?></td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $program)): ?>
                                                        <a href="<?php echo e(route('training.programs.show', $program)); ?>" class="btn btn-sm btn-outline-primary">
                                                            <i class="bi bi-eye"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $program)): ?>
                                                        <a href="<?php echo e(route('training.programs.edit', $program)); ?>" class="btn btn-sm btn-outline-secondary">
                                                            <i class="bi bi-pencil"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\TrainingSession::class)): ?>
                                                        <a href="<?php echo e(route('training.sessions.create', ['program_id' => $program->id])); ?>" class="btn btn-sm btn-outline-success">
                                                            <i class="bi bi-calendar-plus"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="d-flex justify-content-center">
                            <?php echo e($programs->withQueryString()->links()); ?>

                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="bi bi-book fa-3x text-muted mb-3"></i>
                            <h4>No Training Programs Found</h4>
                            <p class="text-muted">No training programs match your current filters.</p>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\TrainingProgram::class)): ?>
                                <a href="<?php echo e(route('training.programs.create')); ?>" class="btn btn-primary">
                                    <i class="bi bi-plus"></i> Create First Program
                                </a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/training/programs/index.blade.php ENDPATH**/ ?>