<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Application Received</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .email-wrapper {
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
        }
        .header {
            background-color: #4F46E5;
            color: #ffffff;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .content {
            padding: 30px 20px;
        }
        .info-box {
            background-color: #F3F4F6;
            border-left: 4px solid #4F46E5;
            padding: 15px;
            margin: 20px 0;
        }
        .credentials-box {
            background-color: #FEF3C7;
            border: 2px solid #F59E0B;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .credential-item {
            margin: 10px 0;
        }
        .credential-label {
            font-weight: bold;
            color: #4F46E5;
        }
        .warning {
            background-color: #FEE2E2;
            border-left: 4px solid #DC2626;
            padding: 15px;
            margin: 20px 0;
        }
        .button {
            display: inline-block;
            background-color: #4F46E5;
            color: #ffffff;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 4px;
            margin: 20px 0;
        }
        .footer {
            background-color: #F9FAFB;
            padding: 20px;
            text-align: center;
            color: #6B7280;
            font-size: 14px;
        }
        ul {
            margin: 10px 0;
            padding-left: 20px;
        }
        li {
            margin: 8px 0;
        }
    </style>
</head>
<body>
    <div class="email-wrapper">
        <div class="header">
            <h1><?php echo e($organizationName); ?></h1>
            <p style="margin: 10px 0 0 0;">Application Confirmation</p>
        </div>

        <div class="content">
            <h2>Dear <?php echo e($application->full_name); ?>,</h2>
            
            <p>Thank you for your interest in joining our team! We have successfully received your application for the following position:</p>

            <div class="info-box">
                <h3 style="margin-top: 0;"><?php echo e($jobPosting->title); ?></h3>
                <p>
                    <strong>Department:</strong> <?php echo e($jobPosting->department->name); ?><br>
                    <strong>Location:</strong> <?php echo e($jobPosting->location); ?><br>
                    <strong>Employment Type:</strong> <?php echo e(ucfirst($jobPosting->employment_type)); ?><br>
                    <strong>Application Date:</strong> <?php echo e($application->applied_at->format('F j, Y \a\t g:i A')); ?>

                </p>
            </div>

            <div class="credentials-box">
                <h3 style="margin-top: 0;">📍 Track Your Application</h3>
                <p>You can track your application status anytime using the link below:</p>
                <div style="text-align: center; margin: 15px 0;">
                    <a href="<?php echo e($trackingUrl); ?>" class="button">View Application Status</a>
                </div>
            </div>

            <h3>What happens next?</h3>
            <ul>
                <li>Our HR team will review your application within 3-5 business days</li>
                <li>If your profile matches our requirements, we'll contact you for the next steps</li>
                <li>You'll receive email updates as your application progresses</li>
            </ul>

            <p>We appreciate your interest in <?php echo e($organizationName); ?> and look forward to potentially welcoming you to our team.</p>

            <p>Best regards,<br>
            <strong><?php echo e($organizationName); ?> HR Team</strong></p>
        </div>

        <div class="footer">
            <p>This is an automated message from <?php echo e($organizationName); ?>.<br>
            Please do not reply to this email.</p>
        </div>
    </div>
</body>
</html><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/emails/application-received.blade.php ENDPATH**/ ?>