<?php $__env->startSection('title', 'Upgrade Subscription'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <h2><i class="bi bi-arrow-up-circle"></i> Upgrade Subscription</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('subscription.show')); ?>">Subscription</a></li>
                    <li class="breadcrumb-item active">Upgrade to <?php echo e($plan->name); ?></li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <!-- Current Plan -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-secondary text-white">
                    <h5 class="mb-0"><i class="bi bi-star"></i> Current Plan</h5>
                </div>
                <div class="card-body">
                    <h3><?php echo e($currentSubscription->plan->name); ?></h3>
                    <p class="text-muted"><?php echo e($currentSubscription->plan->description); ?></p>
                    
                    <div class="mb-3">
                        <h4 class="text-primary">
                            KES <?php echo e(number_format($currentSubscription->plan->price_monthly, 0)); ?>

                            <small class="text-muted">/month</small>
                        </h4>
                    </div>

                    <h6 class="mb-3">Current Features:</h6>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="bi bi-people text-primary"></i>
                            <strong><?php echo e($currentSubscription->plan->max_employees ?? 'Unlimited'); ?></strong> Employees
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-person-check text-primary"></i>
                            <strong><?php echo e($currentSubscription->plan->max_users ?? 'Unlimited'); ?></strong> Users
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-diagram-3 text-primary"></i>
                            <strong><?php echo e($currentSubscription->plan->max_departments ?? 'Unlimited'); ?></strong> Departments
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-hdd text-primary"></i>
                            <strong><?php echo e($currentSubscription->plan->storage_limit_gb ?? 'Unlimited'); ?> GB</strong> Storage
                        </li>
                        <?php if($currentSubscription->plan->features['api_access'] ?? false): ?>
                        <li class="mb-2">
                            <i class="bi bi-code-square text-success"></i>
                            API Access
                        </li>
                        <?php endif; ?>
                    </ul>

                    <div class="mt-3">
                        <span class="badge bg-secondary">Current Plan</span>
                        <?php if($currentSubscription->status === 'trial'): ?>
                            <span class="badge bg-info">Trial - <?php echo e($currentSubscription->trialDaysRemaining()); ?> days left</span>
                        <?php else: ?>
                            <span class="badge bg-success">Active</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- New Plan -->
        <div class="col-md-6">
            <div class="card border-primary">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-star-fill"></i> Upgrade To</h5>
                </div>
                <div class="card-body">
                    <h3><?php echo e($plan->name); ?></h3>
                    <p class="text-muted"><?php echo e($plan->description); ?></p>
                    
                    <div class="mb-3">
                        <h4 class="text-success">
                            KES <?php echo e(number_format($plan->price_monthly, 0)); ?>

                            <small class="text-muted">/month</small>
                        </h4>
                        <p class="text-muted mb-0">
                            <small>
                                Increase: KES <?php echo e(number_format($plan->price_monthly - $currentSubscription->plan->price_monthly, 0)); ?>/month
                            </small>
                        </p>
                    </div>

                    <h6 class="mb-3">New Features:</h6>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="bi bi-people text-success"></i>
                            <strong><?php echo e($plan->max_employees ?? 'Unlimited'); ?></strong> Employees
                            <?php if(($plan->max_employees ?? PHP_INT_MAX) > ($currentSubscription->plan->max_employees ?? 0)): ?>
                                <span class="badge bg-success">+<?php echo e(($plan->max_employees ?? 'Unlimited') - ($currentSubscription->plan->max_employees ?? 0)); ?></span>
                            <?php endif; ?>
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-person-check text-success"></i>
                            <strong><?php echo e($plan->max_users ?? 'Unlimited'); ?></strong> Users
                            <?php if(($plan->max_users ?? PHP_INT_MAX) > ($currentSubscription->plan->max_users ?? 0)): ?>
                                <span class="badge bg-success">+<?php echo e(($plan->max_users ?? 'Unlimited') - ($currentSubscription->plan->max_users ?? 0)); ?></span>
                            <?php endif; ?>
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-diagram-3 text-success"></i>
                            <strong><?php echo e($plan->max_departments ?? 'Unlimited'); ?></strong> Departments
                            <?php if(($plan->max_departments ?? PHP_INT_MAX) > ($currentSubscription->plan->max_departments ?? 0)): ?>
                                <span class="badge bg-success">+<?php echo e(($plan->max_departments ?? 'Unlimited') - ($currentSubscription->plan->max_departments ?? 0)); ?></span>
                            <?php endif; ?>
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-hdd text-success"></i>
                            <strong><?php echo e($plan->storage_limit_gb ?? 'Unlimited'); ?> GB</strong> Storage
                            <?php if(($plan->storage_limit_gb ?? PHP_INT_MAX) > ($currentSubscription->plan->storage_limit_gb ?? 0)): ?>
                                <span class="badge bg-success">+<?php echo e(($plan->storage_limit_gb ?? 'Unlimited') - ($currentSubscription->plan->storage_limit_gb ?? 0)); ?> GB</span>
                            <?php endif; ?>
                        </li>
                        <?php if($plan->features['api_access'] ?? false): ?>
                        <li class="mb-2">
                            <i class="bi bi-code-square text-success"></i>
                            API Access
                            <?php if(!($currentSubscription->plan->features['api_access'] ?? false)): ?>
                                <span class="badge bg-success">NEW</span>
                            <?php endif; ?>
                        </li>
                        <?php endif; ?>
                        <?php if($plan->features['white_label'] ?? false): ?>
                        <li class="mb-2">
                            <i class="bi bi-palette text-success"></i>
                            White Label
                            <?php if(!($currentSubscription->plan->features['white_label'] ?? false)): ?>
                                <span class="badge bg-success">NEW</span>
                            <?php endif; ?>
                        </li>
                        <?php endif; ?>
                        <?php if($plan->features['priority_support'] ?? false): ?>
                        <li class="mb-2">
                            <i class="bi bi-headset text-success"></i>
                            Priority Support
                            <?php if(!($currentSubscription->plan->features['priority_support'] ?? false)): ?>
                                <span class="badge bg-success">NEW</span>
                            <?php endif; ?>
                        </li>
                        <?php endif; ?>
                    </ul>

                    <div class="mt-3">
                        <span class="badge bg-primary">Upgrade Plan</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Upgrade Confirmation -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-info-circle"></i> Upgrade Details</h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-info">
                        <h6><i class="bi bi-info-circle"></i> What happens when you upgrade?</h6>
                        <ul class="mb-0">
                            <li>Your subscription will be upgraded to <strong><?php echo e($plan->name); ?></strong> immediately</li>
                            <li>You'll get access to all new features right away</li>
                            <li>A prorated invoice will be generated for the remaining billing period</li>
                            <li>Your next billing date remains the same</li>
                            <li>You can downgrade or cancel anytime</li>
                        </ul>
                    </div>

                    <?php if($currentSubscription->status === 'trial'): ?>
                    <div class="alert alert-warning">
                        <h6><i class="bi bi-exclamation-triangle"></i> Trial Period</h6>
                        <p class="mb-0">
                            You are currently on a trial period with <strong><?php echo e($currentSubscription->trialDaysRemaining()); ?> days</strong> remaining.
                            Upgrading will convert your trial to a paid subscription.
                        </p>
                    </div>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route('subscription.process-upgrade', $plan)); ?>" id="upgrade-form">
                        <?php echo csrf_field(); ?>
                        
                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" id="confirm_upgrade" name="confirm_upgrade" required>
                            <label class="form-check-label" for="confirm_upgrade">
                                I understand that I will be charged KES <?php echo e(number_format($plan->price_monthly, 0)); ?>/month starting from the next billing cycle
                            </label>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary btn-lg" id="upgrade-button">
                                <i class="bi bi-arrow-up-circle"></i> Upgrade to <?php echo e($plan->name); ?>

                            </button>
                            <a href="<?php echo e(route('subscription.show')); ?>" class="btn btn-outline-secondary btn-lg">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.getElementById('upgrade-form').addEventListener('submit', function(e) {
    const button = document.getElementById('upgrade-button');
    button.disabled = true;
    button.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Processing...';
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/organization/subscription/upgrade.blade.php ENDPATH**/ ?>