<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Employee Report</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            margin: 0;
            color: #ff8c00;
        }
        .meta-info {
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #ff8c00;
            color: black;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Employee Report</h1>
        <p><?php echo e(config('app.name')); ?></p>
    </div>

    <div class="meta-info">
        <p><strong>Generated:</strong> <?php echo e(now()->format('F d, Y h:i A')); ?></p>
        <?php if(request('department_id')): ?>
        <p><strong>Department:</strong> <?php echo e($departments->find(request('department_id'))->name ?? 'All'); ?></p>
        <?php endif; ?>
        <?php if(request('status')): ?>
        <p><strong>Status:</strong> <?php echo e(ucfirst(request('status'))); ?></p>
        <?php endif; ?>
    </div>

    <table>
        <thead>
            <tr>
                <th>Code</th>
                <th>Name</th>
                <th>Email</th>
                <th>Department</th>
                <th>Position</th>
                <th>Join Date</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($employee->employee_code); ?></td>
                <td><?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?></td>
                <td><?php echo e($employee->email); ?></td>
                <td><?php echo e($employee->department?->name); ?></td>
                <td><?php echo e($employee->position?->name); ?></td>
                <td><?php echo e($employee->join_date ? \Carbon\Carbon::parse($employee->join_date)->format('M d, Y') : 'N/A'); ?></td>
                <td><?php echo e(ucfirst($employee->status)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="footer">
        <p>This is a system-generated report. Generated on <?php echo e(now()->format('F d, Y h:i A')); ?></p>
        <p>Total Employees: <?php echo e($employees->count()); ?></p>
    </div>
</body>
</html>
<?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/exports/employee-pdf.blade.php ENDPATH**/ ?>