<div class="table-responsive">
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th>Date & Time</th>
                <th>User</th>
                <th>Organization</th>
                <th>Event</th>
                <th>Category</th>
                <th>Severity</th>
                <th>Description</th>
                <th>IP Address</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td>
                        <small><?php echo e($log->created_at->format('Y-m-d H:i:s')); ?></small>
                    </td>
                    <td>
                        <?php if($log->user): ?>
                            <div class="d-flex align-items-center">
                                <div>
                                    <strong><?php echo e($log->user->name); ?></strong><br>
                                    <small class="text-muted"><?php echo e($log->user->email); ?></small>
                                </div>
                            </div>
                        <?php else: ?>
                            <span class="text-muted">System</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if($log->organization): ?>
                            <span class="badge bg-primary"><?php echo e($log->organization->name); ?></span>
                        <?php else: ?>
                            <span class="badge bg-secondary">System</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <code><?php echo e($log->event_type); ?></code>
                    </td>
                    <td>
                        <span class="badge bg-<?php echo e($log->category_color); ?>">
                            <?php echo e(ucfirst(str_replace('_', ' ', $log->category))); ?>

                        </span>
                    </td>
                    <td>
                        <span class="badge bg-<?php echo e($log->severity_color); ?>">
                            <?php echo e(ucfirst($log->severity)); ?>

                        </span>
                    </td>
                    <td>
                        <div style="max-width: 300px;">
                            <?php echo e(Str::limit($log->description, 100)); ?>

                            <?php if($log->auditable_type): ?>
                                <br><small class="text-muted"><?php echo e($log->model_name); ?> #<?php echo e($log->auditable_id); ?></small>
                            <?php endif; ?>
                        </div>
                    </td>
                    <td>
                        <small><?php echo e($log->ip_address); ?></small>
                    </td>
                    <td>
                        <a href="<?php echo e(route('system-admin.audit-logs.show', $log)); ?>" 
                           class="btn btn-sm btn-outline-primary" 
                           title="View Details">
                            <i class="bi bi-eye"></i>
                        </a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="9" class="text-center py-4">
                        <div class="d-flex flex-column align-items-center">
                            <i class="bi bi-inbox fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No audit records found</h5>
                            <p class="text-muted">Try adjusting your filters or date range.</p>
                        </div>
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php if($logs->hasPages()): ?>
    <div class="d-flex justify-content-between align-items-center mt-3">
        <div>
            <small class="text-muted">
                Showing <?php echo e($logs->firstItem()); ?> to <?php echo e($logs->lastItem()); ?> of <?php echo e($logs->total()); ?> results
            </small>
        </div>
        <div>
            <?php echo e($logs->links()); ?>

        </div>
    </div>
<?php endif; ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/systemadmin/audit-logs/table.blade.php ENDPATH**/ ?>