<?php $__env->startSection('title', 'Attendance Report'); ?>
<?php $__env->startSection('page-title', 'Attendance Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Summary Statistics -->
    <div class="row mb-4">
        <div class="col-md-2">
            <div class="stat-card primary">
                <div class="text-center">
                    <div class="stat-icon mx-auto mb-2" style="width: 50px; height: 50px;">
                        <i class="bi bi-calendar-check"></i>
                    </div>
                    <h6 class="text-muted mb-1">Total Days</h6>
                    <h3 class="mb-0"><?php echo e($summary['total_days']); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card success">
                <div class="text-center">
                    <div class="stat-icon mx-auto mb-2" style="width: 50px; height: 50px;">
                        <i class="bi bi-check-circle"></i>
                    </div>
                    <h6 class="text-muted mb-1">Present</h6>
                    <h3 class="mb-0"><?php echo e($summary['present']); ?></h3>
                    <small class="text-success"><?php echo e($summary['present_percentage']); ?>%</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card danger">
                <div class="text-center">
                    <div class="stat-icon mx-auto mb-2" style="width: 50px; height: 50px;">
                        <i class="bi bi-x-circle"></i>
                    </div>
                    <h6 class="text-muted mb-1">Absent</h6>
                    <h3 class="mb-0"><?php echo e($summary['absent']); ?></h3>
                    <small class="text-danger"><?php echo e($summary['absent_percentage']); ?>%</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card warning">
                <div class="text-center">
                    <div class="stat-icon mx-auto mb-2" style="width: 50px; height: 50px;">
                        <i class="bi bi-clock"></i>
                    </div>
                    <h6 class="text-muted mb-1">Late</h6>
                    <h3 class="mb-0"><?php echo e($summary['late']); ?></h3>
                    <small class="text-warning"><?php echo e($summary['late_percentage']); ?>%</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card info">
                <div class="text-center">
                    <div class="stat-icon mx-auto mb-2" style="width: 50px; height: 50px;">
                        <i class="bi bi-slash-circle"></i>
                    </div>
                    <h6 class="text-muted mb-1">Half Day</h6>
                    <h3 class="mb-0"><?php echo e($summary['half_day']); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card secondary">
                <div class="text-center">
                    <div class="stat-icon mx-auto mb-2" style="width: 50px; height: 50px;">
                        <i class="bi bi-calendar-x"></i>
                    </div>
                    <h6 class="text-muted mb-1">On Leave</h6>
                    <h3 class="mb-0"><?php echo e($summary['on_leave']); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Attendance Rate Card -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="table-card">
                <div class="row align-items-center">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h2 class="text-primary mb-1"><?php echo e($summary['attendance_rate']); ?>%</h2>
                            <p class="text-muted mb-0">Overall Attendance Rate</p>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="progress" style="height: 20px;">
                            <div class="progress-bar bg-success" style="width: <?php echo e($summary['present_percentage']); ?>%"></div>
                            <div class="progress-bar bg-warning" style="width: <?php echo e($summary['late_percentage']); ?>%"></div>
                            <div class="progress-bar bg-danger" style="width: <?php echo e($summary['absent_percentage']); ?>%"></div>
                        </div>
                        <div class="d-flex justify-content-between mt-2">
                            <small class="text-success">Present: <?php echo e($summary['present_percentage']); ?>%</small>
                            <small class="text-warning">Late: <?php echo e($summary['late_percentage']); ?>%</small>
                            <small class="text-danger">Absent: <?php echo e($summary['absent_percentage']); ?>%</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Department Breakdown -->
    <?php if(isset($departmentBreakdown) && $departmentBreakdown->count() > 0): ?>
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="table-card">
                <h6 class="mb-3">Department-wise Attendance Breakdown</h6>
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead class="table-light">
                            <tr>
                                <th>Department</th>
                                <th>Total Records</th>
                                <th>Present</th>
                                <th>Late</th>
                                <th>Absent</th>
                                <th>Attendance Rate</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $departmentBreakdown; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($dept['name']); ?></td>
                                <td><?php echo e($dept['total']); ?></td>
                                <td><span class="badge bg-success"><?php echo e($dept['present']); ?></span></td>
                                <td><span class="badge bg-warning"><?php echo e($dept['late']); ?></span></td>
                                <td><span class="badge bg-danger"><?php echo e($dept['absent']); ?></span></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="progress me-2" style="width: 60px; height: 8px;">
                                            <div class="progress-bar bg-primary" style="width: <?php echo e($dept['attendance_rate']); ?>%"></div>
                                        </div>
                                        <small><?php echo e($dept['attendance_rate']); ?>%</small>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Filter & Report Table -->
    <div class="table-card">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="mb-0">Attendance Report</h5>
            <div>
                <a href="<?php echo e(route('reports.index')); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Back to Reports
                </a>
                <a href="<?php echo e(route('reports.attendance.pdf', request()->all())); ?>" class="btn btn-danger">
                    <i class="bi bi-file-pdf"></i> Export PDF
                </a>
                <button onclick="window.print()" class="btn btn-primary">
                    <i class="bi bi-printer"></i> Print
                </button>
            </div>
        </div>

        <!-- Filter Form -->
        <form method="GET" class="row g-3 mb-4">
            <div class="col-md-3">
                <label class="form-label">Start Date</label>
                <input type="date" name="start_date" class="form-control" value="<?php echo e($startDate); ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">End Date</label>
                <input type="date" name="end_date" class="form-control" value="<?php echo e($endDate); ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">Department</label>
                <select name="department" class="form-select">
                    <option value="">All Departments</option>
                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($dept->id); ?>" <?php echo e(request('department') == $dept->id ? 'selected' : ''); ?>>
                            <?php echo e($dept->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">&nbsp;</label>
                <button type="submit" class="btn btn-primary w-100">
                    <i class="bi bi-funnel"></i> Filter
                </button>
            </div>
        </form>

        <!-- Attendance Table -->
        <div class="table-responsive">
            <table class="table table-bordered table-sm">
                <thead class="table-light">
                    <tr>
                        <th>Date</th>
                        <th>Employee</th>
                        <th>Department</th>
                        <th>Check In</th>
                        <th>Check Out</th>
                        <th>Work Hours</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e(\Carbon\Carbon::parse($attendance->date)->format('M d, Y')); ?></td>
                            <td><?php echo e($attendance->employee->full_name); ?></td>
                            <td><?php echo e($attendance->employee->department->name ?? 'N/A'); ?></td>
                            <td><?php echo e($attendance->check_in ? \Carbon\Carbon::parse($attendance->check_in)->format('h:i A') : 'N/A'); ?></td>
                            <td><?php echo e($attendance->check_out ? \Carbon\Carbon::parse($attendance->check_out)->format('h:i A') : 'N/A'); ?></td>
                            <td><?php echo e($attendance->work_hours ?? 'N/A'); ?></td>
                            <td>
                                <?php
                                    $badgeClass = match($attendance->status) {
                                        'present' => 'bg-success',
                                        'absent' => 'bg-danger',
                                        'late' => 'bg-warning',
                                        'half_day' => 'bg-info',
                                        'on_leave' => 'bg-secondary',
                                        default => 'bg-secondary'
                                    };
                                ?>
                                <span class="badge <?php echo e($badgeClass); ?>"><?php echo e(ucwords(str_replace('_', ' ', $attendance->status))); ?></span>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center py-3 text-muted">No attendance records found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
    @media print {
        .sidebar, .top-navbar, .btn, form { display: none !important; }
        .main-content { margin-left: 0 !important; }
        .table-card { box-shadow: none !important; }
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/reports/attendance.blade.php ENDPATH**/ ?>