<?php $__env->startSection('title', 'Detailed Recruitment Report'); ?>
<?php $__env->startSection('page-title', 'Detailed Recruitment Report'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-4">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('job-postings.index')); ?>">Recruitment</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('recruitment.reports.index')); ?>">Reports</a></li>
                <li class="breadcrumb-item active">Detailed Report</li>
            </ol>
        </nav>
    </div>

    <!-- Filters -->
    <div class="card shadow-sm mb-4">
        <div class="card-header bg-white">
            <h5 class="mb-0">Report Filters</h5>
        </div>
        <div class="card-body">
            <form method="GET" class="row">
                <div class="col-md-3">
                    <label class="form-label">Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="<?php echo e($startDate); ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">End Date</label>
                    <input type="date" name="end_date" class="form-control" value="<?php echo e($endDate); ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Department</label>
                    <select name="department" class="form-select">
                        <option value="">All Departments</option>
                        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($dept->id); ?>" <?php echo e($department == $dept->id ? 'selected' : ''); ?>>
                                <?php echo e($dept->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Job Posting</label>
                    <select name="job_posting" class="form-select">
                        <option value="">All Job Postings</option>
                        <?php $__currentLoopData = $jobPostings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($job->id); ?>" <?php echo e($jobPosting == $job->id ? 'selected' : ''); ?>>
                                <?php echo e($job->title); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-12 mt-3">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-funnel"></i> Apply Filters
                    </button>
                    <a href="<?php echo e(route('recruitment.reports.export')); ?>?<?php echo e(http_build_query(request()->all())); ?>&format=csv" class="btn btn-success">
                        <i class="bi bi-download"></i> Export Filtered Data
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Summary Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <h3 class="mb-0 text-primary"><?php echo e($summary['total_applications']); ?></h3>
                    <small class="text-muted">Total Applications</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <h3 class="mb-0 text-success"><?php echo e($summary['status_breakdown']['offered'] ?? 0); ?></h3>
                    <small class="text-muted">Offers Extended</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <h3 class="mb-0 text-warning"><?php echo e($summary['avg_processing_time']); ?></h3>
                    <small class="text-muted">Avg. Processing Time (days)</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <h3 class="mb-0 text-info">
                        <?php echo e($summary['total_applications'] > 0 ? round((($summary['status_breakdown']['offered'] ?? 0) / $summary['total_applications']) * 100, 1) : 0); ?>%
                    </h3>
                    <small class="text-muted">Success Rate</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Applications Table -->
    <div class="card shadow-sm">
        <div class="card-header bg-white">
            <h5 class="mb-0">Applications (<?php echo e($applications->total()); ?> total)</h5>
        </div>
        <div class="card-body">
            <?php if($applications->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Application ID</th>
                                <th>Applicant</th>
                                <th>Contact</th>
                                <th>Position</th>
                                <th>Department</th>
                                <th>Status</th>
                                <th>Applied Date</th>
                                <th>Last Updated</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <code><?php echo e($application->tracking_token); ?></code>
                                    </td>
                                    <td>
                                        <strong><?php echo e($application->full_name); ?></strong>
                                    </td>
                                    <td>
                                        <div><?php echo e($application->email); ?></div>
                                        <small class="text-muted"><?php echo e($application->phone); ?></small>
                                    </td>
                                    <td><?php echo e($application->jobPosting->title); ?></td>
                                    <td><?php echo e($application->jobPosting->department->name ?? 'N/A'); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($application->status === 'new' ? 'primary' : 
                                            ($application->status === 'screening' ? 'warning' : 
                                            ($application->status === 'shortlisted' ? 'info' : 
                                            ($application->status === 'interviewed' ? 'secondary' : 
                                            ($application->status === 'offered' ? 'success' : 'danger'))))); ?>">
                                            <?php echo e(ucfirst($application->status)); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($application->applied_at->format('M d, Y')); ?></td>
                                    <td><?php echo e($application->updated_at->format('M d, Y')); ?></td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <?php if($application->cv_path): ?>
                                                <a href="<?php echo e(route('applications.cv.view', $application)); ?>" 
                                                   class="btn btn-outline-primary" target="_blank" title="View CV">
                                                    <i class="bi bi-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('applications.cv.download', $application)); ?>" 
                                                   class="btn btn-outline-success" title="Download CV">
                                                    <i class="bi bi-download"></i>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    <?php echo e($applications->appends(request()->query())->links()); ?>

                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="bi bi-inbox fs-1 text-muted"></i>
                    <h5 class="text-muted mt-2">No applications found</h5>
                    <p class="text-muted">Try adjusting your filters to see more results.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Auto-submit form when department changes to update job postings
    document.querySelector('select[name="department"]').addEventListener('change', function() {
        // You could add AJAX here to update job postings dropdown
        // For now, we'll just submit the form
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/recruitment/reports/detailed.blade.php ENDPATH**/ ?>