<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Track Your Application - <?php echo e($application->jobPosting->organization->name); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                
                <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle"></i> <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle"></i> <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php endif; ?>

                <!-- Header Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <h2 class="mb-1"><?php echo e($application->full_name); ?></h2>
                                <p class="text-muted mb-0"><i class="bi bi-envelope"></i> <?php echo e($application->email); ?></p>
                            </div>
                            <div class="col-md-4 text-md-end mt-3 mt-md-0">
                                <span class="badge 
                                    <?php if($application->status === 'new'): ?> bg-primary
                                    <?php elseif($application->status === 'screening'): ?> bg-warning
                                    <?php elseif($application->status === 'shortlisted'): ?> bg-info
                                    <?php elseif($application->status === 'interviewed'): ?> bg-secondary
                                    <?php elseif($application->status === 'offered'): ?> bg-success
                                    <?php elseif($application->status === 'rejected'): ?> bg-danger
                                    <?php elseif($application->status === 'withdrawn'): ?> bg-secondary
                                    <?php else: ?> bg-secondary
                                    <?php endif; ?> fs-6 px-3 py-2">
                                    <?php echo e(ucfirst($application->status)); ?>

                                </span>
                                <p class="text-muted small mt-2 mb-0">
                                    Applied <?php echo e($application->applied_at->diffForHumans()); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Job Details Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-briefcase"></i> Position Applied For</h5>
                    </div>
                    <div class="card-body">
                        <h4 class="text-primary mb-2"><?php echo e($application->jobPosting->title); ?></h4>
                        <p class="text-muted mb-3"><?php echo e($application->jobPosting->organization->name); ?></p>
                        
                        <div class="row text-muted">
                            <?php if($application->jobPosting->department): ?>
                            <div class="col-md-4 mb-2">
                                <i class="bi bi-building"></i> <?php echo e($application->jobPosting->department->name); ?>

                            </div>
                            <?php endif; ?>
                            <div class="col-md-4 mb-2">
                                <i class="bi bi-geo-alt"></i> <?php echo e($application->jobPosting->location); ?>

                            </div>
                            <div class="col-md-4 mb-2">
                                <i class="bi bi-clock"></i> <?php echo e(ucfirst($application->jobPosting->employment_type)); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <!-- Next Steps Alert -->
                <div class="alert alert-info" role="alert">
                    <h5 class="alert-heading"><i class="bi bi-info-circle"></i> What's Next?</h5>
                    <p class="mb-0"><?php echo e($application->next_steps); ?></p>
                </div>

                <!-- Progress Tracker Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-graph-up"></i> Application Progress</h5>
                    </div>
                    <div class="card-body">
                        <?php
                            $steps = [
                                'new' => ['title' => 'Application Submitted', 'desc' => 'Your application has been received', 'icon' => 'check-circle'],
                                'screening' => ['title' => 'Under Review', 'desc' => 'Our team is reviewing your application', 'icon' => 'eye'],
                                'shortlisted' => ['title' => 'Shortlisted', 'desc' => 'You have been selected for interview', 'icon' => 'star'],
                                'interviewed' => ['title' => 'Interview Completed', 'desc' => 'Making final decision', 'icon' => 'people'],
                                'offered' => ['title' => 'Offer Extended', 'desc' => 'Congratulations!', 'icon' => 'trophy'],
                            ];
                            
                            $statusOrder = ['new', 'screening', 'shortlisted', 'interviewed', 'offered'];
                            $currentIndex = array_search($application->status, $statusOrder);
                            if ($currentIndex === false) $currentIndex = 0;
                        ?>
                        
                        <div class="position-relative">
                            <?php $__currentLoopData = $steps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status => $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $stepIndex = array_search($status, $statusOrder);
                                    $isCompleted = $stepIndex <= $currentIndex;
                                    $isCurrent = $status === $application->status;
                                ?>
                                
                                <div class="d-flex align-items-start mb-4 position-relative">
                                    <div class="flex-shrink-0">
                                        <div class="rounded-circle d-flex align-items-center justify-content-center 
                                            <?php if($isCompleted): ?> bg-success text-white <?php else: ?> bg-secondary text-white <?php endif; ?>"
                                            style="width: 40px; height: 40px;">
                                            <?php if($isCompleted): ?>
                                                <i class="bi bi-check-lg fs-5"></i>
                                            <?php else: ?>
                                                <i class="bi bi-circle fs-6"></i>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <h6 class="mb-1 <?php if($isCompleted): ?> text-dark <?php else: ?> text-muted <?php endif; ?>">
                                            <?php echo e($step['title']); ?>

                                        </h6>
                                        <p class="mb-1 small <?php if($isCompleted): ?> text-secondary <?php else: ?> text-muted <?php endif; ?>">
                                            <?php echo e($step['desc']); ?>

                                        </p>
                                        <?php if($isCurrent): ?>
                                        <span class="badge bg-primary">Current Stage</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

                <!-- Interviews Section -->
                <?php if($application->interviews->count() > 0): ?>
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0"><i class="bi bi-calendar-event"></i> Scheduled Interviews</h5>
                    </div>
                    <div class="card-body">
                        <?php $__currentLoopData = $application->interviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $interview): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="border rounded p-3 mb-3">
                            <div class="d-flex justify-content-between align-items-start flex-wrap">
                                <div class="mb-2">
                                    <h6 class="mb-1">Interview with <?php echo e($interview->interviewer->name); ?></h6>
                                    <p class="text-muted small mb-1">
                                        <i class="bi bi-calendar"></i> <?php echo e($interview->scheduled_at->format('l, F j, Y \a\t g:i A')); ?>

                                    </p>
                                    <?php if($interview->location): ?>
                                    <p class="text-muted small mb-1">
                                        <i class="bi bi-geo-alt"></i> <?php echo e($interview->location); ?>

                                    </p>
                                    <?php endif; ?>
                                    <?php if($interview->meeting_link): ?>
                                    <a href="<?php echo e($interview->meeting_link); ?>" target="_blank" class="btn btn-sm btn-primary mt-2">
                                        <i class="bi bi-camera-video"></i> Join Virtual Meeting
                                    </a>
                                    <?php endif; ?>
                                </div>
                                <span class="badge 
                                    <?php if($interview->status === 'scheduled'): ?> bg-primary
                                    <?php elseif($interview->status === 'completed'): ?> bg-success
                                    <?php else: ?> bg-secondary
                                    <?php endif; ?>">
                                    <?php echo e(ucfirst($interview->status)); ?>

                                </span>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Job Offer Section -->
                <?php if($application->jobOffer && $application->jobOffer->status !== 'draft'): ?>
                <div class="card shadow-sm mb-4 border-success">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0"><i class="bi bi-trophy"></i> Job Offer</h5>
                    </div>
                    <div class="card-body">
                        <?php if($application->jobOffer->status === 'sent'): ?>
                        <div class="alert alert-success mb-3">
                            <h5 class="alert-heading"><i class="bi bi-check-circle"></i> Congratulations!</h5>
                            <p class="mb-0">You have received a job offer for the position of <strong><?php echo e($application->jobOffer->position_title); ?></strong>.</p>
                        </div>
                        
                        <div class="mb-3">
                            <h6>Offer Details:</h6>
                            <ul class="list-unstyled">
                                <li><strong>Position:</strong> <?php echo e($application->jobOffer->position_title); ?></li>
                                <li><strong>Salary:</strong> $<?php echo e(number_format($application->jobOffer->salary, 2)); ?> per <?php echo e($application->jobOffer->salary_period); ?></li>
                                <li><strong>Start Date:</strong> <?php echo e($application->jobOffer->start_date->format('F j, Y')); ?></li>
                                <?php if($application->jobOffer->expires_at): ?>
                                <li><strong>Offer Valid Until:</strong> <?php echo e($application->jobOffer->expires_at->format('F j, Y')); ?></li>
                                <?php endif; ?>
                            </ul>
                        </div>

                        <div class="d-flex gap-2 flex-wrap">
                            <a href="<?php echo e(route('offer.view', $application->jobOffer->offer_token)); ?>" 
                               class="btn btn-success btn-lg">
                                <i class="bi bi-eye"></i> View Full Offer
                            </a>
                            <a href="<?php echo e(route('offer.accept', $application->jobOffer->offer_token)); ?>" 
                               class="btn btn-primary btn-lg">
                                <i class="bi bi-check-circle"></i> Accept Offer
                            </a>
                            <a href="<?php echo e(route('offer.decline', $application->jobOffer->offer_token)); ?>" 
                               class="btn btn-outline-danger btn-lg">
                                <i class="bi bi-x-circle"></i> Decline Offer
                            </a>
                        </div>
                        <?php elseif($application->jobOffer->status === 'accepted'): ?>
                        <div class="alert alert-success">
                            <h5 class="alert-heading"><i class="bi bi-check-circle"></i> Offer Accepted</h5>
                            <p class="mb-0">You accepted this offer on <?php echo e($application->jobOffer->responded_at->format('F j, Y')); ?>.</p>
                            <p class="mb-0 mt-2">Your start date is <strong><?php echo e($application->jobOffer->start_date->format('F j, Y')); ?></strong>.</p>
                        </div>
                        <a href="<?php echo e(route('offer.view', $application->jobOffer->offer_token)); ?>" 
                           class="btn btn-outline-primary">
                            <i class="bi bi-eye"></i> View Offer Details
                        </a>
                        <?php elseif($application->jobOffer->status === 'declined'): ?>
                        <div class="alert alert-secondary">
                            <h5 class="alert-heading"><i class="bi bi-info-circle"></i> Offer Declined</h5>
                            <p class="mb-0">You declined this offer on <?php echo e($application->jobOffer->responded_at->format('F j, Y')); ?>.</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Application Details Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-file-text"></i> Your Application</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Contact Information</label>
                            <p class="mb-0"><i class="bi bi-phone"></i> <?php echo e($application->phone); ?></p>
                        </div>
                        
                        <?php if($application->cover_letter): ?>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Cover Letter</label>
                            <p class="text-muted" style="white-space: pre-line;"><?php echo e($application->cover_letter); ?></p>
                        </div>
                        <?php endif; ?>
                        
                        <div class="mb-0">
                            <label class="form-label fw-bold">Resume/CV</label>
                            <div class="mt-2">
                                <a href="<?php echo e(route('candidate.cv.download', $application->tracking_token)); ?>" 
                                   class="btn btn-outline-primary">
                                    <i class="bi bi-download"></i> Download CV
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Actions Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-gear"></i> Actions</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex flex-wrap gap-2">
                            <a href="<?php echo e(route('candidate.messages', $application->tracking_token)); ?>" 
                               class="btn btn-primary">
                                <i class="bi bi-chat-dots"></i> Messages
                                <?php if($application->messages()->where('sender_type', 'hr')->where('read_by_candidate', false)->count() > 0): ?>
                                <span class="badge bg-danger"><?php echo e($application->messages()->where('sender_type', 'hr')->where('read_by_candidate', false)->count()); ?></span>
                                <?php endif; ?>
                            </a>
                            
                            <?php if($application->canBeUpdated()): ?>
                            <a href="<?php echo e(route('candidate.edit', $application->tracking_token)); ?>" 
                               class="btn btn-outline-primary">
                                <i class="bi bi-pencil"></i> Update Application
                            </a>
                            <?php endif; ?>
                            
                            <a href="<?php echo e(route('candidate.timeline', $application->tracking_token)); ?>" 
                               class="btn btn-outline-secondary">
                                <i class="bi bi-clock-history"></i> View Timeline
                            </a>
                            
                            <?php if($application->canBeWithdrawn()): ?>
                            <a href="<?php echo e(route('candidate.withdraw', $application->tracking_token)); ?>" 
                               class="btn btn-outline-danger">
                                <i class="bi bi-x-circle"></i> Withdraw Application
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Help Section -->
                <div class="text-center text-muted">
                    <p class="mb-1">Questions about your application?</p>
                    <?php
                        $contactEmail = $application->jobPosting->organization->getSetting('contact_email') 
                                     ?? $application->jobPosting->organization->getSetting('hr_email')
                                     ?? 'hr@' . str_replace(' ', '', strtolower($application->jobPosting->organization->name)) . '.com';
                        $website = $application->jobPosting->organization->getSetting('company_website') 
                                ?? $application->jobPosting->organization->getSetting('website')
                                ?? '#';
                    ?>
                    <p>Contact us at <a href="mailto:<?php echo e($contactEmail); ?>" class="text-primary"><?php echo e($contactEmail); ?></a></p>
                    <?php if($website !== '#'): ?>
                    <p><a href="<?php echo e($website); ?>" target="_blank" class="text-primary"><i class="bi bi-globe"></i> Visit Our Website</a></p>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/candidate/portal/dashboard.blade.php ENDPATH**/ ?>