<?php $__env->startSection('title', $title ?? 'Access Denied'); ?>
<?php $__env->startSection('code', '403'); ?>

<?php $__env->startSection('content'); ?>
    <div class="error-icon text-danger">
        <i class="bi bi-shield-x"></i>
    </div>
    
    <p class="error-message">
        <?php echo e($message ?? "You don't have the necessary permissions to access this resource. This area is restricted to authorized personnel only."); ?>

    </p>

    <div class="error-details">
        <h6><i class="bi bi-exclamation-triangle me-2"></i>Why am I seeing this?</h6>
        <p>Your current role doesn't include the permissions needed for this action. If you believe this is an error, please contact your administrator or HR department.</p>
    </div>

    <div class="error-actions">
        <?php if(auth()->guard()->check()): ?>
            <a href="<?php echo e(route('dashboard')); ?>" class="btn-primary-custom">
                <i class="bi bi-house"></i>
                Return to Dashboard
            </a>
            
            <a href="javascript:history.back()" class="btn-secondary-custom">
                <i class="bi bi-arrow-left"></i>
                Go Back
            </a>
            
            <?php if(auth()->user()->canManageRoles() || auth()->user()->hasRole(['org_admin', 'hr_manager'])): ?>
                <a href="<?php echo e(route('roles.index')); ?>" class="btn-success-custom">
                    <i class="bi bi-shield-check"></i>
                    Manage Permissions
                </a>
            <?php else: ?>
                <a href="mailto:admin@qayahrms.com" class="btn-success-custom">
                    <i class="bi bi-person-gear"></i>
                    Request Access
                </a>
            <?php endif; ?>
        <?php else: ?>
            <a href="<?php echo e(route('login')); ?>" class="btn-primary-custom">
                <i class="bi bi-box-arrow-in-right"></i>
                Login
            </a>
        <?php endif; ?>
    </div>

    <?php if(auth()->guard()->check()): ?>
    <div class="mt-4">
        <small class="text-muted">
            <i class="bi bi-person-badge me-1"></i>
            <strong>Your Role:</strong> 
            <?php if(auth()->user()->roles->isNotEmpty()): ?>
                <?php echo e(ucfirst(auth()->user()->roles->first()->name)); ?>

            <?php else: ?>
                No role assigned
            <?php endif; ?>
        </small>
    </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('errors.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/errors/403.blade.php ENDPATH**/ ?>