<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Interview Invitation</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .email-wrapper {
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
        }
        .header {
            background-color: #4F46E5;
            color: #ffffff;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .content {
            padding: 30px 20px;
        }
        .info-box {
            background-color: #F3F4F6;
            border-left: 4px solid #4F46E5;
            padding: 15px;
            margin: 20px 0;
        }
        .credentials-box {
            background-color: #FEF3C7;
            border: 2px solid #F59E0B;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .credential-item {
            margin: 10px 0;
        }
        .credential-label {
            font-weight: bold;
            color: #4F46E5;
        }
        .warning {
            background-color: #FEE2E2;
            border-left: 4px solid #DC2626;
            padding: 15px;
            margin: 20px 0;
        }
        .button {
            display: inline-block;
            background-color: #4F46E5;
            color: #ffffff;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 4px;
            margin: 20px 0;
        }
        .footer {
            background-color: #F9FAFB;
            padding: 20px;
            text-align: center;
            color: #6B7280;
            font-size: 14px;
        }
        ul {
            margin: 10px 0;
            padding-left: 20px;
        }
        li {
            margin: 8px 0;
        }
    </style>
</head>
<body>
    <div class="email-wrapper">
        <div class="header">
            <h1>Interview Invitation</h1>
        </div>

        <div class="content">
            <h2>Hello <?php echo e($interview->application->full_name); ?>,</h2>
            
            <p>Congratulations! We would like to invite you for an interview for the <strong><?php echo e($interview->application->jobPosting->title); ?></strong> position.</p>

            <div class="info-box">
                <h3 style="margin-top: 0;">Interview Details</h3>
                <p>
                    <strong>Date & Time:</strong> <?php echo e($interview->scheduled_at->format('l, F j, Y \a\t g:i A')); ?><br>
                    <?php if($interview->location): ?>
                    <strong>Location:</strong> <?php echo e($interview->location); ?><br>
                    <?php endif; ?>
                    <?php if($interview->meeting_link): ?>
                    <strong>Meeting Link:</strong> <a href="<?php echo e($interview->meeting_link); ?>"><?php echo e($interview->meeting_link); ?></a><br>
                    <?php endif; ?>
                    <strong>Interviewer:</strong> <?php echo e($interview->interviewer->name); ?>

                </p>
            </div>

            <div style="text-align: center;">
                <a href="<?php echo e($confirmUrl); ?>" class="button">Confirm Attendance</a>
            </div>

            <p>Please confirm your attendance by clicking the button above. If you're unable to attend, please let us know as soon as possible.</p>

            <p>We look forward to meeting you!</p>

            <p>Best regards,<br>
            <strong><?php echo e($interview->application->jobPosting->organization->name); ?> HR Team</strong></p>
        </div>

        <div class="footer">
            <p>This is an automated message from <?php echo e($interview->application->jobPosting->organization->name); ?>.<br>
            Please do not reply to this email.</p>
        </div>
    </div>
</body>
</html><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/emails/interview-invitation.blade.php ENDPATH**/ ?>