<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Qaya HRM - Transform Your HR Operations</title>
    <meta name="description" content="Modern HR management platform for Kenyan businesses. Streamline payroll, recruitment, and compliance with our all-in-one solution.">
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:300,400,500,600,700,800|space-grotesk:600,700" rel="stylesheet" />
    
    <!-- AOS Animation Library -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    
    <!-- Custom Styles -->
    
    <link rel="stylesheet" href="/assets/css/landing.css">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <!-- Floating Background Elements -->
    <div class="bg-elements">
        <div class="floating-shape shape-1"></div>
        <div class="floating-shape shape-2"></div>
        <div class="floating-shape shape-3"></div>
        <div class="floating-shape shape-4"></div>
    </div>

    <!-- Navigation -->
    <nav class="navbar" id="navbar">
        <div class="container">
            <div class="nav-wrapper">
                <a href="#" class="logo">
                    <div class="logo-icon">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M16 2L28 9V23L16 30L4 23V9L16 2Z" fill="url(#logo-gradient)" stroke="white" stroke-width="2"/>
                            <defs>
                                <linearGradient id="logo-gradient" x1="4" y1="2" x2="28" y2="30">
                                    <stop offset="0%" style="stop-color:#FF6B35"/>
                                    <stop offset="100%" style="stop-color:#F7931E"/>
                                </linearGradient>
                            </defs>
                        </svg>
                    </div>
                    <span class="logo-text">Qaya<span class="logo-hrm">HRM</span></span>
                </a>
                
                <div class="nav-menu" id="navMenu">
                    <a href="#features" class="nav-link">Features</a>
                    <a href="#compliance" class="nav-link">Compliance</a>
                    <a href="#pricing" class="nav-link">Pricing</a>
                    <a href="#testimonials" class="nav-link">Testimonials</a>
                </div>
                
                <div class="nav-actions">
                    <?php if(Route::has('login')): ?>
                        <?php if(auth()->guard()->check()): ?>
                            <a href="<?php echo e(url('/dashboard')); ?>" class="btn btn-outline">Dashboard</a>
                        <?php else: ?>
                            <a href="<?php echo e(route('login')); ?>" class="btn btn-outline">Sign In</a>
                            <a href="<?php echo e(route('login')); ?>" class="btn btn-primary">
                                Get Started
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                                    <path d="M6 3L11 8L6 13" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                    <button class="mobile-toggle" id="mobileToggle">
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>
                </div>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <div class="hero-content">
                <div class="hero-text" data-aos="fade-up">
                    <div class="badge">
                        <span class="badge-icon">🇰🇪</span>
                        <span>Built for East Africa • Production Ready</span>
                    </div>
                    <h1 class="hero-title">
                        Modern HR Management
                        <span class="gradient-text">Built for Kenya</span>
                    </h1>
                    <p class="hero-description">
                        Complete HR solution with 14 integrated modules. From employee onboarding to payroll processing, 
                        performance reviews to recruitment - everything you need in one secure, cloud-based platform.
                    </p>
                    <div class="hero-features">
                        <div class="hero-feature">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <path d="M16.6 5L7.5 14.1L3.4 10" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>14-day free trial</span>
                        </div>
                        <div class="hero-feature">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <path d="M16.6 5L7.5 14.1L3.4 10" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>M-Pesa payments</span>
                        </div>
                        <div class="hero-feature">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <path d="M16.6 5L7.5 14.1L3.4 10" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>100% KRA compliant</span>
                        </div>
                    </div>
                    <div class="hero-cta">
                        <a href="<?php echo e(route('login')); ?>" class="btn btn-primary btn-large">
                            Start Free Trial
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <path d="M7 4L13 10L7 16" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                        </a>
                        <a href="#demo" class="btn btn-glass">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="8" stroke="currentColor" stroke-width="2"/>
                                <path d="M8 7L13 10L8 13V7Z" fill="currentColor"/>
                            </svg>
                            Watch Demo
                        </a>
                    </div>
                </div>
                
                <div class="hero-visual" data-aos="fade-left" data-aos-delay="200">
                    <div class="stats-grid">
                        <div class="stat-card stat-orange" data-aos="zoom-in" data-aos-delay="400">
                            <div class="stat-icon">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <path d="M17 21V19C17 16.7909 15.2091 15 13 15H5C2.79086 15 1 16.7909 1 19V21" stroke="white" stroke-width="2"/>
                                    <circle cx="9" cy="7" r="4" stroke="white" stroke-width="2"/>
                                    <path d="M23 21V19C23 17.1362 21.7252 15.5701 20 15.126" stroke="white" stroke-width="2"/>
                                    <path d="M16 3.12598C17.7252 3.57006 19 5.13616 19 7C19 8.86384 17.7252 10.4299 16 10.874" stroke="white" stroke-width="2"/>
                                </svg>
                            </div>
                            <div class="stat-number">500+</div>
                            <div class="stat-label">Companies Trust Us</div>
                        </div>
                        
                        <div class="stat-card stat-green" data-aos="zoom-in" data-aos-delay="500">
                            <div class="stat-icon">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" stroke="white" stroke-width="2"/>
                                    <path d="M9 12L11 14L15 10" stroke="white" stroke-width="2" stroke-linecap="round"/>
                                </svg>
                            </div>
                            <div class="stat-number">50K+</div>
                            <div class="stat-label">Employees Managed</div>
                        </div>
                        
                        <div class="stat-card stat-blue" data-aos="zoom-in" data-aos-delay="600">
                            <div class="stat-icon">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <rect x="3" y="4" width="18" height="16" rx="2" stroke="white" stroke-width="2"/>
                                    <path d="M3 10H21" stroke="white" stroke-width="2"/>
                                    <path d="M7 15H9" stroke="white" stroke-width="2" stroke-linecap="round"/>
                                </svg>
                            </div>
                            <div class="stat-number">100%</div>
                            <div class="stat-label">KRA Compliant</div>
                        </div>
                        
                        <div class="stat-card stat-purple" data-aos="zoom-in" data-aos-delay="700">
                            <div class="stat-icon">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <path d="M13 2L3 14H12L11 22L21 10H12L13 2Z" stroke="white" stroke-width="2" stroke-linejoin="round"/>
                                </svg>
                            </div>
                            <div class="stat-number">99.9%</div>
                            <div class="stat-label">Uptime SLA</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Scroll Indicator -->
        <div class="scroll-indicator" data-aos="fade-up" data-aos-delay="1000">
            <div class="scroll-mouse">
                <div class="scroll-wheel"></div>
            </div>
            <span>Scroll to explore</span>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="features">
        <div class="container">
            <div class="section-header" data-aos="fade-up">
                <div class="section-badge">Features</div>
                <h2 class="section-title">Everything You Need, <span class="gradient-text">All In One Place</span></h2>
                <p class="section-description">
                    14 comprehensive HR modules designed for the Kenyan market, backed by world-class technology
                </p>
            </div>
            
            <div class="features-grid">
                <div class="feature-card" data-aos="fade-up" data-aos-delay="100">
                    <div class="feature-icon gradient-orange">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M16 20C20.4183 20 24 16.4183 24 12C24 7.58172 20.4183 4 16 4C11.5817 4 8 7.58172 8 12C8 16.4183 11.5817 20 16 20Z" stroke="white" stroke-width="2"/>
                            <path d="M4 28C4 23.5817 7.58172 20 12 20H20C24.4183 20 28 23.5817 28 28" stroke="white" stroke-width="2"/>
                        </svg>
                    </div>
                    <h3 class="feature-title">Employee Management</h3>
                    <p class="feature-description">
                        Complete employee lifecycle from onboarding to exit. Manage profiles, departments, positions, contracts, and organizational hierarchy with bulk import/export.
                    </p>
                    <a href="#" class="feature-link">
                        Learn more
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M6 3L11 8L6 13" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </a>
                </div>
                
                <div class="feature-card" data-aos="fade-up" data-aos-delay="200">
                    <div class="feature-icon gradient-green">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <rect x="4" y="8" width="24" height="16" rx="2" stroke="white" stroke-width="2"/>
                            <path d="M4 14H28M10 18H14M10 22H18" stroke="white" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </div>
                    <h3 class="feature-title">Payroll & Compliance</h3>
                    <p class="feature-description">
                        Automated KRA-compliant payroll with PAYE, NSSF, NHIF, Housing Levy, and HELB. Generate P9 forms, payslips, and statutory reports instantly.
                    </p>
                    <a href="#" class="feature-link">
                        Learn more
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M6 3L11 8L6 13" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </a>
                </div>
                
                <div class="feature-card" data-aos="fade-up" data-aos-delay="300">
                    <div class="feature-icon gradient-blue">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M28 16C28 22.6274 22.6274 28 16 28C9.37258 28 4 22.6274 4 16C4 9.37258 9.37258 4 16 4" stroke="white" stroke-width="2"/>
                            <path d="M16 8V16L22 22" stroke="white" stroke-width="2" stroke-linecap="round"/>
                            <circle cx="24" cy="8" r="4" fill="#3B82F6"/>
                        </svg>
                    </div>
                    <h3 class="feature-title">Attendance & Time Tracking</h3>
                    <p class="feature-description">
                        Flexible attendance tracking with clock in/out, shift management, overtime calculation, and configurable attendance rules for your organization.
                    </p>
                    <a href="#" class="feature-link">
                        Learn more
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M6 3L11 8L6 13" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </a>
                </div>
                
                <div class="feature-card" data-aos="fade-up" data-aos-delay="100">
                    <div class="feature-icon gradient-pink">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <rect x="6" y="6" width="20" height="20" rx="2" stroke="white" stroke-width="2"/>
                            <path d="M12 6V4M20 6V4M6 12H26" stroke="white" stroke-width="2" stroke-linecap="round"/>
                            <path d="M12 18H14M12 22H14M18 18H20M18 22H20" stroke="white" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </div>
                    <h3 class="feature-title">Leave Management</h3>
                    <p class="feature-description">
                        Kenyan law-compliant leave management with annual, sick, maternity, paternity leave. Automated accruals, approval workflows, and FullCalendar integration.
                    </p>
                    <a href="#" class="feature-link">
                        Learn more
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M6 3L11 8L6 13" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </a>
                </div>
                
                <div class="feature-card" data-aos="fade-up" data-aos-delay="200">
                    <div class="feature-icon gradient-purple">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M16 4L20 12L28 14L22 20L24 28L16 24L8 28L10 20L4 14L12 12L16 4Z" stroke="white" stroke-width="2"/>
                        </svg>
                    </div>
                    <h3 class="feature-title">Performance Management</h3>
                    <p class="feature-description">
                        360-degree feedback, goal setting, KPIs, performance reviews, appraisals, and succession planning to develop and retain your top talent.
                    </p>
                    <a href="#" class="feature-link">
                        Learn more
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M6 3L11 8L6 13" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </a>
                </div>
                
                <div class="feature-card" data-aos="fade-up" data-aos-delay="300">
                    <div class="feature-icon gradient-teal">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M28 10V24C28 25.1046 27.1046 26 26 26H6C4.89543 26 4 25.1046 4 24V10" stroke="white" stroke-width="2"/>
                            <path d="M22 14L16 20L10 14" stroke="white" stroke-width="2" stroke-linecap="round"/>
                            <rect x="8" y="4" width="16" height="8" rx="1" stroke="white" stroke-width="2"/>
                        </svg>
                    </div>
                    <h3 class="feature-title">Training & Development</h3>
                    <p class="feature-description">
                        Training program management, skills tracking, certification management, course scheduling, and e-learning integration for continuous employee growth.
                    </p>
                    <a href="#" class="feature-link">
                        Learn more
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M6 3L11 8L6 13" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </a>
                </div>

                <div class="feature-card" data-aos="fade-up" data-aos-delay="100">
                    <div class="feature-icon gradient-blue">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M12 4H6C4.89543 4 4 4.89543 4 6V26C4 27.1046 4.89543 28 6 28H26C27.1046 28 28 27.1046 28 26V6C28 4.89543 27.1046 4 26 4H20" stroke="white" stroke-width="2"/>
                            <rect x="12" y="2" width="8" height="4" rx="1" stroke="white" stroke-width="2"/>
                            <path d="M10 14H22M10 20H22" stroke="white" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </div>
                    <h3 class="feature-title">Recruitment & ATS</h3>
                    <p class="feature-description">
                        Full applicant tracking system with job posting, candidate pipeline, interview scheduling, collaborative hiring, and offer management.
                    </p>
                    <a href="#" class="feature-link">
                        Learn more
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M6 3L11 8L6 13" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </a>
                </div>

                <div class="feature-card" data-aos="fade-up" data-aos-delay="200">
                    <div class="feature-icon gradient-orange">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <rect x="4" y="8" width="10" height="16" rx="1" stroke="white" stroke-width="2"/>
                            <rect x="18" y="8" width="10" height="16" rx="1" stroke="white" stroke-width="2"/>
                            <path d="M9 14H9.01M23 14H23.01M9 18H9.01M23 18H23.01" stroke="white" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </div>
                    <h3 class="feature-title">Loans Management</h3>
                    <p class="feature-description">
                        Employee loan management with application workflows, approval processes, automatic payroll deductions, and repayment tracking.
                    </p>
                    <a href="#" class="feature-link">
                        Learn more
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M6 3L11 8L6 13" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </a>
                </div>

                <div class="feature-card" data-aos="fade-up" data-aos-delay="300">
                    <div class="feature-icon gradient-green">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M16 28C22.6274 28 28 22.6274 28 16C28 9.37258 22.6274 4 16 4C9.37258 4 4 9.37258 4 16C4 22.6274 9.37258 28 16 28Z" stroke="white" stroke-width="2"/>
                            <path d="M16 10V16L20 20" stroke="white" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </div>
                    <h3 class="feature-title">Reports & Analytics</h3>
                    <p class="feature-description">
                        Comprehensive reporting with PDF and Excel exports. Payroll reports, attendance summaries, leave analytics, and custom report builder.
                    </p>
                    <a href="#" class="feature-link">
                        Learn more
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M6 3L11 8L6 13" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Compliance Section -->
    <section id="compliance" class="compliance">
        <div class="container">
            <div class="compliance-content">
                <div class="compliance-text" data-aos="fade-right">
                    <div class="section-badge badge-light">
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M14 5L6 13L2 9" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                        100% KRA Compliant
                    </div>
                    <h2 class="section-title text-white">
                        Stay Compliant With <span class="gradient-text">Kenyan Law</span>
                    </h2>
                    <p class="section-description text-light">
                        Built specifically for the Kenyan market with full statutory compliance. 
                        Automatic calculations for PAYE, NSSF, NHIF, Housing Levy (1.5%), and HELB deductions. 
                        Generate P9 forms and statutory reports with one click.
                    </p>
                    
                    <div class="compliance-features">
                        <div class="compliance-feature" data-aos="fade-up" data-aos-delay="100">
                            <div class="compliance-icon">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <circle cx="12" cy="12" r="10" stroke="#22C55E" stroke-width="2"/>
                                    <path d="M8 12L11 15L16 9" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                                </svg>
                            </div>
                            <div>
                                <h4>PAYE Tax Calculation</h4>
                                <p>Automatic KRA-compliant tax calculations with latest rates</p>
                            </div>
                        </div>
                        
                        <div class="compliance-feature" data-aos="fade-up" data-aos-delay="200">
                            <div class="compliance-icon">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <circle cx="12" cy="12" r="10" stroke="#22C55E" stroke-width="2"/>
                                    <path d="M8 12L11 15L16 9" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                                </svg>
                            </div>
                            <div>
                                <h4>NSSF & NHIF</h4>
                                <p>Automated statutory deductions and monthly reporting</p>
                            </div>
                        </div>
                        
                        <div class="compliance-feature" data-aos="fade-up" data-aos-delay="300">
                            <div class="compliance-icon">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <circle cx="12" cy="12" r="10" stroke="#22C55E" stroke-width="2"/>
                                    <path d="M8 12L11 15L16 9" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                                </svg>
                            </div>
                            <div>
                                <h4>Housing Levy & HELB</h4>
                                <p>1.5% housing levy and HELB deductions automatically calculated</p>
                            </div>
                        </div>
                        
                        <div class="compliance-feature" data-aos="fade-up" data-aos-delay="400">
                            <div class="compliance-icon">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <circle cx="12" cy="12" r="10" stroke="#22C55E" stroke-width="2"/>
                                    <path d="M8 12L11 15L16 9" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                                </svg>
                            </div>
                            <div>
                                <h4>P9 Form Generation</h4>
                                <p>One-click P9 form generation for all employees with PDF export</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="compliance-visual" data-aos="fade-left">
                    <div class="compliance-card">
                        <div class="compliance-card-header">
                            <div class="compliance-card-icon">
                                <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                                    <path d="M6 8H26M6 16H26M6 24H18" stroke="#FF6B35" stroke-width="2" stroke-linecap="round"/>
                                </svg>
                            </div>
                            <div>
                                <h4>Statutory Reports</h4>
                                <p>Auto-generated & compliant</p>
                            </div>
                        </div>
                        <div class="compliance-stats">
                            <div class="compliance-stat">
                                <div class="stat-value">100%</div>
                                <div class="stat-label">Accuracy</div>
                            </div>
                            <div class="compliance-stat">
                                <div class="stat-value">< 1min</div>
                                <div class="stat-label">Generation Time</div>
                            </div>
                            <div class="compliance-stat">
                                <div class="stat-value">KRA</div>
                                <div class="stat-label">Approved</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Technology & Security Section -->
    <section class="features" style="background: #f8fafc;">
        <div class="container">
            <div class="section-header" data-aos="fade-up">
                <div class="section-badge">Technology & Security</div>
                <h2 class="section-title">Enterprise-Grade <span class="gradient-text">Security & Performance</span></h2>
                <p class="section-description">
                    Built on Laravel 12 with modern architecture, multi-tenancy, and bank-level security
                </p>
            </div>
            
            <div class="features-grid">
                <div class="feature-card" data-aos="fade-up" data-aos-delay="100">
                    <div class="feature-icon gradient-blue">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M16 4L4 10V16C4 23 16 28 16 28C16 28 28 23 28 16V10L16 4Z" stroke="white" stroke-width="2"/>
                            <path d="M12 16L15 19L20 13" stroke="white" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </div>
                    <h3 class="feature-title">Multi-Tenant Architecture</h3>
                    <p class="feature-description">
                        Complete data isolation between organizations. Your data is secure, private, and never shared with other tenants.
                    </p>
                </div>
                
                <div class="feature-card" data-aos="fade-up" data-aos-delay="200">
                    <div class="feature-icon gradient-purple">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <rect x="8" y="12" width="16" height="12" rx="2" stroke="white" stroke-width="2"/>
                            <path d="M12 12V8C12 5.79086 13.7909 4 16 4C18.2091 4 20 5.79086 20 8V12" stroke="white" stroke-width="2"/>
                            <circle cx="16" cy="18" r="2" fill="white"/>
                        </svg>
                    </div>
                    <h3 class="feature-title">Advanced Security</h3>
                    <p class="feature-description">
                        Two-factor authentication, role-based access control (32+ permissions), audit logging, and CSRF protection.
                    </p>
                </div>
                
                <div class="feature-card" data-aos="fade-up" data-aos-delay="300">
                    <div class="feature-icon gradient-green">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M16 28C22.6274 28 28 22.6274 28 16C28 9.37258 22.6274 4 16 4C9.37258 4 4 9.37258 4 16C4 22.6274 9.37258 28 16 28Z" stroke="white" stroke-width="2"/>
                            <path d="M12 16L15 19L20 13" stroke="white" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </div>
                    <h3 class="feature-title">Email Verification & OTP</h3>
                    <p class="feature-description">
                        Secure onboarding with OTP verification, automated email notifications, and rate limiting for security.
                    </p>
                </div>
                
                <div class="feature-card" data-aos="fade-up" data-aos-delay="100">
                    <div class="feature-icon gradient-orange">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M4 8L16 16L28 8M4 8V24H28V8M4 8L16 2L28 8" stroke="white" stroke-width="2" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <h3 class="feature-title">M-Pesa Integration</h3>
                    <p class="feature-description">
                        Seamless M-Pesa STK Push payments for subscriptions. Automatic payment verification and invoice management.
                    </p>
                </div>
                
                <div class="feature-card" data-aos="fade-up" data-aos-delay="200">
                    <div class="feature-icon gradient-pink">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M4 12H28M4 12V24C4 25.1046 4.89543 26 6 26H26C27.1046 26 28 25.1046 28 24V12M4 12V8C4 6.89543 4.89543 6 6 6H26C27.1046 6 28 6.89543 28 8V12" stroke="white" stroke-width="2"/>
                            <path d="M12 18H20" stroke="white" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </div>
                    <h3 class="feature-title">Activity Logging</h3>
                    <p class="feature-description">
                        Complete audit trail of all system activities. Track changes, user actions, and maintain compliance records.
                    </p>
                </div>
                
                <div class="feature-card" data-aos="fade-up" data-aos-delay="300">
                    <div class="feature-icon gradient-teal">
                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <rect x="6" y="6" width="20" height="20" rx="2" stroke="white" stroke-width="2"/>
                            <path d="M16 12V16L19 19" stroke="white" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </div>
                    <h3 class="feature-title">Subscription Management</h3>
                    <p class="feature-description">
                        Flexible subscription plans with 14-day trials, automatic billing, usage quotas, and upgrade/downgrade options.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Pricing Section -->
    <section id="pricing" class="pricing">
        <div class="container">
            <div class="section-header" data-aos="fade-up">
                <div class="section-badge">Pricing</div>
                <h2 class="section-title">Simple, <span class="gradient-text">Transparent Pricing</span></h2>
                <p class="section-description">
                    No hidden fees. No surprises. Choose the plan that works for your organization.
                </p>
            </div>
            
            <div class="pricing-grid">
                <div class="pricing-card" data-aos="fade-up" data-aos-delay="100">
                    <div class="pricing-badge" style="background: linear-gradient(135deg, #22C55E, #16A34A);">14-Day Free Trial</div>
                    <div class="pricing-header">
                        <h3 class="pricing-plan">Starter</h3>
                        <p class="pricing-subtitle">Perfect for small teams (5-25 employees)</p>
                    </div>
                    <div class="pricing-price">
                        <span class="currency">KES</span>
                        <span class="amount">3,000</span>
                        <span class="period">/month</span>
                    </div>
                    <ul class="pricing-features">
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Up to 25 employees</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Employee management</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Departments & positions</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Basic attendance tracking</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Leave management</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Employee self-service portal</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Basic reports (PDF)</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Email notifications</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Email support</span>
                        </li>
                    </ul>
                    <a href="<?php echo e(route('login')); ?>" class="btn btn-outline btn-block">Get Started</a>
                </div>
                
                <div class="pricing-card pricing-card-featured" data-aos="fade-up" data-aos-delay="200">
                    <div class="pricing-badge">Most Popular • 14-Day Free Trial</div>
                    <div class="pricing-header">
                        <h3 class="pricing-plan">Growth</h3>
                        <p class="pricing-subtitle">For serious SMEs (25-100 employees)</p>
                    </div>
                    <div class="pricing-price">
                        <span class="currency">KES</span>
                        <span class="amount">9,500</span>
                        <span class="period">/month</span>
                    </div>
                    <ul class="pricing-features">
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Up to 100 employees</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>All Starter features</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Full payroll with KRA compliance</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Advanced attendance rules</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Leave calendar (FullCalendar)</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Recruitment & ATS</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Performance management</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Training & development</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Bulk import/export (Excel)</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Custom roles & permissions</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Advanced reports (PDF + Excel)</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Priority support</span>
                        </li>
                    </ul>
                    <a href="<?php echo e(route('login')); ?>" class="btn btn-primary btn-block">Get Started</a>
                </div>
                
                <div class="pricing-card" data-aos="fade-up" data-aos-delay="300">
                    <div class="pricing-header">
                        <h3 class="pricing-plan">Business</h3>
                        <p class="pricing-subtitle">For established organizations (100-250+ employees)</p>
                    </div>
                    
                    <ul class="pricing-features">
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>250+ employees</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>All Growth features</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Advanced audit logs & security</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Multi-level approval workflows</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Department-level managers</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>100GB storage quota</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Theme customization</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Dedicated onboarding specialist</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Data export guarantees</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>99.9% SLA-backed uptime</span>
                        </li>
                        <li>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <circle cx="10" cy="10" r="10" fill="#E8F5E9"/>
                                <path d="M6 10L9 13L14 7" stroke="#22C55E" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                            <span>Dedicated account manager</span>
                        </li>
                    </ul>
                    <a href="<?php echo e(route('login')); ?>" class="btn btn-outline btn-block">Contact Sales</a>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section id="testimonials" class="testimonials">
        <div class="container">
            <div class="section-header" data-aos="fade-up">
                <div class="section-badge">Testimonials</div>
                <h2 class="section-title">Loved By <span class="gradient-text">HR Teams</span> Across Kenya</h2>
                <p class="section-description">
                    See what our customers have to say about transforming their HR operations
                </p>
            </div>
            
            <div class="testimonials-grid">
                <div class="testimonial-card" data-aos="fade-up" data-aos-delay="100">
                    <div class="testimonial-rating">
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10 2L12.5 7.5L18 8.5L14 13L15 18.5L10 15.5L5 18.5L6 13L2 8.5L7.5 7.5L10 2Z" fill="#FFB800"/>
                        </svg>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10 2L12.5 7.5L18 8.5L14 13L15 18.5L10 15.5L5 18.5L6 13L2 8.5L7.5 7.5L10 2Z" fill="#FFB800"/>
                        </svg>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10 2L12.5 7.5L18 8.5L14 13L15 18.5L10 15.5L5 18.5L6 13L2 8.5L7.5 7.5L10 2Z" fill="#FFB800"/>
                        </svg>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10 2L12.5 7.5L18 8.5L14 13L15 18.5L10 15.5L5 18.5L6 13L2 8.5L7.5 7.5L10 2Z" fill="#FFB800"/>
                        </svg>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10 2L12.5 7.5L18 8.5L14 13L15 18.5L10 15.5L5 18.5L6 13L2 8.5L7.5 7.5L10 2Z" fill="#FFB800"/>
                        </svg>
                    </div>
                    <p class="testimonial-text">
                        "Qaya HRM completely transformed how we manage our workforce. The statutory compliance features are exactly what we needed for the Kenyan market. Our HR team's productivity has tripled."
                    </p>
                    <div class="testimonial-author">
                        <div class="author-avatar">
                            <span>JM</span>
                        </div>
                        <div class="author-info">
                            <div class="author-name">Jane Mwangi</div>
                            <div class="author-role">HR Director, Tech Solutions Ltd</div>
                        </div>
                    </div>
                </div>
                
                <div class="testimonial-card" data-aos="fade-up" data-aos-delay="200">
                    <div class="testimonial-rating">
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10 2L12.5 7.5L18 8.5L14 13L15 18.5L10 15.5L5 18.5L6 13L2 8.5L7.5 7.5L10 2Z" fill="#FFB800"/>
                        </svg>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10 2L12.5 7.5L18 8.5L14 13L15 18.5L10 15.5L5 18.5L6 13L2 8.5L7.5 7.5L10 2Z" fill="#FFB800"/>
                        </svg>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10 2L12.5 7.5L18 8.5L14 13L15 18.5L10 15.5L5 18.5L6 13L2 8.5L7.5 7.5L10 2Z" fill="#FFB800"/>
                        </svg>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10 2L12.5 7.5L18 8.5L14 13L15 18.5L10 15.5L5 18.5L6 13L2 8.5L7.5 7.5L10 2Z" fill="#FFB800"/>
                        </svg>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10 2L12.5 7.5L18 8.5L14 13L15 18.5L10 15.5L5 18.5L6 13L2 8.5L7.5 7.5L10 2Z" fill="#FFB800"/>
                        </svg>
                    </div>
                    <p class="testimonial-text">
                        "The best investment we made this year. Payroll processing is now seamless and KRA-compliant. P9 generation used to take days, now it's done in seconds. Absolutely brilliant!"
                    </p>
                    <div class="testimonial-author">
                        <div class="author-avatar" style="background: linear-gradient(135deg, #3B82F6, #2563EB);">
                            <span>JK</span>
                        </div>
                        <div class="author-info">
                            <div class="author-name">John Kamau</div>
                            <div class="author-role">CEO, Retail Express Kenya</div>
                        </div>
                    </div>
                </div>
                
                <div class="testimonial-card" data-aos="fade-up" data-aos-delay="300">
                    <div class="testimonial-rating">
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10 2L12.5 7.5L18 8.5L14 13L15 18.5L10 15.5L5 18.5L6 13L2 8.5L7.5 7.5L10 2Z" fill="#FFB800"/>
                        </svg>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10 2L12.5 7.5L18 8.5L14 13L15 18.5L10 15.5L5 18.5L6 13L2 8.5L7.5 7.5L10 2Z" fill="#FFB800"/>
                        </svg>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10 2L12.5 7.5L18 8.5L14 13L15 18.5L10 15.5L5 18.5L6 13L2 8.5L7.5 7.5L10 2Z" fill="#FFB800"/>
                        </svg>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10 2L12.5 7.5L18 8.5L14 13L15 18.5L10 15.5L5 18.5L6 13L2 8.5L7.5 7.5L10 2Z" fill="#FFB800"/>
                        </svg>
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10 2L12.5 7.5L18 8.5L14 13L15 18.5L10 15.5L5 18.5L6 13L2 8.5L7.5 7.5L10 2Z" fill="#FFB800"/>
                        </svg>
                    </div>
                    <p class="testimonial-text">
                        "From recruitment to performance management, everything is in one place. The employee self-service portal has reduced HR inquiries by 70%. Our team loves it!"
                    </p>
                    <div class="testimonial-author">
                        <div class="author-avatar" style="background: linear-gradient(135deg, #8B5CF6, #7C3AED);">
                            <span>MW</span>
                        </div>
                        <div class="author-info">
                            <div class="author-name">Mary Wanjiku</div>
                            <div class="author-role">Operations Manager, Manufacturing Co</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta">
        <div class="container">
            <div class="cta-content" data-aos="zoom-in">
                <h2 class="cta-title">Ready to Transform Your HR Operations?</h2>
                <p class="cta-description">
                    Join Kenyan businesses using Qaya HRM to streamline workforce management. 
                    Start your 14-day free trial today - no credit card required, M-Pesa payments accepted.
                </p>
                <div class="cta-actions">
                    <a href="<?php echo e(route('login')); ?>" class="btn btn-white btn-large">
                        Start Free Trial
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M7 4L13 10L7 16" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </a>
                    <a href="#demo" class="btn btn-glass-white btn-large">
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <circle cx="10" cy="10" r="8" stroke="currentColor" stroke-width="2"/>
                            <path d="M8 7L13 10L8 13V7Z" fill="currentColor"/>
                        </svg>
                        Watch Demo
                    </a>
                </div>
                <div class="cta-note">
                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                        <path d="M14 5L6 13L2 9" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                    </svg>
                    14-day free trial • M-Pesa payments • 100% KRA compliant • Cancel anytime
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-column">
                    <a href="#" class="footer-logo">
                        <div class="logo-icon">
                            <svg width="32" height="32" viewBox="0 0 32 32" fill="none">
                                <path d="M16 2L28 9V23L16 30L4 23V9L16 2Z" fill="url(#footer-logo-gradient)" stroke="white" stroke-width="2"/>
                                <defs>
                                    <linearGradient id="footer-logo-gradient" x1="4" y1="2" x2="28" y2="30">
                                        <stop offset="0%" style="stop-color:#FF6B35"/>
                                        <stop offset="100%" style="stop-color:#F7931E"/>
                                    </linearGradient>
                                </defs>
                            </svg>
                        </div>
                        <span class="logo-text">Qaya<span class="logo-hrm">HRM</span></span>
                    </a>
                    <p class="footer-description">
                        Modern HR management solution built for East Africa. Complete employee lifecycle management, 
                        KRA-compliant payroll, and 14 integrated modules - all in one secure, cloud-based platform.
                    </p>
                    <div class="footer-social">
                        <a href="#" class="social-link">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <path d="M20 10C20 4.47715 15.5228 0 10 0C4.47715 0 0 4.47715 0 10C0 14.9912 3.65684 19.1283 8.4375 19.8785V12.8906H5.89844V10H8.4375V7.79688C8.4375 5.29063 9.93047 3.90625 12.2146 3.90625C13.3084 3.90625 14.4531 4.10156 14.4531 4.10156V6.5625H13.1922C11.95 6.5625 11.5625 7.3334 11.5625 8.125V10H14.3359L13.8926 12.8906H11.5625V19.8785C16.3432 19.1283 20 14.9912 20 10Z" fill="currentColor"/>
                            </svg>
                        </a>
                        <a href="#" class="social-link">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <path d="M20 3.79875C19.2563 4.125 18.4637 4.34125 17.6375 4.44625C18.4875 3.93875 19.1363 3.14125 19.4412 2.18C18.6488 2.6525 17.7738 2.98625 16.8412 3.1725C16.0887 2.37125 15.0162 1.875 13.8462 1.875C11.5763 1.875 9.74875 3.7175 9.74875 5.97625C9.74875 6.30125 9.77625 6.61375 9.84375 6.91125C6.435 6.745 3.41875 5.11125 1.3925 2.6225C1.03875 3.23625 0.83125 3.93875 0.83125 4.695C0.83125 6.115 1.5625 7.37375 2.6525 8.1025C1.99375 8.09 1.3475 7.89875 0.8 7.5975C0.8 7.61 0.8 7.62625 0.8 7.6425C0.8 9.635 2.22125 11.29 4.085 11.6712C3.75125 11.7625 3.3875 11.8062 3.01 11.8062C2.7475 11.8062 2.4825 11.7913 2.23375 11.7362C2.765 13.36 4.2725 14.5538 6.065 14.5925C4.67 15.6838 2.89875 16.3412 0.98125 16.3412C0.645 16.3412 0.3225 16.3263 0 16.285C1.81625 17.4563 3.96875 18.125 6.29 18.125C13.835 18.125 17.96 11.875 17.96 6.4575C17.96 6.27625 17.9538 6.10125 17.945 5.9275C18.7588 5.35 19.4425 4.62875 20 3.79875Z" fill="currentColor"/>
                            </svg>
                        </a>
                        <a href="#" class="social-link">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <path d="M19 0H1C0.4 0 0 0.4 0 1V19C0 19.6 0.4 20 1 20H19C19.6 20 20 19.6 20 19V1C20 0.4 19.6 0 19 0ZM6 17H3V8H6V17ZM4.5 6.3C3.5 6.3 2.7 5.5 2.7 4.5C2.7 3.5 3.5 2.7 4.5 2.7C5.5 2.7 6.3 3.5 6.3 4.5C6.3 5.5 5.5 6.3 4.5 6.3ZM17 17H14V12.4C14 11.2 13.8 9.9 12.5 9.9C11.2 9.9 11 11 11 12.4V17H8V8H11V9.4C11.5 8.6 12.5 7.9 14 7.9C17 7.9 17 10 17 12.4V17Z" fill="currentColor"/>
                            </svg>
                        </a>
                    </div>
                </div>
                
                <div class="footer-column">
                    <h4 class="footer-title">Product</h4>
                    <ul class="footer-links">
                        <li><a href="#features">Features</a></li>
                        <li><a href="#pricing">Pricing</a></li>
                        <li><a href="#">Integrations</a></li>
                        <li><a href="#">API Documentation</a></li>
                        <li><a href="#">Changelog</a></li>
                    </ul>
                </div>
                
                <div class="footer-column">
                    <h4 class="footer-title">Company</h4>
                    <ul class="footer-links">
                        <li><a href="#">About Us</a></li>
                        <li><a href="#">Careers</a></li>
                        <li><a href="#">Blog</a></li>
                        <li><a href="#">Press Kit</a></li>
                        <li><a href="#">Contact</a></li>
                    </ul>
                </div>
                
                <div class="footer-column">
                    <h4 class="footer-title">Resources</h4>
                    <ul class="footer-links">
                        <li><a href="#">Help Center</a></li>
                        <li><a href="#">Community</a></li>
                        <li><a href="#">Guides</a></li>
                        <li><a href="#">Webinars</a></li>
                        <li><a href="#">Partners</a></li>
                    </ul>
                </div>
                
                <div class="footer-column">
                    <h4 class="footer-title">Legal</h4>
                    <ul class="footer-links">
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">Terms of Service</a></li>
                        <li><a href="#">Cookie Policy</a></li>
                        <li><a href="#">Security</a></li>
                        <li><a href="#">Compliance</a></li>
                    </ul>
                </div>
            </div>
            
            <div class="footer-bottom">
                <p>&copy; 2026 Qaya HRM. All rights reserved.</p>
                <div class="footer-bottom-links">
                    <a href="#">Privacy</a>
                    <a href="#">Terms</a>
                    <a href="#">Sitemap</a>
                </div>
            </div>
        </div>
    </footer>

    <!-- AOS Animation Library -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    
    <!-- Custom Scripts -->
    <script>
        // Initialize AOS
        AOS.init({
            duration: 800,
            easing: 'ease-in-out',
            once: true,
            offset: 100
        });

        // Navbar scroll effect
        const navbar = document.getElementById('navbar');
        let lastScroll = 0;

        window.addEventListener('scroll', () => {
            const currentScroll = window.pageYOffset;
            
            if (currentScroll > 50) {
                navbar.classList.add('scrolled');
            } else {
                navbar.classList.remove('scrolled');
            }
            
            lastScroll = currentScroll;
        });

        // Mobile menu toggle
        const mobileToggle = document.getElementById('mobileToggle');
        const navMenu = document.getElementById('navMenu');

        mobileToggle.addEventListener('click', () => {
            mobileToggle.classList.toggle('active');
            navMenu.classList.toggle('active');
        });

        // Smooth scroll for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                    // Close mobile menu if open
                    navMenu.classList.remove('active');
                    mobileToggle.classList.remove('active');
                }
            });
        });

        // Floating shapes animation
        const shapes = document.querySelectorAll('.floating-shape');
        shapes.forEach((shape, index) => {
            const randomX = Math.random() * 100 - 50;
            const randomY = Math.random() * 100 - 50;
            const randomDelay = Math.random() * 5;
            
            shape.style.animationDelay = `${randomDelay}s`;
        });
    </script>
</body>
</html>
</html><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/landing.blade.php ENDPATH**/ ?>