<?php $__env->startSection('title', 'Generate Individual Payroll'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <?php if (isset($component)) { $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-header','data' => ['title' => 'Generate Individual Payroll','description' => 'Create payroll for a single employee']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Generate Individual Payroll','description' => 'Create payroll for a single employee']); ?>
                 <?php $__env->slot('actions', null, []); ?> 
                    <a href="<?php echo e(route('payroll.index')); ?>" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Back to Payroll
                    </a>
                 <?php $__env->endSlot(); ?>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $attributes = $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $component = $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>

            <?php if($errors->any()): ?>
                <?php if (isset($component)) { $__componentOriginal5194778a3a7b899dcee5619d0610f5cf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5194778a3a7b899dcee5619d0610f5cf = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.alert','data' => ['type' => 'danger']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'danger']); ?>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div><?php echo e($error); ?></div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5194778a3a7b899dcee5619d0610f5cf)): ?>
<?php $attributes = $__attributesOriginal5194778a3a7b899dcee5619d0610f5cf; ?>
<?php unset($__attributesOriginal5194778a3a7b899dcee5619d0610f5cf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5194778a3a7b899dcee5619d0610f5cf)): ?>
<?php $component = $__componentOriginal5194778a3a7b899dcee5619d0610f5cf; ?>
<?php unset($__componentOriginal5194778a3a7b899dcee5619d0610f5cf); ?>
<?php endif; ?>
            <?php endif; ?>

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Payroll Generation</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="<?php echo e(route('payroll.store')); ?>">
                                <?php echo csrf_field(); ?>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <?php if (isset($component)) { $__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.form.select','data' => ['name' => 'employee_id','label' => 'Select Employee','required' => true,'placeholder' => 'Choose an employee...','options' => []]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('form.select'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'employee_id','label' => 'Select Employee','required' => true,'placeholder' => 'Choose an employee...','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([])]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36)): ?>
<?php $attributes = $__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36; ?>
<?php unset($__attributesOriginal8cee41e4af1fe2df52d1d5acd06eed36); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36)): ?>
<?php $component = $__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36; ?>
<?php unset($__componentOriginal8cee41e4af1fe2df52d1d5acd06eed36); ?>
<?php endif; ?>
                                                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($employee->id); ?>" <?php echo e(old('employee_id') == $employee->id ? 'selected' : ''); ?>>
                                                        <?php echo e($employee->full_name); ?> (<?php echo e($employee->employee_code); ?>)
                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label for="year" class="form-label">Year</label>
                                            <select name="year" id="year" class="form-select" required>
                                                <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($year); ?>" <?php echo e((old('year') ?? date('Y')) == $year ? 'selected' : ''); ?>>
                                                        <?php echo e($year); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label for="month" class="form-label">Month</label>
                                            <select name="month" id="month" class="form-select" required>
                                                <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $num => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($num); ?>" <?php echo e((old('month') ?? date('n')) == $num ? 'selected' : ''); ?>>
                                                        <?php echo e($name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="alert alert-info">
                                    <i class="bi bi-info-circle"></i>
                                    <strong>Note:</strong> Payroll will be generated based on:
                                    <ul class="mb-0 mt-2">
                                        <li>Employee's active contract and salary structure</li>
                                        <li>Attendance records for the selected period</li>
                                        <li>Employment type specific tax rules</li>
                                        <li>Applicable statutory deductions (PAYE, NHIF, NSSF, Housing Levy)</li>
                                    </ul>
                                </div>

                                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                    <a href="<?php echo e(route('payroll.index')); ?>" class="btn btn-outline-secondary">
                                        Cancel
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-cogs"></i> Generate Payroll
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <!-- Employee Preview -->
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Employee Preview</h6>
                        </div>
                        <div class="card-body">
                            <div id="employeePreview" class="d-none">
                                <div class="text-center mb-3">
                                    <h5 id="employeeName"></h5>
                                    <p class="text-muted mb-0" id="employeeCode"></p>
                                    <p class="text-muted" id="employeeDepartment"></p>
                                </div>
                                
                                <div class="row text-center mb-3">
                                    <div class="col-6">
                                        <div class="border-end">
                                            <span class="badge bg-info" id="employmentType"></span><br>
                                            <small class="text-muted">Employment Type</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <span class="badge bg-secondary" id="paymentFrequency"></span><br>
                                        <small class="text-muted">Payment Frequency</small>
                                    </div>
                                </div>

                                <div class="alert alert-light">
                                    <small class="text-muted">
                                        <i class="bi bi-info-circle"></i>
                                        Contract details will be used for payroll calculation.
                                    </small>
                                </div>
                            </div>

                            <div id="noEmployeeSelected" class="text-center py-4">
                                <i class="bi bi-user-plus fa-2x text-muted mb-3"></i>
                                <p class="text-muted">Select an employee to see their details</p>
                            </div>
                        </div>
                    </div>

                    <!-- Quick Actions -->
                    <div class="card mt-3">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Quick Actions</h6>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <a href="<?php echo e(route('payroll.bulk')); ?>" class="btn btn-outline-success btn-sm">
                                    <i class="bi bi-users"></i> Bulk Generate
                                </a>
                                <a href="<?php echo e(route('payroll.calculator')); ?>" class="btn btn-outline-info btn-sm">
                                    <i class="bi bi-calculator"></i> Payroll Calculator
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const employeeSelect = document.getElementById('employee_id');
    const employeePreview = document.getElementById('employeePreview');
    const noEmployeeSelected = document.getElementById('noEmployeeSelected');

    // Employee data (passed from backend)
    const employees = <?php echo json_encode($employeesForJs, 15, 512) ?>;

    employeeSelect.addEventListener('change', function() {
        const selectedId = this.value;
        
        if (selectedId) {
            const employee = employees.find(emp => emp.id == selectedId);
            
            if (employee) {
                document.getElementById('employeeName').textContent = employee.name;
                document.getElementById('employeeCode').textContent = employee.code;
                document.getElementById('employeeDepartment').textContent = employee.department;
                document.getElementById('employmentType').textContent = employee.employment_type.charAt(0).toUpperCase() + employee.employment_type.slice(1);
                document.getElementById('paymentFrequency').textContent = employee.payment_frequency.charAt(0).toUpperCase() + employee.payment_frequency.slice(1);
                
                employeePreview.classList.remove('d-none');
                noEmployeeSelected.classList.add('d-none');
            }
        } else {
            employeePreview.classList.add('d-none');
            noEmployeeSelected.classList.remove('d-none');
        }
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/payroll/create.blade.php ENDPATH**/ ?>