<?php $__env->startSection('title', 'Subscription Expired'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card border-danger">
                <div class="card-header bg-danger text-white">
                    <h4 class="mb-0"><i class="bi bi-exclamation-octagon"></i> Subscription Expired</h4>
                </div>
                <div class="card-body text-center py-5">
                    <i class="bi bi-calendar-x text-danger" style="font-size: 4rem;"></i>
                    <h3 class="mt-3">Your Subscription Has Expired</h3>
                    <p class="lead text-muted">
                        Your subscription to <strong><?php echo e($subscription->plan->name); ?></strong> has expired.
                        Renew now to regain access to all features.
                    </p>
                    
                    <?php if($subscription->ends_at): ?>
                    <p class="text-muted">
                        Expired on: <?php echo e($subscription->ends_at->format('M d, Y')); ?>

                    </p>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Previous Plan Info -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-info-circle"></i> Your Previous Plan</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h4><?php echo e($subscription->plan->name); ?></h4>
                            <p class="text-muted"><?php echo e($subscription->plan->description); ?></p>
                        </div>
                        <div class="col-md-6">
                            <h3 class="text-primary">
                                KES <?php echo e(number_format($subscription->plan->price_monthly, 0)); ?>

                                <small class="text-muted">/month</small>
                            </h3>
                            <a href="<?php echo e(route('subscription.upgrade', $subscription->plan)); ?>" class="btn btn-primary">
                                <i class="bi bi-arrow-clockwise"></i> Renew This Plan
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Other Plans -->
            <div class="row mt-4">
                <div class="col-md-12">
                    <h4 class="mb-3">Or Choose a Different Plan</h4>
                </div>
                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($plan->id !== $subscription->plan_id): ?>
                    <div class="col-md-4 mb-4">
                        <div class="card h-100">
                            <div class="card-body d-flex flex-column">
                                <h4 class="card-title"><?php echo e($plan->name); ?></h4>
                                <p class="text-muted"><?php echo e($plan->description); ?></p>
                                
                                <div class="mb-3">
                                    <h3 class="text-primary">
                                        KES <?php echo e(number_format($plan->price_monthly, 0)); ?>

                                        <small class="text-muted fs-6">/month</small>
                                    </h3>
                                </div>

                                <ul class="list-unstyled mb-4">
                                    <li class="mb-2">
                                        <i class="bi bi-check-circle text-success"></i>
                                        <?php echo e($plan->max_employees ?? 'Unlimited'); ?> Employees
                                    </li>
                                    <li class="mb-2">
                                        <i class="bi bi-check-circle text-success"></i>
                                        <?php echo e($plan->max_users ?? 'Unlimited'); ?> Users
                                    </li>
                                    <li class="mb-2">
                                        <i class="bi bi-check-circle text-success"></i>
                                        <?php echo e($plan->storage_limit_gb ?? 'Unlimited'); ?> GB Storage
                                    </li>
                                </ul>

                                <div class="mt-auto">
                                    <a href="<?php echo e(route('subscription.upgrade', $plan)); ?>" 
                                       class="btn btn-outline-primary w-100">
                                        <i class="bi bi-star"></i> Choose This Plan
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="alert alert-info mt-4">
                <h6><i class="bi bi-lightbulb"></i> Why Renew?</h6>
                <ul class="mb-0">
                    <li>Regain access to all your data and features</li>
                    <li>Continue managing your HR operations seamlessly</li>
                    <li>No data loss - everything is preserved</li>
                    <li>Instant reactivation upon payment</li>
                </ul>
            </div>

            <div class="text-center mt-4">
                <p class="text-muted">
                    Need help? <a href="mailto:support@qayahrm.com">Contact our support team</a>
                </p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/organization/subscription/expired.blade.php ENDPATH**/ ?>