<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PayrollController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\ContractController;
use App\Http\Controllers\AttendanceController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// API Authentication routes
Route::prefix('auth')->group(function () {
    Route::post('/login', [App\Http\Controllers\Api\AuthController::class, 'login'])
         ->middleware('throttle:5,1');
    Route::post('/logout', [App\Http\Controllers\Api\AuthController::class, 'logout'])
         ->middleware('auth:sanctum');
    Route::post('/refresh', [App\Http\Controllers\Api\AuthController::class, 'refresh'])
         ->middleware('auth:sanctum');
});

// Protected API routes
Route::middleware(['auth:sanctum', 'throttle:60,1'])->group(function () {
    // Payroll Routes
    Route::prefix('payroll')->group(function () {
        Route::get('/', [PayrollController::class, 'index']);
        Route::post('/generate-monthly', [PayrollController::class, 'generateMonthly']);
        Route::post('/generate-employee/{employee}', [PayrollController::class, 'generateEmployee']);
        Route::post('/preview', [PayrollController::class, 'preview']);
        Route::post('/calculate-hourly', [PayrollController::class, 'calculateHourly']);
        Route::post('/calculate-daily', [PayrollController::class, 'calculateDaily']);
        Route::get('/summary', [PayrollController::class, 'summary']);
        Route::get('/tax-rules', [PayrollController::class, 'taxRules']);
        
        Route::get('/{payroll}', [PayrollController::class, 'show']);
        Route::put('/{payroll}', [PayrollController::class, 'update']);
        Route::delete('/{payroll}', [PayrollController::class, 'destroy']);
        Route::post('/{payroll}/approve', [PayrollController::class, 'approve']);
        Route::post('/{payroll}/process', [PayrollController::class, 'process']);
    });

    // Employee Routes
    // Route::apiResource('employees', EmployeeController::class);

    // Contract Routes
    // Route::apiResource('contracts', ContractController::class);

    // Attendance Routes
    Route::apiResource('attendances', AttendanceController::class);
    Route::post('attendances/{attendance}/approve', [AttendanceController::class, 'approve']);
    Route::post('attendances/bulk-approve', [AttendanceController::class, 'bulkApprove']);
});

// M-Pesa Callback Routes (No authentication required - Safaricom calls these)
Route::prefix('mpesa')->group(function () {
    Route::post('/callback', [App\Http\Controllers\Api\MpesaCallbackController::class, 'callback']);
    Route::post('/c2b/validation', [App\Http\Controllers\Api\MpesaCallbackController::class, 'validation']);
    Route::post('/c2b/confirmation', [App\Http\Controllers\Api\MpesaCallbackController::class, 'confirmation']);
    
    // Test endpoint (only in debug mode)
    Route::post('/test-callback', [App\Http\Controllers\Api\MpesaCallbackController::class, 'test']);
});