@extends('layouts.app')
@section('title', 'View User')
@section('page-title', 'User Details')
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Dashboard', 'url' => route('dashboard')],
    ['label' => 'Users', 'url' => route('users.index')],
    ['label' => $user->name]
]" />

<div class="row">
    <div class="col-md-8 mx-auto">
        <x-info-card>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0"><i class="bi bi-person"></i> User Information</h5>
                @if(auth()->user()->canManageRoles())
                <a href="{{ route('users.edit', $user) }}" class="btn btn-primary btn-sm">
                    <i class="bi bi-pencil"></i> Edit
                </a>
                @endif
            </div>

            <div class="row">
                <div class="col-md-12 text-center mb-4">
                    <x-user-avatar :user="$user" size="120" />
                    <h4 class="mt-3 mb-0">{{ $user->name }}</h4>
                    @if($user->roles->isNotEmpty())
                        <span class="badge bg-primary fs-6">{{ ucfirst($user->roles->first()->name) }}</span>
                    @endif
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="text-muted small">Email</label>
                        <p class="mb-0"><i class="bi bi-envelope"></i> {{ $user->email }}</p>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="text-muted small">Phone</label>
                        <p class="mb-0"><i class="bi bi-telephone"></i> {{ $user->phone ?? 'Not provided' }}</p>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="text-muted small">Role</label>
                        <p class="mb-0">
                            @if($user->roles->isNotEmpty())
                                <span class="badge bg-primary">{{ ucfirst($user->roles->first()->name) }}</span>
                            @else
                                <span class="badge bg-secondary">No Role Assigned</span>
                            @endif
                        </p>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="text-muted small">Employee Record</label>
                        <p class="mb-0">
                            @if($user->employee)
                                <a href="{{ route('employees.show', $user->employee) }}" class="btn btn-sm btn-outline-primary">
                                    <i class="bi bi-person-badge"></i> View Employee ({{ $user->employee->employee_id }})
                                </a>
                            @else
                                <span class="text-muted">Not linked to employee</span>
                            @endif
                        </p>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="text-muted small">Account Created</label>
                        <p class="mb-0"><i class="bi bi-calendar"></i> {{ $user->created_at->format('F d, Y') }}</p>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="text-muted small">Last Updated</label>
                        <p class="mb-0"><i class="bi bi-calendar"></i> {{ $user->updated_at->format('F d, Y') }}</p>
                    </div>
                </div>
            </div>
        </x-info-card>

        @if($user->roles->isNotEmpty())
        <x-info-card title="Permissions" icon="shield-check" class="mt-4">
            @php
                $permissions = $user->getAllPermissions()->groupBy(function($permission) {
                    $parts = explode('_', $permission->name);
                    return count($parts) > 1 ? $parts[1] : 'general';
                });
            @endphp

            @if($permissions->count() > 0)
                <div class="row">
                    @foreach($permissions as $group => $perms)
                        <div class="col-md-6 mb-3">
                            <h6 class="text-capitalize">{{ str_replace('_', ' ', $group) }}</h6>
                            <ul class="list-unstyled ms-3">
                                @foreach($perms as $permission)
                                    <li><i class="bi bi-check-circle text-success"></i> {{ ucwords(str_replace('_', ' ', $permission->name)) }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-muted mb-0">No permissions assigned to this role</p>
            @endif
        </x-info-card>
        @endif

        <div class="mt-3">
            <a href="{{ route('users.index') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Back to Users
            </a>
        </div>
    </div>
</div>
@endsection
