@extends('layouts.app')

@section('title', 'Edit User')
@section('page-title', 'Edit User')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Users', 'url' => route('users.index')],
        ['label' => 'Edit']
    ]" />

    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-pencil"></i> Edit User: {{ $user->name }}</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('users.update', $user) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <x-form.input name="name" label="Full Name" required :value="$user->name" />

                        <x-form.input type="email" name="email" label="Email Address" required :value="$user->email" />

                        <x-form.input name="phone" label="Phone Number" :value="$user->phone" />

                        <div class="mb-3">
                            <label for="role_id" class="form-label">Assign Role <span class="text-danger">*</span></label>
                            <select name="role_id" id="role_id" class="form-select @error('role_id') is-invalid @enderror" required>
                                <option value="">Select a role...</option>
                                @foreach($roles as $role)
                                    <option value="{{ $role->id }}" {{ old('role_id', $user->role_id) == $role->id ? 'selected' : '' }}>
                                        {{ $role->display_name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('role_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">Current role: <strong>{{ $user->roles->isNotEmpty() ? ucfirst($user->roles->first()->name) : 'None' }}</strong></small>
                        </div>

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-save"></i> Update User
                            </button>
                            <a href="{{ route('users.index') }}" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-left"></i> Back to Users
                            </a>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Change Password Section -->
            <div class="card shadow-sm">
                <div class="card-header bg-warning text-dark">
                    <h5 class="mb-0"><i class="bi bi-key"></i> Change Password</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('users.updatePassword', $user) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <x-alert type="warning">
                            <strong>Warning:</strong> This will change the user's password. They will need to use the new password to log in.
                        </x-alert>

                        <x-form.input 
                            type="password" 
                            name="password" 
                            label="New Password" 
                            required
                            help="Minimum 8 characters" />

                        <x-form.input 
                            type="password" 
                            name="password_confirmation" 
                            label="Confirm New Password" 
                            required />

                        <button type="submit" class="btn btn-warning">
                            <i class="bi bi-key"></i> Change Password
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
