@extends('layouts.app')
@section('title', 'Training Session Details')
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Training Sessions', 'url' => route('training.sessions.index')],
    ['label' => $session->session_code]
]" />

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <h1 class="h3 mb-0">{{ $session->program->title }}</h1>
                    <p class="text-muted mb-0">Session: {{ $session->session_code }}</p>
                </div>
                <div>
                    @can('update', $session)
                        <a href="{{ route('training.sessions.edit', $session) }}" class="btn btn-outline-primary me-2">
                            <i class="bi bi-pencil"></i> Edit Session
                        </a>
                    @endcan
                    <a href="{{ route('training.sessions.index') }}" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Back to Sessions
                    </a>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-8">
                    <x-info-card>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h5 class="mb-0">Session Details</h5>
                            <x-status-badge :status="$session->status" />
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <strong>Start Date & Time:</strong><br>
                                    <i class="bi bi-calendar-event text-primary"></i> {{ $session->start_datetime->format('l, F j, Y') }}<br>
                                    <i class="bi bi-clock text-primary"></i> {{ $session->start_datetime->format('g:i A') }}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <strong>End Date & Time:</strong><br>
                                    <i class="bi bi-calendar-event text-primary"></i> {{ $session->end_datetime->format('l, F j, Y') }}<br>
                                    <i class="bi bi-clock text-primary"></i> {{ $session->end_datetime->format('g:i A') }}
                                </div>
                            </div>
                        </div>

                        <table class="table table-borderless">
                            <x-detail-row label="Duration" :value="$session->duration_in_hours . ' hours'" />
                            <x-detail-row label="Instructor" :value="$session->instructor?->name ?? 'Not assigned'" />
                            @if($session->location)
                            <x-detail-row label="Location" :value="$session->location" />
                            @endif
                            @if($session->virtual_meeting_link)
                            <x-detail-row label="Virtual Meeting">
                                <a href="{{ $session->virtual_meeting_link }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                    <i class="bi bi-camera-video"></i> Join Meeting
                                </a>
                            </x-detail-row>
                            @endif
                        </table>

                        @if($session->session_notes)
                            <div class="mb-3">
                                <strong>Session Notes:</strong><br>
                                <div class="bg-light p-3 rounded">
                                    {{ $session->session_notes }}
                                </div>
                            </div>
                        @endif
                    </x-info-card>

                    <x-info-card title="Program Information" class="mt-4">
                        <table class="table table-borderless">
                            <x-detail-row label="Program" :value="$session->program->title" />
                            <x-detail-row label="Category" :value="$session->program->category->name" />
                            <x-detail-row label="Duration" :value="$session->program->formatted_duration" />
                            <x-detail-row label="Type" :value="ucfirst($session->program->type)" />
                        </table>
                    </x-info-card>

                    @if($session->participants->count() > 0)
                    <x-info-card title="Participants ({{ $session->participants->count() }})" icon="people" class="mt-4">
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Employee</th>
                                        <th>Department</th>
                                        <th>Status</th>
                                        <th>Attendance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($session->participants as $participant)
                                    <tr>
                                        <td>{{ $participant->employee->full_name }}</td>
                                        <td>{{ $participant->employee->department->name ?? 'N/A' }}</td>
                                        <td><x-status-badge :status="$participant->enrollment_status" /></td>
                                        <td>
                                            @if($participant->attendance_status)
                                                <x-status-badge :status="$participant->attendance_status" />
                                            @else
                                                <span class="text-muted">Not marked</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </x-info-card>
                    @endif
                </div>

                <div class="col-lg-4">
                    <x-info-card title="Session Statistics">
                        <div class="list-group list-group-flush">
                            <div class="list-group-item d-flex justify-content-between px-0">
                                <span>Max Participants</span>
                                <strong>{{ $session->max_participants ?? $session->program->max_participants ?? 'Unlimited' }}</strong>
                            </div>
                            <div class="list-group-item d-flex justify-content-between px-0">
                                <span>Enrolled</span>
                                <strong>{{ $session->participants->count() }}</strong>
                            </div>
                            <div class="list-group-item d-flex justify-content-between px-0">
                                <span>Attended</span>
                                <strong>{{ $session->participants->where('attendance_status', 'present')->count() }}</strong>
                            </div>
                            <div class="list-group-item d-flex justify-content-between px-0">
                                <span>Completed</span>
                                <strong>{{ $session->participants->where('enrollment_status', 'completed')->count() }}</strong>
                            </div>
                        </div>
                    </x-info-card>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
