@extends('layouts.app')

@section('title', 'Manage Training Sessions')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Manage Training Sessions</h1>
                @can('create', App\Models\TrainingSession::class)
                    <a href="{{ route('training.sessions.create') }}" class="btn btn-primary">
                        <i class="bi bi-plus"></i> Schedule Session
                    </a>
                @endcan
            </div>

            <!-- Filters -->
            <div class="card mb-4">
                <div class="card-body">
                    <form method="GET" action="{{ route('training.sessions.index') }}">
                        <div class="row">
                            <div class="col-md-3">
                                <select name="program" class="form-select">
                                    <option value="">All Programs</option>
                                    @foreach($programs as $program)
                                        <option value="{{ $program->id }}" {{ request('program') == $program->id ? 'selected' : '' }}>
                                            {{ $program->title }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="status" class="form-select">
                                    <option value="">All Status</option>
                                    <option value="scheduled" {{ request('status') == 'scheduled' ? 'selected' : '' }}>Scheduled</option>
                                    <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>In Progress</option>
                                    <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                                    <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="from_date" class="form-control" value="{{ request('from_date') }}" placeholder="From Date">
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="to_date" class="form-control" value="{{ request('to_date') }}" placeholder="To Date">
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-outline-secondary" type="submit">
                                    <i class="bi bi-search"></i> Filter
                                </button>
                                <a href="{{ route('training.sessions.index') }}" class="btn btn-outline-secondary">
                                    <i class="bi bi-x-circle"></i> Clear
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Sessions Table -->
            <div class="card">
                <div class="card-body">
                    @if($sessions->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Session Code</th>
                                        <th>Program</th>
                                        <th>Date & Time</th>
                                        <th>Location</th>
                                        <th>Instructor</th>
                                        <th>Enrollments</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($sessions as $session)
                                        <tr>
                                            <td>
                                                <strong>{{ $session->session_code }}</strong>
                                            </td>
                                            <td>
                                                <div>
                                                    <strong>{{ $session->program->title }}</strong><br>
                                                    <small class="text-muted">{{ $session->program->category->name }}</small>
                                                </div>
                                            </td>
                                            <td>
                                                <div>
                                                    <strong>{{ $session->start_datetime->format('M j, Y') }}</strong><br>
                                                    <small class="text-muted">
                                                        {{ $session->start_datetime->format('g:i A') }} - {{ $session->end_datetime->format('g:i A') }}
                                                    </small>
                                                </div>
                                            </td>
                                            <td>
                                                @if($session->location)
                                                    <i class="bi bi-map-marker-alt"></i> {{ $session->location }}
                                                @elseif($session->virtual_meeting_link)
                                                    <i class="bi bi-video"></i> Virtual
                                                @else
                                                    <span class="text-muted">TBD</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($session->instructor)
                                                    {{ $session->instructor->name }}
                                                @else
                                                    <span class="text-muted">Not assigned</span>
                                                @endif
                                            </td>
                                            <td>
                                                <span class="badge badge-info">{{ $session->enrollments->count() }}</span>
                                                @if($session->max_participants)
                                                    / {{ $session->max_participants }}
                                                @endif
                                            </td>
                                            <td>
                                                <span class="badge badge-{{ 
                                                    $session->status == 'scheduled' ? 'primary' : 
                                                    ($session->status == 'in_progress' ? 'warning' : 
                                                    ($session->status == 'completed' ? 'success' : 'danger')) 
                                                }}">
                                                    {{ ucfirst(str_replace('_', ' ', $session->status)) }}
                                                </span>
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    @can('view', $session)
                                                        <a href="{{ route('training.sessions.show', $session) }}" class="btn btn-sm btn-outline-primary">
                                                            <i class="bi bi-eye"></i>
                                                        </a>
                                                    @endcan
                                                    @can('update', $session)
                                                        @if($session->status == 'scheduled')
                                                            <a href="{{ route('training.sessions.edit', $session) }}" class="btn btn-sm btn-outline-secondary">
                                                                <i class="bi bi-pencil"></i>
                                                            </a>
                                                        @endif
                                                    @endcan
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="d-flex justify-content-center">
                            {{ $sessions->withQueryString()->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="bi bi-calendar-times fa-3x text-muted mb-3"></i>
                            <h4>No Training Sessions Found</h4>
                            <p class="text-muted">No training sessions match your current filters.</p>
                            @can('create', App\Models\TrainingSession::class)
                                <a href="{{ route('training.sessions.create') }}" class="btn btn-primary">
                                    <i class="bi bi-plus"></i> Schedule First Session
                                </a>
                            @endcan
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection