@extends('layouts.app')

@section('title', 'Edit Training Program')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <x-page-header 
                title="Edit Training Program"
                backUrl="{{ route('training.programs.show', $program) }}"
                backText="Back to Program" />

            <div class="row">
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">Program Details</h5>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('training.programs.update', $program) }}" method="POST">
                                @csrf
                                @method('PUT')

                                <div class="row">
                                    <div class="col-md-8">
                                        <x-form.input name="title" label="Program Title" required :value="$program->title" />
                                    </div>
                                    <div class="col-md-4">
                                        <x-form.select 
                                            name="training_category_id" 
                                            label="Category" 
                                            required
                                            :value="$program->training_category_id"
                                            :options="$categories->pluck('name', 'id')->toArray()" />
                                    </div>
                                </div>

                                <x-form.textarea name="description" label="Description" required rows="4" :value="$program->description" />

                                <div class="row">
                                    <div class="col-md-4">
                                        <x-form.select 
                                            name="type" 
                                            label="Type" 
                                            required
                                            :value="$program->type"
                                            :options="[
                                                'internal' => 'Internal',
                                                'external' => 'External',
                                                'online' => 'Online',
                                                'workshop' => 'Workshop',
                                                'seminar' => 'Seminar',
                                                'certification' => 'Certification'
                                            ]" />
                                    </div>
                                    <div class="col-md-4">
                                        <x-form.select 
                                            name="delivery_method" 
                                            label="Delivery Method" 
                                            required
                                            :value="$program->delivery_method"
                                            :options="[
                                                'in_person' => 'In Person',
                                                'virtual' => 'Virtual',
                                                'hybrid' => 'Hybrid',
                                                'self_paced' => 'Self-Paced'
                                            ]" />
                                    </div>
                                    <div class="col-md-4">
                                        <x-form.select 
                                            name="difficulty_level" 
                                            label="Difficulty Level" 
                                            required
                                            :value="$program->difficulty_level"
                                            :options="[
                                                'beginner' => 'Beginner',
                                                'intermediate' => 'Intermediate',
                                                'advanced' => 'Advanced'
                                            ]" />
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-4">
                                        <x-form.input 
                                            type="number" 
                                            name="duration_hours" 
                                            label="Duration (Hours)" 
                                            required
                                            step="0.5"
                                            min="0.5"
                                            max="1000"
                                            :value="$program->duration_hours" />
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="cost_per_participant" class="form-label">Cost per Participant</label>
                                            <div class="input-group">
                                                <span class="input-group-text">$</span>
                                                <input type="number" step="0.01" min="0" 
                                                       class="form-control @error('cost_per_participant') is-invalid @enderror" 
                                                       id="cost_per_participant" name="cost_per_participant" 
                                                       value="{{ old('cost_per_participant', $program->cost_per_participant) }}">
                                            </div>
                                            @error('cost_per_participant')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <x-form.input 
                                            type="number" 
                                            name="max_participants" 
                                            label="Max Participants"
                                            min="1"
                                            :value="$program->max_participants" />
                                    </div>
                                </div>

                                <x-form.textarea name="content_outline" label="Content Outline" rows="4" :value="$program->content_outline" />

                                <div class="row">
                                    <div class="col-md-6">
                                        <x-form.input name="instructor_name" label="Instructor Name" :value="$program->instructor_name" />
                                    </div>
                                    <div class="col-md-6">
                                        <x-form.input type="email" name="instructor_email" label="Instructor Email" :value="$program->instructor_email" />
                                    </div>
                                </div>

                                <x-form.input name="provider_name" label="Training Provider" :value="$program->provider_name" />

                                <div class="row">
                                    <div class="col-md-6">
                                        <x-form.checkbox name="is_mandatory" label="Mandatory Training" :checked="$program->is_mandatory" />
                                    </div>
                                    <div class="col-md-6">
                                        <x-form.checkbox name="is_active" label="Active Program" :checked="$program->is_active" />
                                    </div>
                                </div>

                                <x-form.button-group 
                                    cancelUrl="{{ route('training.programs.show', $program) }}"
                                    submitText="Update Program"
                                    submitIcon="bi-save" />
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="mb-0">Program Information</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <small class="text-muted">Created by</small><br>
                                <strong>{{ $program->creator->name }}</strong>
                            </div>
                            <div class="mb-3">
                                <small class="text-muted">Created on</small><br>
                                <strong>{{ $program->created_at->format('M j, Y g:i A') }}</strong>
                            </div>
                            <div class="mb-3">
                                <small class="text-muted">Last updated</small><br>
                                <strong>{{ $program->updated_at->format('M j, Y g:i A') }}</strong>
                            </div>
                            <div class="mb-3">
                                <small class="text-muted">Total Sessions</small><br>
                                <strong>{{ $program->sessions->count() }}</strong>
                            </div>
                            <div class="mb-3">
                                <small class="text-muted">Total Enrollments</small><br>
                                <strong>{{ $program->enrollments()->count() }}</strong>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
