@extends('layouts.app')

@section('title', 'Training Performance Impact')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Training Performance Impact</h1>
                <div class="btn-group">
                    @can('create', App\Models\TrainingPerformanceImpact::class)
                        <a href="{{ route('training.performance.create') }}" class="btn btn-primary">
                            <i class="bi bi-plus"></i> Record Impact
                        </a>
                        <button type="button" class="btn btn-outline-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown">
                            <span class="visually-hidden">Toggle Dropdown</span>
                        </button>
                        <ul class="dropdown-menu">
                            <li>
                                <a class="dropdown-item" href="{{ route('training.performance.analytics') }}">
                                    <i class="bi bi-graph-up"></i> View Analytics
                                </a>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <button type="button" class="dropdown-item" data-bs-toggle="modal" data-bs-target="#autoTrackModal">
                                    <i class="bi bi-cpu"></i> Auto-Track Performance
                                </button>
                            </li>
                        </ul>
                    @endcan
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0">{{ $stats['total_impacts'] }}</h4>
                                    <p class="mb-0">Total Impact Records</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-graph-up fs-2"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0">{{ $stats['positive_impacts'] }}</h4>
                                    <p class="mb-0">Positive Impacts</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-arrow-up-circle fs-2"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0">{{ number_format($stats['avg_improvement'], 2) }}</h4>
                                    <p class="mb-0">Avg. Improvement</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-speedometer2 fs-2"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0">{{ $stats['best_program'] }}</h4>
                                    <p class="mb-0">Best Performing Program</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-trophy fs-2"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Filters -->
            <div class="card mb-4">
                <div class="card-body">
                    <form method="GET" action="{{ route('training.performance.index') }}">
                        <div class="row">
                            <div class="col-md-2">
                                <select name="training_program" class="form-select">
                                    <option value="">All Programs</option>
                                    @foreach($trainingPrograms as $program)
                                        <option value="{{ $program->id }}" {{ request('training_program') == $program->id ? 'selected' : '' }}>
                                            {{ $program->title }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="employee" class="form-select">
                                    <option value="">All Employees</option>
                                    @foreach($employees as $employee)
                                        <option value="{{ $employee->id }}" {{ request('employee') == $employee->id ? 'selected' : '' }}>
                                            {{ $employee->full_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}" placeholder="From Date">
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}" placeholder="To Date">
                            </div>
                            <div class="col-md-2">
                                <select name="impact_type" class="form-select">
                                    <option value="">All Impact Types</option>
                                    <option value="positive" {{ request('impact_type') == 'positive' ? 'selected' : '' }}>Positive</option>
                                    <option value="negative" {{ request('impact_type') == 'negative' ? 'selected' : '' }}>Negative</option>
                                    <option value="neutral" {{ request('impact_type') == 'neutral' ? 'selected' : '' }}>Neutral</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-outline-primary">
                                    <i class="bi bi-funnel"></i> Filter
                                </button>
                                <a href="{{ route('training.performance.index') }}" class="btn btn-outline-secondary">
                                    <i class="bi bi-x-circle"></i> Clear
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Impact Records -->
            <div class="card">
                <div class="card-body">
                    @if($impacts->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Employee</th>
                                        <th>Training Program</th>
                                        <th>Before Score</th>
                                        <th>After Score</th>
                                        <th>Improvement</th>
                                        <th>Training Date</th>
                                        <th>Measured Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($impacts as $impact)
                                        <tr>
                                            <td>
                                                <strong>{{ $impact->employee->full_name }}</strong><br>
                                                <small class="text-muted">{{ $impact->employee->position?->title }}</small>
                                            </td>
                                            <td>
                                                <strong>{{ $impact->trainingProgram->title }}</strong><br>
                                                <small class="text-muted">{{ $impact->trainingProgram->category->name }}</small>
                                            </td>
                                            <td>
                                                <span class="badge bg-secondary">{{ number_format($impact->performance_score_before, 2) }}</span>
                                            </td>
                                            <td>
                                                <span class="badge bg-primary">{{ number_format($impact->performance_score_after, 2) }}</span>
                                            </td>
                                            <td>
                                                @php
                                                    $improvement = $impact->performance_improvement;
                                                    $color = $improvement > 0 ? 'success' : ($improvement < 0 ? 'danger' : 'secondary');
                                                    $icon = $improvement > 0 ? 'arrow-up' : ($improvement < 0 ? 'arrow-down' : 'dash');
                                                @endphp
                                                <span class="badge bg-{{ $color }}">
                                                    <i class="bi bi-{{ $icon }}"></i> {{ number_format($improvement, 2) }}
                                                    @if($impact->performance_improvement_percentage)
                                                        ({{ number_format($impact->performance_improvement_percentage, 1) }}%)
                                                    @endif
                                                </span>
                                            </td>
                                            <td>{{ $impact->training_completed_date->format('M j, Y') }}</td>
                                            <td>{{ $impact->performance_measured_date->format('M j, Y') }}</td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    @can('view', $impact)
                                                        <a href="{{ route('training.performance.show', $impact) }}" class="btn btn-outline-primary">
                                                            <i class="bi bi-eye"></i>
                                                        </a>
                                                    @endcan
                                                    @can('update', $impact)
                                                        <a href="{{ route('training.performance.edit', $impact) }}" class="btn btn-outline-secondary">
                                                            <i class="bi bi-pencil"></i>
                                                        </a>
                                                    @endcan
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            {{ $impacts->appends(request()->query())->links() }}
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="bi bi-graph-up fs-1 text-muted"></i>
                            <h4 class="mt-3">No Performance Impact Records</h4>
                            <p class="text-muted">No training performance impact records found matching your criteria.</p>
                            @can('create', App\Models\TrainingPerformanceImpact::class)
                                <a href="{{ route('training.performance.create') }}" class="btn btn-primary">
                                    Record First Impact
                                </a>
                            @endcan
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Auto-Track Modal -->
@can('create', App\Models\TrainingPerformanceImpact::class)
    <div class="modal fade" id="autoTrackModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST" action="{{ route('training.performance.auto-track') }}">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title">Auto-Track Performance Impact</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="days_after_training" class="form-label">Days After Training Completion</label>
                            <input type="number" class="form-control" id="days_after_training" name="days_after_training" 
                                   value="90" min="30" max="365" required>
                            <div class="form-text">
                                System will look for performance reviews this many days after training completion to measure impact.
                            </div>
                        </div>
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle"></i>
                            This will automatically create performance impact records for completed trainings that have before/after performance reviews available.
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Start Auto-Tracking</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endcan
@endsection