@extends('layouts.app')

@section('title', 'Training Analytics')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Training Analytics</h1>
                <a href="{{ route('training.performance.index') }}" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Back to Performance Impact
                </a>
            </div>

            <!-- Program Effectiveness -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-trophy"></i> Training Program Effectiveness</h5>
                </div>
                <div class="card-body">
                    @if($programEffectiveness->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Training Program</th>
                                        <th>Impact Records</th>
                                        <th>Avg. Improvement</th>
                                        <th>Positive Impacts</th>
                                        <th>Success Rate</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($programEffectiveness as $program)
                                        <tr>
                                            <td><strong>{{ $program->title }}</strong></td>
                                            <td>{{ $program->impact_count }}</td>
                                            <td>
                                                @php
                                                    $improvement = $program->avg_improvement;
                                                    $color = $improvement > 0 ? 'success' : ($improvement < 0 ? 'danger' : 'secondary');
                                                    $icon = $improvement > 0 ? 'arrow-up' : ($improvement < 0 ? 'arrow-down' : 'dash');
                                                @endphp
                                                <span class="badge bg-{{ $color }}">
                                                    <i class="bi bi-{{ $icon }}"></i> {{ number_format($improvement, 2) }}
                                                </span>
                                            </td>
                                            <td>{{ $program->positive_impacts }}</td>
                                            <td>
                                                @php
                                                    $successRate = $program->impact_count > 0 ? ($program->positive_impacts / $program->impact_count) * 100 : 0;
                                                @endphp
                                                <div class="progress" style="height: 20px;">
                                                    <div class="progress-bar bg-{{ $successRate >= 70 ? 'success' : ($successRate >= 50 ? 'warning' : 'danger') }}" 
                                                         style="width: {{ $successRate }}%">
                                                        {{ number_format($successRate, 1) }}%
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="bi bi-graph-up fs-1 text-muted"></i>
                            <h5 class="mt-3">No Program Effectiveness Data</h5>
                            <p class="text-muted">Start recording training performance impacts to see program effectiveness.</p>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Monthly Trends -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-graph-up"></i> Monthly Impact Trends</h5>
                </div>
                <div class="card-body">
                    @if($monthlyTrends->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Month</th>
                                        <th>Total Impacts</th>
                                        <th>Avg. Improvement</th>
                                        <th>Positive Impacts</th>
                                        <th>Success Rate</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($monthlyTrends as $trend)
                                        <tr>
                                            <td><strong>{{ \Carbon\Carbon::createFromFormat('Y-m', $trend->month)->format('M Y') }}</strong></td>
                                            <td>{{ $trend->total_impacts }}</td>
                                            <td>
                                                @php
                                                    $improvement = $trend->avg_improvement;
                                                    $color = $improvement > 0 ? 'success' : ($improvement < 0 ? 'danger' : 'secondary');
                                                    $icon = $improvement > 0 ? 'arrow-up' : ($improvement < 0 ? 'arrow-down' : 'dash');
                                                @endphp
                                                <span class="badge bg-{{ $color }}">
                                                    <i class="bi bi-{{ $icon }}"></i> {{ number_format($improvement, 2) }}
                                                </span>
                                            </td>
                                            <td>{{ $trend->positive_impacts }}</td>
                                            <td>
                                                @php
                                                    $successRate = $trend->total_impacts > 0 ? ($trend->positive_impacts / $trend->total_impacts) * 100 : 0;
                                                @endphp
                                                <span class="badge bg-{{ $successRate >= 70 ? 'success' : ($successRate >= 50 ? 'warning' : 'danger') }}">
                                                    {{ number_format($successRate, 1) }}%
                                                </span>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="bi bi-calendar3 fs-1 text-muted"></i>
                            <h5 class="mt-3">No Monthly Trend Data</h5>
                            <p class="text-muted">Training impact data will appear here as you record more impacts over time.</p>
                        </div>
                    @endif
                </div>
            </div>

            <div class="row">
                <!-- Top Improved Employees -->
                <div class="col-md-6">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-person-check"></i> Top Improved Employees</h5>
                        </div>
                        <div class="card-body">
                            @if($topImprovedEmployees->count() > 0)
                                <div class="list-group list-group-flush">
                                    @foreach($topImprovedEmployees as $employee)
                                        <div class="list-group-item d-flex justify-content-between align-items-center">
                                            <div>
                                                <strong>{{ $employee->first_name }} {{ $employee->last_name }}</strong><br>
                                                <small class="text-muted">{{ $employee->training_count }} trainings completed</small>
                                            </div>
                                            <div class="text-end">
                                                <span class="badge bg-success">
                                                    +{{ number_format($employee->avg_improvement, 2) }} avg
                                                </span><br>
                                                <small class="text-muted">{{ number_format($employee->total_improvement, 2) }} total</small>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="text-center py-4">
                                    <i class="bi bi-people fs-1 text-muted"></i>
                                    <h6 class="mt-3">No Employee Data</h6>
                                    <p class="text-muted small">Employee improvement data will appear here.</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Skills Development Impact -->
                <div class="col-md-6">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-gear"></i> Skills Development Impact</h5>
                        </div>
                        <div class="card-body">
                            @if($skillsImpact->count() > 0)
                                <div class="list-group list-group-flush">
                                    @foreach($skillsImpact as $skill)
                                        <div class="list-group-item d-flex justify-content-between align-items-center">
                                            <div>
                                                <strong>{{ $skill['skill_name'] }}</strong><br>
                                                <small class="text-muted">{{ $skill['employees_impacted'] }} employees impacted</small>
                                            </div>
                                            <div class="text-end">
                                                <span class="badge bg-primary">
                                                    +{{ number_format($skill['avg_improvement'], 2) }} avg
                                                </span><br>
                                                <small class="text-muted">{{ $skill['total_improvements'] }} improvements</small>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="text-center py-4">
                                    <i class="bi bi-tools fs-1 text-muted"></i>
                                    <h6 class="mt-3">No Skills Data</h6>
                                    <p class="text-muted small">Skills improvement data will appear here.</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Summary Cards -->
            <div class="row">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body text-center">
                            <i class="bi bi-graph-up fs-1"></i>
                            <h4 class="mt-2">{{ $programEffectiveness->count() }}</h4>
                            <p class="mb-0">Programs Analyzed</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body text-center">
                            <i class="bi bi-calendar3 fs-1"></i>
                            <h4 class="mt-2">{{ $monthlyTrends->count() }}</h4>
                            <p class="mb-0">Months of Data</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body text-center">
                            <i class="bi bi-people fs-1"></i>
                            <h4 class="mt-2">{{ $topImprovedEmployees->count() }}</h4>
                            <p class="mb-0">Top Performers</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body text-center">
                            <i class="bi bi-tools fs-1"></i>
                            <h4 class="mt-2">{{ $skillsImpact->count() }}</h4>
                            <p class="mb-0">Skills Improved</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection