@extends('layouts.app')
@section('title', $learningPath->title)
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Learning Paths', 'url' => route('training.learning-paths.index')],
    ['label' => $learningPath->title]
]" />

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">{{ $learningPath->title }}</h1>
                <div class="btn-group">
                    <a href="{{ route('training.learning-paths.index') }}" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Back
                    </a>
                    @can('update', $learningPath)
                        <a href="{{ route('training.learning-paths.edit', $learningPath) }}" class="btn btn-primary">
                            <i class="bi bi-pencil"></i> Edit
                        </a>
                    @endcan
                </div>
            </div>

            <div class="row">
                <div class="col-md-8">
                    <x-info-card>
                        @if($learningPath->image_path)
                            <img src="{{ asset('storage/' . $learningPath->image_path) }}" 
                                 class="card-img-top mb-3" alt="{{ $learningPath->title }}" 
                                 style="height: 300px; object-fit: cover; border-radius: 8px;">
                        @endif
                        <div class="d-flex justify-content-between align-items-start mb-3">
                            <div>
                                <h5 class="card-title">{{ $learningPath->title }}</h5>
                                <span class="badge bg-{{ $learningPath->difficulty_color }} me-2">
                                    {{ ucfirst($learningPath->difficulty_level) }}
                                </span>
                                @if(!$learningPath->is_active)
                                    <span class="badge bg-secondary">Inactive</span>
                                @endif
                            </div>
                        </div>
                        
                        <p class="card-text">{{ $learningPath->description }}</p>

                        @if($learningPath->learning_outcomes && count($learningPath->learning_outcomes) > 0)
                            <div class="mb-3">
                                <h6 class="text-muted">Learning Outcomes:</h6>
                                <ul class="mb-0">
                                    @foreach($learningPath->learning_outcomes as $outcome)
                                        <li>{{ $outcome }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <div class="row text-center mt-4">
                            <div class="col-md-3">
                                <h6 class="text-muted">Steps</h6>
                                <h4>{{ $learningPath->total_steps }}</h4>
                            </div>
                            <div class="col-md-3">
                                <h6 class="text-muted">Duration</h6>
                                <h4>{{ $learningPath->estimated_duration_hours }}h</h4>
                            </div>
                            <div class="col-md-3">
                                <h6 class="text-muted">Enrollments</h6>
                                <h4>{{ $stats['total_enrollments'] }}</h4>
                            </div>
                            <div class="col-md-3">
                                <h6 class="text-muted">Completion Rate</h6>
                                <h4>{{ number_format($stats['completion_rate'], 1) }}%</h4>
                            </div>
                        </div>
                    </x-info-card>

                    <x-info-card title="Learning Path Steps" icon="list-ol" class="mt-4">
                        @if($learningPath->steps->count() > 0)
                            @foreach($learningPath->steps as $step)
                                <div class="d-flex align-items-start mb-4 {{ !$loop->last ? 'border-bottom pb-4' : '' }}">
                                    <div class="flex-shrink-0 me-3">
                                        <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center" 
                                             style="width: 40px; height: 40px;">
                                            {{ $step->step_order }}
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <h6 class="mb-0">{{ $step->trainingProgram->title }}</h6>
                                            <div>
                                                @if($step->is_required)
                                                    <span class="badge bg-danger">Required</span>
                                                @else
                                                    <span class="badge bg-secondary">Optional</span>
                                                @endif
                                            </div>
                                        </div>
                                        <p class="text-muted mb-2">{{ Str::limit($step->trainingProgram->description, 150) }}</p>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <small class="text-muted">
                                                    <i class="bi bi-clock"></i> {{ $step->trainingProgram->duration_hours }} hours
                                                    <i class="bi bi-tag ms-2"></i> {{ $step->trainingProgram->category->name }}
                                                </small>
                                            </div>
                                            <div class="col-md-6 text-end">
                                                <a href="{{ route('training.programs.show', $step->trainingProgram) }}" 
                                                   class="btn btn-outline-primary btn-sm">
                                                    <i class="bi bi-eye"></i> View Program
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            <x-empty-state 
                                icon="list-ol"
                                message="No steps added to this learning path yet" />
                        @endif
                    </x-info-card>
                </div>

                <div class="col-md-4">
                    <x-info-card title="Target Roles" icon="people">
                        @if($learningPath->target_roles && count($learningPath->target_roles) > 0)
                            <ul class="list-unstyled mb-0">
                                @foreach($learningPath->target_roles as $roleId)
                                    @php
                                        $position = \App\Models\Position::find($roleId);
                                    @endphp
                                    @if($position)
                                        <li class="mb-2">
                                            <i class="bi bi-check-circle text-success me-2"></i>
                                            {{ $position->title }}
                                        </li>
                                    @endif
                                @endforeach
                            </ul>
                        @else
                            <p class="text-muted mb-0">No specific roles targeted</p>
                        @endif
                    </x-info-card>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
